<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblSectionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_section', function (Blueprint $table) {
            $table->integer('section_id', true);
            $table->integer('section_status');
            $table->string('section_ip', 100);
            $table->string('section_name', 100)->nullable();
            $table->string('section_name_multi_language', 999)->nullable();
            $table->string('section_recipies', 999)->nullable();
            $table->integer('section_active_status')->nullable()->default(0);
            $table->string('section_permalink', 100)->nullable();
            $table->integer('added_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_section');
    }
}
