<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblResturantTableTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_resturant_table', function (Blueprint $table) {
            $table->integer('table_id', true);
            $table->integer('table_status');
            $table->string('table_name', 100);
            $table->integer('table_seating_count');
            $table->string('table_format', 100)->nullable();
            $table->integer('table_active_status');
            $table->string('table_tracking_status', 100)->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_resturant_table');
    }
}
