<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblRecipeVarientTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_recipe_varient', function (Blueprint $table) {
            $table->integer('varient_id', true);
            $table->integer('varient_status')->nullable();
            $table->integer('default_status')->default(0);
            $table->integer('recipe_id')->nullable();
            $table->string('varient_name', 100)->nullable();
            $table->float('varient_price', 10)->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_recipe_varient');
    }
}
