<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblPromotionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_promotions', function (Blueprint $table) {
            $table->integer('promotion_id', true);
            $table->integer('promotion_status');
            $table->string('promotion_name', 100);
            $table->string('promotion_desc', 250);
            $table->integer('promotion_discount_type')->comment('0->amount,1->percentage
');
            $table->float('promotion_discount', 10);
            $table->string('from_date', 100);
            $table->string('to_date', 100);
            $table->string('promotion_customers', 250);
            $table->string('promotion_recipies', 250);
            $table->integer('promotion_active_status');
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_promotions');
    }
}
