<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_customers', function (Blueprint $table) {
            $table->integer('customer_id', true);
            $table->string('customer_ip', 100);
            $table->integer('customer_status')->default(0);
            $table->string('customer_unique_id', 50)->nullable();
            $table->string('customer_name', 100);
            $table->string('customer_mob', 100);
            $table->string('customer_mail_id', 250)->nullable();
            $table->string('customer_q_id', 100)->nullable();
            $table->string('company_name', 250)->nullable();
            $table->string('customer_address', 500)->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_customers');
    }
}
