<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblPromocodesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_promocodes', function (Blueprint $table) {
            $table->integer('promocode_id', true);
            $table->integer('promocode_status')->default(0);
            $table->string('promocode_name', 100);
            $table->string('promocode_short_code', 100);
            $table->integer('promocode_offer_type')->comment('0->amount,1->percentage');
            $table->float('promocode_amount_or_discount', 10);
            $table->float('promocode_min_purchase_amt', 10);
            $table->string('promocode_from_date', 10);
            $table->string('promocode_to_date', 10);
            $table->integer('promocode_maximum_usage_per_customer')->default(0);
            $table->integer('promocode_maximum_usage');
            $table->integer('promocode_usage_count')->default(0);
            $table->integer('promocode_active_status')->default(0);
            $table->timestamp('created_at')->useCurrent();
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_promocodes');
    }
}
