<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblLoginAttemptLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_login_attempt_log', function (Blueprint $table) {
            $table->integer('login_attempt_id', true);
            $table->integer('login_attempt_status')->default(0);
            $table->string('login_attempt_ip', 100)->nullable();
            $table->string('login_attempt_email', 100)->nullable();
            $table->string('login_attempt_password', 100)->nullable();
            $table->string('login_attempt_result', 100)->nullable();
            $table->string('login_attempt_date', 100)->nullable();
            $table->string('login_attempt_time', 100)->nullable();
            $table->text('login_attempt_header_details')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_login_attempt_log');
    }
}
