<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblLayoutTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_layout', function (Blueprint $table) {
            $table->integer('layout_id', true);
            $table->integer('layout_status')->default(0);
            $table->string('layout_type', 20)->nullable();
            $table->string('website_name', 100)->nullable();
            $table->string('website_email', 100)->nullable();
            $table->string('website_phone', 100)->nullable();
            $table->string('website_address', 100)->nullable();
            $table->integer('website_country')->nullable();
            $table->string('webste_logo', 200)->nullable();
            $table->string('website_icon', 200)->nullable();
            $table->string('theme_color', 100)->nullable();
            $table->string('website_title', 500)->nullable();
            $table->text('meta_data')->nullable();
            $table->string('admin_theme_color', 100);
            $table->text('admin_logo');
            $table->text('admin_d_logo');
            $table->text('admin_logo_sm');
            $table->text('admin_d_logo_sm');
            $table->text('admin_background_image')->nullable();
            $table->string('developed_by', 100);
            $table->string('developer_link', 100);
            $table->integer('notification_sound');
            $table->string('mail_mailer', 100)->nullable();
            $table->string('mail_host', 100)->nullable();
            $table->string('mail_port', 100)->nullable();
            $table->string('mail_username', 100)->nullable();
            $table->string('mail_password', 100)->nullable();
            $table->string('mail_encription', 100)->nullable();
            $table->string('sms_username', 100)->nullable();
            $table->string('sms_password', 100)->nullable();
            $table->string('sms_sid', 100)->nullable();
            $table->string('sms_m_type', 100)->nullable();
            $table->string('facebook_link', 100)->nullable();
            $table->string('instagram_link', 100)->nullable();
            $table->string('twitter_link', 100)->nullable();
            $table->string('youtube_link', 100)->nullable();
            $table->string('whats_app_number', 100)->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_layout');
    }
}
