<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblImageResultionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_image_resultions', function (Blueprint $table) {
            $table->integer('image_resolution_id', true);
            $table->integer('image_resolution_status')->nullable();
            $table->string('image_resolution_ip', 100)->nullable();
            $table->string('image_resolution_name', 200)->nullable();
            $table->string('image_resolution_dimenssion', 100)->nullable();
            $table->integer('image_size')->nullable();
            $table->string('env_para_name', 100)->nullable();
            $table->string('env_file_para_name', 100);
            $table->integer('showing_order');
            $table->integer('added_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_image_resultions');
    }
}
