<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblGiftcardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_giftcards', function (Blueprint $table) {
            $table->integer('giftcard_id', true);
            $table->integer('giftcard_status')->default(0);
            $table->string('giftcard_name', 100);
            $table->float('giftcard_amount', 10);
            $table->integer('giftcard_validity');
            $table->integer('giftcard_active_status');
            $table->timestamp('created_at')->useCurrent();
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_giftcards');
    }
}
