<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCategoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_category', function (Blueprint $table) {
            $table->integer('category_id', true);
            $table->integer('category_status')->default(0);
            $table->string('category_ip', 100);
            $table->string('category_name', 100);
            $table->string('category_name_multi_language', 1000)->nullable();
            $table->text('category_icon');
            $table->string('category_banner_heading', 100)->nullable();
            $table->string('category_multi_banner_heading', 100)->nullable();
            $table->string('category_banner_description', 999)->nullable();
            $table->string('category_multi_banner_description', 999)->nullable();
            $table->string('category_banner', 100)->nullable();
            $table->text('category_permalink')->nullable();
            $table->integer('created_by');
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('priority')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_category');
    }
}
