<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_orders', function (Blueprint $table) {
            $table->integer('order_id', true);
            $table->integer('order_status');
            $table->string('order_ip', 100);
            $table->date('order_date');
            $table->string('order_time', 10);
            $table->string('order_unique_id', 100);
            $table->integer('order_customer_id');
            $table->string('order_customer_name', 100);
            $table->string('order_customer_mob', 100);
            $table->integer('order_table_id')->nullable();
            $table->float('order_cost', 10);
            $table->float('order_net_amount', 10);
            $table->float('order_discount_amt', 10);
            $table->float('order_profit', 10);
            $table->float('order_grand_total', 10);
            $table->string('order_tracking_status', 20);
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_orders');
    }
}
