<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_order_items', function (Blueprint $table) {
            $table->integer('order_item_id', true);
            $table->integer('order_item_status');
            $table->string('order_item_ip', 20);
            $table->integer('order_id');
            $table->integer('recipe_id');
            $table->string('order_item_name', 100);
            $table->integer('order_item_quantity');
            $table->float('order_item_cost', 10);
            $table->float('order_item_netamount', 10);
            $table->float('order_discount_amt', 10);
            $table->float('order_profit', 10);
            $table->float('order_grand_total', 10);
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_order_items');
    }
}
