<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblSubscriptionTypeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_subscription_type', function (Blueprint $table) {
            $table->integer('subscription_type_id', true);
            $table->integer('subscription_type_status')->default(0);
            $table->string('subscription_type_ip', 100)->nullable();
            $table->string('subscription_type_name', 100)->nullable();
            $table->text('subscription_type_description')->nullable();
            $table->integer('subscription_type_days')->nullable();
            $table->float('subscription_type_price', 10)->nullable();
            $table->timestamp('created_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('created_by')->nullable();
            $table->timestamp('updated_at', 6)->default('CURRENT_TIMESTAMP(6)');
            $table->integer('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_subscription_type');
    }
}
