<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblPointsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_points', function (Blueprint $table) {
            $table->integer('point_id', true);
            $table->integer('point_status');
            $table->float('money_needed_for_1_point', 10)->comment('How much QR needed for 1 point credit to customer');
            $table->float('one_point_value', 10)->comment('1 Point = How much QR');
            $table->integer('min_amount_redeem_point')->comment('Minimum purchase amount for redeem points');
            $table->integer('point_validity')->comment('Points validity(Days)');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_points');
    }
}
