<?php

namespace App\imports;

use App\Models\Categoryimport;

use App\Models\RecipieAddOnImport;
use App\Models\Recipeimport;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Str;

class RecipeImportexcel implements ToCollection, WithHeadingRow
{
    private $languageId;

    public function __construct()
    {
        // Assuming 'English' has an ID of 1, as per your tbl_languages image.
        $this->languageId = 1;
    }

    public function collection(Collection $rows)
    {
        $currentRecipe = null;
        $free_count = null;
        $add_on_group = null;

        $free_count = null;
        foreach ($rows as $key => $row) {
            //dd($key, $row);
            $categoryname = ucfirst(strtolower($row['category']));
            // This row represents a new recipe.
            $category = Categoryimport::firstOrCreate(

                ['category_name' => ucfirst(strtolower($row['category']))],
                [
                    'category_name_ar' => $row['category_arabic'],
                    'category_status' => 0,
                    'created_by' => 1,
                    'category_ip' => request()->ip(),
                    'category_banner_heading' => $categoryname,
                    'category_banner_description' => $categoryname,
                    'category_permalink' => Str::slug($categoryname),
                    'category_name_multi_language' => json_encode([$this->languageId => $categoryname]),
                    'category_multi_banner_heading' => json_encode([$this->languageId => $categoryname]),
                    'category_multi_banner_description' => json_encode([$this->languageId => $categoryname]),
                ],
            );

            if ($category->id) session(['current_category_id' => $category->id]);
            $categoryId = session('current_category_id');
            $recipename = ucfirst(strtolower($row['menu_name_in_pos']));
            #Assuming subcategory might not always be present
            if ($categoryId) {
                $currentRecipe = Recipeimport::create([
                    'recipe_status' => 0,
                    'recipe_ip' => request()->ip(),
                    'recipe_category_id' => $categoryId,
                    'item_no' => $row['item_no'],
                    'recipe_name' => $row['menu_name_in_pos'],
                    'recipe_name_ar' => $row['menu_name_in_arabic'],
                    'recipe_name_multi_language' => json_encode([$this->languageId => $row['menu_name_in_pos']]),
                    //'recipe_description' => $row['description_english'],
                    //'recipe_description_multi_language' => json_encode([$this->languageId => $row['description_english']]),
                    'recipe_veg_or_non' => 2,
                    'recipe_active_status' => 1,
                    'recipe_price' => $row['menu_price'],
                    'recipe_stock' => 100000,
                    'recipe_permalink' => Str::slug($recipename),
                    'created_by' => 1,
                    'updated_by' => 1,
                ]);
            }

        }
    }
}
