<?php

use Illuminate\Support\Facades\DB;
use App\Models\branchModel;
use App\Models\layoutModel;
use App\Models\subscriptionhistoryModel;
use App\Models\templateModel;
use App\Models\languageModel;
use App\Models\stocklogModel;
use App\Models\recipeModel;
use App\Models\inventoryModel;
use App\Models\inventoryitemModel;
use App\Models\promocodeModel;

// use Image;


function permalink_generator($permalink)
{
    $permalink = preg_replace('/[0-9\@\.\;\" "]+/', '', $permalink);
    $permalink = str_replace(' ', '', $permalink);
    $permalink = strtolower($permalink);
    return $permalink;
}


function user_activity_log($user_activity_log)
{
    $insert_to_user_activity_log = DB::table('user_activity_logs')->insert($user_activity_log);
}

function get_branch_data($branch_id = 1)
{
    $branch_data = layoutModel::select('website_name as branch_name', 'website_email as branch_email', 'website_phone as branch_mob', 'website_address as branch_address', 'admin_logo', 'theme_color')->first();
    return $branch_data;

}

function layout_session()
{
//    if(!session('layout_data')){
    $layout_data = layoutModel::select('website_name', 'website_link', 'website_email', 'website_phone', 'website_address', 'webste_logo', 'website_icon', 'theme_color', 'website_title', 'meta_data', 'admin_theme_color', 'admin_logo', 'admin_d_logo', 'admin_logo_sm', 'admin_d_logo_sm', 'admin_background_image', 'developed_by', 'developer_link', 'notification_sound', 'tbl_countries.currency', 'tbl_countries.mobile_number_length as mobile_max_length', 'facebook_link', 'instagram_link', 'twitter_link', 'youtube_link', 'whats_app_number')
        ->leftjoin('tbl_countries', 'tbl_countries.id', 'tbl_layout.website_country')
        ->first();
    Session::put('layout_data', $layout_data);
//    }


}


function get_session_data()
{

    $data = [
        'from_date' => session('from_date'),
        'to_date' => session('to_date')
    ];
    return $data;

}


function check_subscription_status()
{

    //get Subscriptions list

    $get_subsciption_list = subscriptionhistoryModel::where('subscription_history_status', 0)
        ->where('subscription_current_status', '!=', 'Expired')
        ->get()->toarray();
    $active_subscription = false;
    foreach ($get_subsciption_list as $subsciption) {

        if ($subsciption['subscription_to_date'] < date('Y-m-d')) { //Update Status Expired
            $status = "Expired";
        }

        if ($subsciption['subscription_to_date'] >= date('Y-m-d')) { //Update Status Expired
            $status = "Actived";
            $active_subscription = true;
        }


        if ($subsciption['subscription_from_date'] > date('Y-m-d')) { //Starting Date Greter Than Today Daye

            $status = "Hold";
        }
        if ($subsciption['subscription_from_date'] <= date('Y-m-d') && $subsciption['subscription_to_date'] >= date('Y-m-d')) {
            $status = "Actived";
            $active_subscription = true;
        }

        $update_status = subscriptionhistoryModel::where('subscription_history_id', $subsciption['subscription_history_id'])->update(['subscription_current_status' => $status]);


    }

    return $active_subscription;


}

function subscription_days_left()
{
    $get_subsciption_list = subscriptionhistoryModel::where('subscription_history_status', 0)
        ->where('subscription_current_status', '!=', 'Expired')
        ->get()->toarray();
    $days = 0;
    foreach ($get_subsciption_list as $get_subsciption) {
        if ($get_subsciption['subscription_current_status'] == "Actived") {
            $firstDate = $get_subsciption['subscription_to_date'];

            $firstDate = new DateTime($get_subsciption['subscription_to_date']);
            $secondDate = new DateTime(date('Y-m-d'));

            $interval = $firstDate->diff($secondDate);
            $days = $days + $interval->format('%a');
        } elseif ($get_subsciption['subscription_current_status'] == "Hold") {

            $days = $days + $get_subsciption['subscription_days'];

        }

    }

    $subscribe_end_date = date('Y-m-d', strtotime(date('Y-m-d') . ' + ' . $days . ' days'));
    $time = date('h:i:s a');
    $datetime1 = new DateTime($time);
    $datetime2 = new DateTime('11:59:59 PM');
    $interval = $datetime1->diff($datetime2);
    $data['day_left'] = $days;
    $data['hours_left'] = $interval->format('%h');
    $data['minute_left'] = $interval->format('%i');
    return $data;

}


function send_sms($mobile, $message)
{
    $branch_data = layoutModel::select('*')->first();
    $company_name = $branch_data->website_name;
    $sms_username = $branch_data->sms_username;
    $sms_password = $branch_data->sms_password;
    $sms_sid = str_replace(' ', '%20', $branch_data->sms_sid);
    $sms_m_type = $branch_data->sms_m_type;
    $message = urlencode($message);
    $url = 'https://api.smscountry.com/SMSCwebservice_bulk.aspx?User=' . $sms_username . '&passwd=' . $sms_password . '&mobilenumber=' . $mobile . '&message=' . $message . '&sid=' . $sms_sid . '&mtype=' . $sms_m_type . '&DR=Y';
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    curl_exec($ch);
    curl_close($ch);

}

function image_validation_rule($validation_page, $validation_image_size, $required = "", $file_size = "2048")
{
    $sizes = get_image_sizes($validation_image_size);
    $width = $sizes['width'];
    $height = $sizes['height'];
    $get_lowst_ratio = get_lowst_ratio($width, $height);
    $lowest_ratio1 = $width / $get_lowst_ratio;
    $lowest_ratio2 = $height / $get_lowst_ratio;

    if ($required == true) {
        //return ['required', 'image', 'mimes:jpeg,png,jpg,gif', 'max:' . $file_size];
        return ['required', 'image', 'mimes:png,jpg', 'max:' . $file_size];

    } else {
        //return ['image', 'mimes:jpeg,png,jpg,gif', 'max:' . $file_size];
        return ['image', 'mimes:png,jpg', 'max:' . $file_size];
    }
}


function convertToWebP($webp_image, $webp_file_location)
{
    $webp_image->encode('webp', 75)->save($webp_file_location);
    return;
}

function get_image_sizes($image_sizes)
{   //passing Env Variable To This Function And get Width And Height Seperate
    $sizes = explode("x", $image_sizes);
    $data['width'] = $sizes[0];
    $data['height'] = $sizes[1];
    return $data;
}

function get_lowst_ratio($a, $b)
{
    while ($b != 0) {
        $remainder = $a % $b;
        $a = $b;
        $b = $remainder;
    }
    return $a;
}

function get_available_language()
{
    $get_languages = languageModel::select('language_id', 'language_short_code', 'language_name', 'language_permalink')->where('language_status', 0)->orderby('language_id', 'ASC')->get()->toArray();
    return $get_languages;
}

function validation_array($page, $dynamic_inputs)
{
    $validation_array = array();
    $custom_validation_array = array();
    if ($page == "category" || $page == "subcategory" || $page = "recipe" || $page = "section" || $page = "banner") {
        foreach ($dynamic_inputs as $dynamic_input) {
            //get available_language
            $languages = get_available_language();
            foreach ($languages as $language) {
                $validation_array[$dynamic_input . '_' . $language['language_id']] = "required";
                $custom_validation_array[$dynamic_input . '_' . $language['language_id'] . '.required'] = $dynamic_input . ' ' . $language['language_name'] . ' Required';

            }

        }

    }


    $validation['validation_array'] = $validation_array;
    $validation['custom_validation_array'] = $custom_validation_array;
    return $validation;

}

function get_mutli_language_json_input($request, $request_para)
{
    $multi_language_names = array();
    $languages = get_available_language();
    switch ($request_para) {
        case "category_name_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "category_name_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "category_banner_heading_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "category_banner_heading_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "category_banner_description_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "category_banner_description_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "subcategory_name_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "subcategory_name_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "subcategory_banner_name_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "subcategory_banner_name_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "subcategory_banner_description_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "subcategory_banner_description_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "recipe_name_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "recipe_name_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "description_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "description_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "section_name_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "section_name_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "adds_on_name_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "adds_on_name_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;

        case "banner_heading_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "banner_heading_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        case "banner_description_":
            foreach ($languages as $language) {
                $language_id = $language['language_id'];
                $request_para = "banner_description_" . $language_id;
                $multi_language_names[$language_id] = $request[$request_para];
            }
            break;
        default:

    }
    return $multi_language_names = json_encode($multi_language_names);

}

function image_upload($image, $original_image_destination, $desination_path, $image_resolution)
{
    //Save Original Image
    $image_name = date('YmdHis') . rand(1000, 9999);
    $original_image_name = date('YmdHis') . rand(1000, 9999) . "." . $image->getClientOriginalExtension();
    $image_library = Image::make($image->getRealPath());
    $image->move($original_image_destination, $original_image_name);
    //End Of Save Original Image
    $sizes = get_image_sizes($image_resolution);   //Fetching Image Sizes

    //Png Conversion
    $original_Path = $original_image_destination . '' . $original_image_name;
    if ($image->getClientOriginalExtension() != "png") {  //If Not A Png Image Converto To Png
        $pngPath = $desination_path . '' . $image_name . '.png';
    } else {   //If Uploading PNG Image
        $pngPath = $desination_path . '' . $image_name . '.' . $image->getClientOriginalExtension();
    }
    $png_conversion = Image::make($original_Path);
    $png_conversion->resize($sizes['width'], $sizes['height']);
    $png_conversion->save($pngPath);
    //End Of Png Conversion
    //Webp Image Conversionection
    $pngPath = public_path($desination_path . '' . $image_name . '.png');
    //$webp_file_location = public_path($desination_path . '' . $image_name . '.webp');
    $webp_file_location = public_path($desination_path . '' . $image_name . '.png');
    $webp_conversion = Image::make($pngPath);
    $webp_conversion->resize($sizes['width'], $sizes['height']);
    $webp_conversion->save($webp_file_location);
    //$image_name = $image_name . '.webp';
    $image_name = $image_name . '.png';
    //End Of Webp Image Conversionection
    return $image_name;

}

function reset_session($session_array)
{

    foreach ($session_array as $session) {
        session()->forget($session);

    }

}

function stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment)
{

    //Update Stock_Section
    $update = recipeModel::where('recipe_id', $recipe_id)->update(['recipe_stock' => $stock_updated_qty]);
    //End oF Stock Section
    //Stock Log Section
    $data = ['stock_log_status' => 0,
        'stock_log_date' => date('Y-m-d'),
        'stock_log_time' => date('H:i'),
        'stock_log_item_name' => $recipe_name,
        'stock_log_item_id' => $recipe_id,
        'stock_log_type' => $stock_in_or_out,  //0->in ,1=>out
        'stock_log_current_stock' => $stock_current_qty,
        'stock_log_changing_qty' => $stock_changing_qty,
        'stock_log_updated_qty' => $stock_updated_qty,
        'stock_log_comment' => $comment,
    ];
    if (Auth::user()) {
        $data['created_by'] = Auth::user()->id;
        $data['updated_by'] = Auth::user()->id;
    }

    stocklogModel::insert($data);

    //End Of Stock Log Section


}

function check_promocode_status($promocode_id, $customer_id = "")
{

    $promocode_details = promocodeModel::where('promocode_id', $promocode_id)->first();
    $promocode_maximum_usage_per_customer = $promocode_details->promocode_maximum_usage_per_customer;
    $promocode_maximum_usage = $promocode_details->promocode_maximum_usage;
    $promocode_usage_count = $promocode_details->promocode_usage_count;

    if ($promocode_usage_count >= $promocode_maximum_usage) {  //usage count limit exceded

        return ['status' => 1, 'heading' => 'Error', 'msg' => 'Promocode Usage Count Exceeded'];

    }


    if ($customer_id) {  //if customer exist

        $get_customer_promocode_usage = inventoryModel::where('invoice_customer_id', $customer_id)->where('invoice_promocode_id', $promocode_id)->count();

        if ($get_customer_promocode_usage > $promocode_maximum_usage_per_customer) { //Promocode Usage by customer

            return ['status' => 1, 'heading' => 'Error', 'msg' => 'Promocode Usage By customer Count Exceeded'];
        }

    }


    $new_count = $promocode_usage_count + 1;
    $update_usage_count = promocodeModel::where('promocode_id', $promocode_id)->update(['promocode_usage_count' => $new_count]);

    return ['status' => 0, 'heading' => 'Success', 'msg' => 'Promocode applied Succesfully'];


}

function get_active_on($customer_id)
{
    $order = \App\Models\orderModel::where('order_customer_id', $customer_id)->orderBy('order_id', 'desc')->first();

    if($order) {
        return $order->order_date;
    }else{
        return 'NA';
    }
}


?>
