<?php

namespace App\Traits;

use Session;
use App\Models\categoryModel;
use App\Models\subcategoryModel;
use App\Models\sectionModel;
use App\Models\recipeModel;
use App\Models\recipevarientModel;
use App\Models\recipe_add_on_Model;
use Cart;

trait cartTrait
{


    public function add_to_cart_trait($recipe_id, $quantity, $varient_id = "")
    {
        $customer_id = session('customer_cookie_id');
        $recipe = recipeModel::where('recipe_id', $recipe_id)->first();
        $recipe_name = $recipe->recipe_name;
        //$recipe_price = $recipe->recipe_offer_price;
        $recipe_price = $recipe->recipe_price;

        // array format
        $customize_array = array();
        //Add on Section
        $add_ons_array = array();
        // $add_ons=['id'=>1,'add_on_name'=>'test','add_on_quantity'=>2,'add_on_price'=>100];
        // array_push($add_ons_array,$add_ons);
        // $customize_array['add_ons_array']=$add_ons_array;
        // //End Of Add On Section

        //Variant Section
        $variant_array = array();
        if ($varient_id != 0) {
            $varient_fetch = recipevarientModel::select('varient_name', 'varient_price', 'default_status')->where('varient_status', 0)->where('varient_id', $varient_id)->first();
            if ($varient_fetch) {
                $varient_name = $varient_fetch->varient_name;
                $varient_price = $varient_fetch->varient_price;
                $varient_default = $varient_fetch->default_status;
                $variant = ['variant_id' => $varient_id, 'variant_name' => $varient_name, 'variant_quantity' => 1, 'variant_price' => $varient_price, 'variant_default' => $varient_default];
                array_push($variant_array, $variant);
                $customize_array['variant_array'] = $variant_array;
            }
        }
        //End Of VariantSection

        Cart::session($customer_id)->add(array(
            'id' => $recipe_id,
            'name' => $recipe_name,
            'price' => $recipe_price,
            'quantity' => 1,
            'attributes' => $customize_array,
            'associatedModel' => 'Product',
            'attributes' => $customize_array,
        ));


    }

    public function update_cart_quantity($recipe_id, $quantity, $varient_id = "")
    {
        $customize_array = array();
        $customer_id = session('customer_cookie_id');
        $cart_details = json_decode(Cart::session($customer_id)->get($recipe_id), true);

        if ($cart_details) {
            $current_quantity = $cart_details['quantity'];
            if ($current_quantity == 1 && $quantity == -1 && $varient_id == 0) {

                $this->remove_item($recipe_id);
            } else {
                //Variant Section

                if ($varient_id != 0 && $varient_id != "") {  //Varient Product Anel Update Default Varinet Quantity

                    $varient_fetch = recipevarientModel::select('varient_name', 'varient_price')->where('varient_status', 0)->where('varient_id', $varient_id)->first();
                    if ($varient_fetch) {
                        //check recipe_exist
                        $recipe_exist = $this->item_wise_detail($recipe_id);

                        if ($recipe_exist) {
                            $attribute = $recipe_exist['attributes'];
                            if (isset($attribute['addon_array'])) {
                                $customize_array['addon_array'] = $attribute['addon_array'];
                            }
                            if (isset($attribute['variant_array'])) {
                                $varient_array = $attribute['variant_array'];
                                for ($i = 0; $i < count($varient_array); $i++) {

                                    if ($varient_array[$i]['variant_id'] == $varient_id) {
                                        if ($varient_array[$i]['variant_quantity'] == 1 && $quantity == -1) {
                                            unset($varient_array[$i]);
                                        } else {
                                            $varient_array[$i]['variant_quantity'] = $varient_array[$i]['variant_quantity'] + $quantity;
                                        }

                                    }

                                }
                                $varient_array = array_values($varient_array);

                            }
                            if (count($varient_array) > 0) {
                                $customize_array['variant_array'] = $varient_array;
                                Cart::session($customer_id)->update($recipe_id, array(
                                    'quantity' => 0,
                                    'attributes' => $customize_array,
                                ));
                            } else {
                                $this->remove_item($recipe_id);
                            }

                        }

                    }
                } else { //Normal Product Anel
                    Cart::session($customer_id)->update($recipe_id, array(
                        'quantity' => $quantity,
                    ));
                }
            }
        } else {
            $this->add_to_cart_trait($recipe_id, $quantity);
        }
        $cart_details_latest = json_decode(Cart::session($customer_id)->get($recipe_id), true);
        return $cart_details_latest;

    }

    public function item_wise_detail($recipe_id = "")
    {
        $customer_id = session('customer_cookie_id');
        return Cart::session($customer_id)->get($recipe_id);
    }

    public function remove_item($recipe_id)
    {
        $customer_id = session('customer_cookie_id');
        return Cart::session($customer_id)->remove($recipe_id);

    }

    public function cart_clear()
    {
        $customer_id = session('customer_cookie_id');
        Cart::session($customer_id)->clear();
        return true;

    }

    public function update_cart_with_customization($recipe_id, $variantArray, $addonArray)
    {
        $customize_array = $variant_array = $add_on_array = array();
        $customer_id = session('customer_cookie_id');
        $recipe = recipeModel::where('recipe_id', $recipe_id)->first();
        $recipe_name = $recipe->recipe_name;
        $recipe_price = $recipe->recipe_offer_price;

        //Varient Section
        if ($variantArray) {
            foreach ($variantArray as $variant) {
                $varient_id = $variant['id'];
                $quantity = $variant['quantity'];
                //check variant status
                $varient = recipevarientModel::where('varient_status', 0)->where('varient_id', $varient_id)->first();
                if ($varient) {
                    $variant = ['variant_id' => $varient_id, 'variant_name' => $varient->varient_name, 'variant_quantity' => $quantity, 'variant_price' => $varient->varient_price, 'variant_default' => $varient->default_status];
                    array_push($variant_array, $variant);
                }
            }
        }
        //End Of Varient Section

        //Add On Section
        if (!empty($addonArray)) {
            foreach ($addonArray as $addon) {
                $addon_id = $addon['id'];
                $quantity = $addon['quantity'];
                //check variant status
                $addon = recipe_add_on_Model::where('add_on_status', 0)->where('add_on_id', $addon_id)->first();
                if ($addon) {
                    $add_on_name = json_decode($addon->add_on_multi_name, true)[session('website_language')];
                    $add_on_price = $addon->add_on_price;
                    $add_on_image = $addon->add_on_image;
                    $add_ons = ['id' => $addon_id, 'add_on_name' => $add_on_name, 'add_on_quantity' => $quantity, 'add_on_price' => $add_on_price, 'add_on_image' => $add_on_image];
                    array_push($add_on_array, $add_ons);
                }
            }
        }
        //End Of Add On Section

        $customize_array['variant_array'] = $variant_array;
        $customize_array['addon_array'] = $add_on_array;

        Cart::session($customer_id)->add(array(
            'id' => $recipe_id,
            'name' => $recipe_name,
            'price' => $recipe_price,
            'quantity' => 1,
            'associatedModel' => 'Product',
            'attributes' => $customize_array,
        ));

        if ($item_wise_detail = $this->item_wise_detail($recipe_id)) {
            if ($item_wise_detail['quantity'] > 1) {
                $this->update_cart_quantity($recipe_id, -1);
            }
        }

        return $this->item_wise_detail($recipe_id);

    }

    public function update_add_on_data($recipe_id, $addon_id, $quantity)
    {
        $customer_id = session('customer_cookie_id');
        $cart_data = $this->item_wise_detail($recipe_id);   //Get The Specific Recipe Item In Caart

        if ($cart_data) { //Only Existing In Cart
            $customize_array = array();
            $attributes = $cart_data['attributes'];
            if (isset($attributes['variant_array'])) {
                $customize_array['variant_array'] = $attributes['variant_array'];
            }
            if (isset($attributes['addon_array'])) {
                $add_on_array = $attributes['addon_array'];
                for ($i = 0; $i < count($add_on_array); $i++) {
                    $existing_add_on_id = $add_on_array[$i]['id'];
                    $existing_quantity = $add_on_array[$i]['add_on_quantity'];
                    if ($existing_add_on_id == $addon_id) {
                        $new_quantity = $existing_quantity + $quantity;
                        if ($new_quantity == 0) {
                            unset($add_on_array[$i]);

                        } else {
                            $add_on_array[$i]['add_on_quantity'] = $new_quantity;
                        }

                    }

                }
                $add_on_array = array_values($add_on_array);
                $customize_array['addon_array'] = $add_on_array;

                Cart::session($customer_id)->update($recipe_id, array(
                    'attributes' => $customize_array,
                ));
            }

        }

    }

    public function recipe_wise_detail($recipe_id)
    {

        return recipeModel::where('recipe_id', $recipe_id)->first();

    }


    public function check_item_stock($cart_item)
    {

        $item_id = $cart_item['id'];
        $cart_quantity = $cart_item['quantity'];
        $cart_total_quantity = 0;
        // dd($cart_item);
        if (isset($cart_item['attributes'])) {
            $attributes = $cart_item['attributes'];
            if (isset($attributes['variant_array'])) {
                $variant_array = $attributes['variant_array'];
                foreach ($variant_array as $varient) {
                    $varient_quantity = $varient['variant_quantity'];
                    $cart_total_quantity = $cart_total_quantity + $varient_quantity;
                }
            }
        }

        if ($cart_total_quantity == 0) {

            $cart_total_quantity = $cart_quantity;

        }

        $details = $this->recipe_wise_detail($item_id);

        $recipe_name = $details->recipe_name;


        $current_stock = $details->recipe_stock;

        if ($current_stock == 0) {
            $data = ['status' => 1, 'heading' => 'Out Of Stock', 'msg' => $recipe_name . ' is Out of Stock'];
        } else if ($cart_total_quantity > $current_stock) {
            $data = ['status' => 1, 'heading' => 'Stock No Left', 'msg' => $recipe_name . ' is only  ' . $current_stock . ' stock left'];
        } else {
            $data = ['status' => 0, 'heading' => 'Stock Exist', 'msg' => 'Stock Exist'];
        }

        return $data;


    }

}
