<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Config;
use App\Models\layoutModel;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
             if (\Schema::hasTable('tbl_layout')) {
            $mailsetting = layoutModel::first();
            if($mailsetting){
                $data = [
                    'driver'            =>$mailsetting->mail_mailer,
                    'host'              => $mailsetting->mail_host,
                    'port'              => $mailsetting->mail_port,
                    'encryption'        => $mailsetting->mail_encription,
                    'username'          => $mailsetting->mail_username,
                    'password'          => $mailsetting->mail_password,
                    'from'              => [
                        'address'=>$mailsetting->mail_username,
                        'name'   => $mailsetting->website_name,
                    ]
                ];
                Config::set('mail',$data);
            }
        }
    }
}
