<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class recipeModel extends Model
{
    use HasFactory;
    protected $table = 'tbl_recipe';

    protected static function booted()
    {

        static::addGlobalScope('check_status', function ($query) {
            // Apply your default conditions here
            $query->where('recipe_status', 0);
        });
    }

      public function orderItems()
    {
        return $this->hasMany(orderitemModel::class,'recipe_id','recipe_id');
    }

        public function inventory_items()
    {
        return $this->belongsTo(inventoryitemModel::class,'inventory_item_id','recipe_id');
    }


        public function category()
    {
        return $this->belongsTo(categoryModel::class,'recipe_category_id','category_id');
    }

    public function subcategory()
    {
        return $this->belongsTo(subcategoryModel::class,'recipe_subcategory_id','subcategory_id');
    }

     public function recipe_varient()
    {
        return $this->hasMany(recipevarientModel::class,'recipe_id','recipe_id');
    }

    public function recipe_add_on()
    {
        return $this->hasMany(recipe_add_on_Model::class,'recipe_id','recipe_id');
    }
}
