<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class orderModel extends Model
{
    use HasFactory;

    protected $table = "tbl_orders";

    protected static function booted()
    {

        static::addGlobalScope('check_status', function ($query) {
            // Apply your default conditions here
            $query->where('order_status', 0);
        });
    }

    public function table()
    {
        return $this->hasone(tableModel::class, 'table_id', 'order_table_id');
    }

    public function customer()
    {
        return $this->belongsTo(customerModel::class, 'order_customer_id', 'customer_id');
    }

    public function order_items()
    {
        return $this->hasmany(orderitemModel::class, 'order_id', 'order_id');
    }

    public function promocode()
    {
        return $this->Hasone(promocodeModel::class, 'promocode_id', 'order_promocode_id');
    }

    public function customer_cart()
    {
        return $this->hasone(ApiCartModel::class, 'id', 'order_cart_customer_id');
    }
}
