<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiCartRecipeModel extends Model
{
    use HasFactory;

    protected $table = "tbl_api_cart_recipe";

    protected $guarded = [];

    function recipe()
    {
        return $this->belongsTo(recipeModel::class,'recipe_id', 'recipe_id');
    }

    function recipe_add_on()
    {
        return $this->hasMany(ApiCartRecipeAddOnModel::class,'api_cart_recipe_id', 'id');
    }
}
