<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApiCartModel extends Model
{
    use HasFactory;

    protected $table = "tbl_api_cart";

    protected $guarded = [];

    function cart_recipe()
    {
        return $this->hasMany(ApiCartRecipeModel::class,'api_cart_id', 'id');
    }

    function order()
    {
        return $this->hasOne(orderModel::class,'order_cart_customer_id', 'id');
    }

    function branch()
    {
        return $this->hasone(branchModel::class,'id', 'branch_id');
    }
}
