<?php

namespace App\Http\Controllers;

use App\Models\ApiCartModel;
use Exception;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Response;
use Session;
use App\Traits\websiteTrait;
use App\Traits\cartTrait;
use App\Models\bannerModel;
use App\Models\categoryModel;
use App\Models\sectionModel;
use App\Models\recipeModel;
use App\Models\recipe_add_on_Model;
use App\Models\recipevarientModel;
use App\Models\promocodeModel;
use App\Models\tableModel;
use App\Models\customerModel;
use App\Models\orderModel;
use App\Models\orderitemModel;
use App\Jobs\placeorderJob;
use App\Models\order_item_varientModel;
use App\Models\order_item_add_onModel;
use App\Models\notificationModel;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Cart;
use DB;

class websiteController extends Controller
{

    use websiteTrait;
    use cartTrait;

    public function index(Request $request)
    {
        return view('website.spalshscreen');
    }

    public function menu(Request $request)
    {
        $data['banner'] = bannerModel::where('active_status', 1)->orderBy('priority', 'ASC')->get();
        $data['categories'] = categoryModel::orderBy('priority', 'ASC')->get();
        $section_datas = sectionModel::where('section_active_status', 0)->get();
        // foreach($section_datas as $section_data){
        for ($i = 0; $i < count($section_datas); $i++) {
            $secion_id = $section_datas[$i]->section_id;
            $section_item_ids = json_decode($section_datas[$i]->section_recipies, true);
            $items = $this->get_section_products($section_item_ids);
            $section_datas[$i]->section_items = $items;
        }
        $data['section_datas'] = $section_datas;
        return view('website.menu')->with('data', $data);
    }

    public function category_page($permalink)
    {
        //Check permalink exist
        $data = $this->check_permalink('category', $permalink);
        // dd($data);
        if ($data) {
            $section_datas = sectionModel::where('section_active_status', 0)->limit(1)->get();
            //dd($section_datas);
            // foreach($section_datas as $section_data){
            for ($i = 0; $i < count($section_datas); $i++) {
                $secion_id = $section_datas[$i]->section_id;
                $section_item_ids = json_decode($section_datas[$i]->section_recipies, true);
                $items = $this->get_section_products($section_item_ids);
                $section_datas[$i]->section_items = $items;
            }
            $data['section_datas'] = $section_datas;
            return view('website.category')->with('data', $data);
        } else {
            return redirect()->route('404');
        }
    }

    public function search_item(Request $request)
    {

        $search_key = $request->search_key;
        if ($search_key) {
            $data = ['search_key' => $search_key];
        } else {
            $data = ['search_key' => 'all'];
        }


        return redirect()->route('search', $data);
    }

    public function search($search_term)
    {
        $data['recipies'] = $this->check_permalink('search', $search_term);
        if ($data) {
            $data['search_key'] = $search_term;
            return view('website.search')->with('data', $data);
        } else {
            return redirect()->route('404');
        }

    }

    public function recipe_page($permalink)
    {
        $data = $this->check_permalink('recipe', $permalink);

        $cart_data = "";
        if ($data) {
            //Cart Datas
            $recipe_id = $data->recipe_id;
            $cart_data = $this->item_wise_detail($recipe_id);
            //End Of Cart Data
            $section_datas = sectionModel::where('section_active_status', 0)->limit(1)->get();
            // foreach($section_datas as $section_data){
            for ($i = 0; $i < count($section_datas); $i++) {
                $secion_id = $section_datas[$i]->section_id;
                $section_item_ids = json_decode($section_datas[$i]->section_recipies, true);
                $items = $this->get_section_products($section_item_ids);
                $section_datas[$i]->section_items = $items;
            }
            $data['section_datas'] = $section_datas;  //Section Datas
            $data['cart_data'] = $cart_data;  //Cart Datas
            return view('website.recipe')->with('data', $data);
        } else {
            return redirect()->route('404');
        }
    }


    public function website_recipe_filter(Request $request)
    {
        $search_type = $request->search_type;
        $permalink = $request->permalink;
        $price_filter = $request->price_filter;
        $veg_filter = $request->veg_filter;
        $non_veg_filter = $request->non_veg_filter;
        $recipes = $this->check_permalink($search_type, $permalink, $price_filter, $veg_filter, $non_veg_filter);
        return view('website.includes.search_items')->with('recipes', $recipes);

    }

    public function add_to_cart(Request $request)
    {
        $item_id = $request->item_id;
        $quantity = $request->quantity;
        $varient_id = $request->varient_id;
        $add_to_cart = $this->add_to_cart_trait($item_id, $quantity, $varient_id);
    }

    public function cart_basic_details()
    {

        $cart_total_price = 0;
        $customer_id = session('customer_cookie_id');
        $cart_data = Cart::session($customer_id)->getContent();
        //Get Total Price

        foreach ($cart_data as $cart) {
            $variant_array = $addon_array = array();
            $attributes = $cart['attributes'];
            if (isset($attributes['variant_array'])) {
                $variant_array = $attributes['variant_array'];
            }
            if (isset($attributes['addon_array'])) {
                $addon_array = $attributes['addon_array'];
            }
            //Variant TotalAmoiunt calculation
            if (count($variant_array) > 0) {  //Variant Product Anel
                foreach ($variant_array as $variant) {
                    $variant_quantity = $variant['variant_quantity'];
                    $variant_price = $variant['variant_price'];
                    $variant_total_price = $variant_quantity * $variant_price;
                    $cart_total_price = $cart_total_price + $variant_total_price;

                }
            } else {  //Normal Product Anel
                $cart_price = $cart['price'];
                $cart_quantity = $cart['quantity'];
                $cart_total_price = $cart_total_price + ($cart_price * $cart_quantity);
            }
            //End Of Varint Amount Calculation

            //Addon  TotalAmoiunt calculation
            foreach ($addon_array as $addon) {
                $addon_quantity = $addon['add_on_quantity'];
                $addon_price = $addon['add_on_price'];
                $addon_total_price = $addon_quantity * $addon_price;
                $cart_total_price = $cart_total_price + $addon_total_price;
            }
            //End Of addon Amount Calculation

        }
        //End of Total Price
        // dd($cart_total_price);
        $data['cart_total_price'] = $cart_total_price;
        $data['cart_count'] = $cart_data->count();
        return response()->json($data, 200);
    }

    public function change_cart_quantity(Request $request)
    {
        $item_id = $request->item_id;
        $quantity = $request->quantity;
        $page = $request->page;
        $varient_id = $request->varient_id;
        $data = $this->update_cart_quantity($item_id, $quantity, $varient_id);

        // variant Section  multiple varient indel athinte default varint cart Update cheyyuka
        if (isset($data['attributes']['variant_array'])) {

            $varient_array = $data['attributes']['variant_array'];
            foreach ($varient_array as $varient) {
                if ($varient['variant_id'] == $varient_id) {
                    $data['quantity'] = $varient['variant_quantity'];
                }
            }

        }
        //End Of Varient Section

        return response()->json($data);
    }

    public function get_section_products($section_item_ids)
    {
        $section_items = recipeModel::
        with('recipe_varient')
            // whereHas('recipe_varient', function ($query) {
            // $query->where('varient_status', 0);
            // $query->orderBy('varient_id', 'DESC');
// })
            // select('recipe_name_multi_language','recipe_description_multi_language','recipe_veg_or_non','recipe_id','recipe_permalink','recipe_image','recipe_price','recipe_offer_price','recipe_preparation_time')
            ->whereIn('recipe_id', $section_item_ids)->where('recipe_active_status', 1)->get();
        for ($i = 0; $i < count($section_items); $i++) {
            $default_varient_id = 0;   //Default Vairnt id Set To Zero
            $recipe_id = $section_items[$i]->recipe_id;
            $cart_details = $this->item_wise_detail($recipe_id);


            //Varient Section Default ID
            $varient_data = $section_items[$i]->recipe_varient;
            foreach ($varient_data as $varient) {
                $default_status = $varient['default_status'];
                if ($default_status == 1) {

                    $default_varient_id = $varient['varient_id'];
                }
            }
            $section_items[$i]->default_varient_id = $default_varient_id;
            //End Of Varient Id Default

            $section_items[$i]->cart_data = $cart_details;
            if ($cart_details) {
                $cart_attribute = $cart_details['attributes'];
                if (isset($cart_attribute['variant_array'])) {
                    $varient_array = $cart_attribute['variant_array'];
                    foreach ($varient_array as $varient) {
                        if ($varient['variant_id'] == $default_varient_id) {
                            $cart_quantity = $varient['variant_quantity'];
                            $cart_details['quantity'] = $cart_quantity;
                        }
                    }
                } else {
                    $cart_quantity = $cart_details['quantity'];
                }

            } else {
                $section_items[$i]->cart_data = "";
                $cart_quantity = 0;

            }
        }
        return $section_items;
    }

    public function not_found_404()
    {
        return view('website.404');
    }

    public function view_cart()
    {
        if (session('recent_customer_order_id')) {
            $data['edit_order_details'] = orderModel::where('order_id', session('recent_customer_order_id'))->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'order_items.recipies', 'table', 'promocode')->first();
        } else {
            $data['edit_order_details'] = array();
        }

        //fetch Available Tables
        $data['available_tables'] = tableModel::where('table_active_status', 0);
        if (session('recent_customer_order_id')) {
            $table_id = $data['edit_order_details']->order_table_id;
            $data['available_tables']->where('table_tracking_status', 'Available')
                ->orwhere('table_id', $table_id);
        } else {
            $data['available_tables']->where('table_tracking_status', 'Available');
        }
        $data['available_tables'] = $data['available_tables']->get()->toArray();


        $language_id = session('website_language');
        $customer_id = session('customer_cookie_id');
        $cartCollection = Cart::session($customer_id)->getContent();
        $cartCollection = $cartCollection->sortByDesc('id');

        foreach ($cartCollection as $key => $cart) {

            $recipe_id = $cartCollection[$key]['id'];
            $quantity = $cartCollection[$key]['quantity'];
            $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
            $cartCollection[$key]['recipe_name'] = json_decode($recipe_details['recipe_name_multi_language'], true)[$language_id];
            $cartCollection[$key]['recipe_price'] = $recipe_details['recipe_offer_price'];
            $cartCollection[$key]['recipe_image'] = $recipe_details['recipe_image'];
            $cartCollection[$key]['recipe_permalink'] = $recipe_details['recipe_permalink'];
            $cartCollection[$key]['recipe_type'] = $recipe_details['recipe_veg_or_non'];
        }
        $data['cartCollection'] = $cartCollection;
        //dd($data);
        return view('website.cart')->with('data', $data);
    }

    public function remove_from_cart(Request $request)
    {
        $item_id = $request->item_id;
        $this->remove_item($item_id);
    }

    public function get_cart_items(Request $request)
    {
        $language_id = session('website_language');
        $customer_id = session('customer_cookie_id');
        $cartCollection = Cart::session($customer_id)->getContent();
        $cartCollection = $cartCollection->sortByDesc('id');

        foreach ($cartCollection as $key => $cart) {

            $recipe_id = $cartCollection[$key]['id'];
            $quantity = $cartCollection[$key]['quantity'];
            $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
            $cartCollection[$key]['recipe_name'] = json_decode($recipe_details['recipe_name_multi_language'], true)[$language_id];
            $cartCollection[$key]['recipe_price'] = $recipe_details['recipe_offer_price'];
            $cartCollection[$key]['recipe_image'] = $recipe_details['recipe_image'];
            $cartCollection[$key]['recipe_permalink'] = $recipe_details['recipe_permalink'];
            $cartCollection[$key]['recipe_type'] = $recipe_details['recipe_veg_or_non'];
        }
        $data['cartCollection'] = $cartCollection;
        return view('website.includes.cart_item')->with('data', $data);
    }

    public function update_customize_section(Request $request)
    {
        $recipe_id = $request->recipe_id;
        $variantArray = $request->variantArray;
        $addonArray = $request->addonArray;
        return response()->json($this->update_cart_with_customization($recipe_id, $variantArray, $addonArray));
    }

    public function change_cart_addon(Request $request)
    {

        $item_id = $request->item_id;
        $quantity = $request->quantity;
        $page = $request->page;
        $addon_id = $request->addon_id;

        $this->update_add_on_data($item_id, $addon_id, $quantity);

    }

    public function check_promocode(Request $request)
    {
        $layout = session('layout_data');
        $currency = $layout['currency'];

        $promocode = $request->promocode;
        $total_amount = $request->total_amount;

        $promocode_data = $this->get_promocode_response($promocode, $total_amount);

        return response()->json($promocode_data);

    }


    public function create_order(Request $request)
    {
        $mobile_number_length = session('layout_data')['mobile_max_length'];

        $validator_array = [
            'name' => 'required',
            'mobile' => 'required|numeric|digits:' . $mobile_number_length,
            'table_id' => 'required|numeric',
        ];
        if ($request->customer_email) {
            $validator_array['customer_email'] = 'email';
        }

        $validator = Validator::make($request->all(), $validator_array);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg);
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        //Get Cart datas
        $customer_cookie_id = session('customer_cookie_id');
        $cart_data = Cart::session($customer_cookie_id)->getContent();
        $json_cart_data = json_encode($cart_data->toArray(), true);


        if (count($cart_data) == 0) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Cart Required Atleast One Product']);
        }


        try {

            // Start a database transaction
            DB::beginTransaction();
            //Form Inputs
            $name = $request->name;
            $mobile = $request->mobile;
            $table_id = $request->table_id;
            $customer_email = $request->customer_email;
            $promocode = $request->promocode;
            $ip = $request->ip();
            //End Of Form Inputs

            //Edited Order Operations
            if (session('recent_customer_order_id')) {

                $details = orderModel::where('order_id', session('recent_customer_order_id'))->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'order_items.recipies', 'table', 'promocode')->first();
                $order_items = $details['order_items'];

                foreach ($order_items as $order_item) {

                    // update stock and Stock Log
                    $recipe_id = $order_item['recipe_id'];
                    $order_item_quantity = $order_item['order_item_quantity'];
                    $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                    $recipe_name = $recipe_details->recipe_name;
                    $stock_in_or_out = 1;
                    $stock_current_qty = $recipe_details->recipe_stock;
                    $stock_changing_qty = $order_item_quantity;
                    $stock_updated_qty = $stock_current_qty + $stock_changing_qty;
                    $comment = 'Due To Order  ' . $details->order_unique_id . ' Edit  By the Customer ' . $details->order_customer_name . ' ' . $recipe_name . ' stock has been Updated ';
                    stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);
                    // End Of Update Stock And Stock Log

                }
                //End Of Order Items

                //Check Recent order table Is  New Order Table
                if ($details['order_table_id'] != $table_id) {
                    $update_order_status = tableModel::where('table_id', $details['order_table_id'])->update(['table_tracking_status' => 'Available']);

                }
                //End Of Check Recent Order Table IS New Order Table

                //Check Same Promocode Is Used Else Change The Promocode Usage Count

                if (isset($details['promocode'])) {
                    $recent_order_promocode_id = $details['promocode']['promocode_id'];
                    $recent_order_promocode = $details['promocode']['promocode_short_code'];

                    if ($recent_order_promocode != $promocode) {

                        //increment_recent_promocode value
                        $recent_order_promocode_datas = promocodeModel::select('promocode_usage_count')->where('promocode_id', $recent_order_promocode_id)->first();
                        if ($recent_order_promocode_datas) {

                            $promocode_usage_count = $recent_order_promocode_datas->promocode_usage_count;

                            $updating_count = $promocode_usage_count - 1;

                            $update_promocode_usage_count = promocodeModel::where('promocode_id', $recent_order_promocode_id)->update(['promocode_usage_count' => $updating_count]);
                            $recent_order_promocode_datas->save();

                        }


                    }
                }
                //End Of Check ame Promocode Is Used


                //Delete recent Order
                $delete_order = orderModel::where('order_id', session('recent_customer_order_id'))->update(['order_status' => 1]);
                //End Of Delete Rcent Order


            }
            //End Of Edited Order Operations


            //Check Recipe Item Stock
            foreach ($cart_data as $item) {
                $result = $this->check_item_stock($item);
                if ($result['status'] == 1) {
                    return response()->json($result);
                }

            }
            //End Of Check Recipe Item Stock


            //Check Customer Already Exist With Mobile Number
            $customer_exist = customerModel::where('customer_mob', $mobile)->first();
            if ($customer_exist) {
                $customer_id = $customer_exist->customer_id;
            } else {
                $customer = new customerModel();
                $customer->customer_ip = $request->ip();
                $customer->customer_name = $name;
                $customer->customer_mob = $mobile;
                $customer->customer_unique_id = $this->get_customer_sku();
                $customer->customer_mail_id = $customer_email;
                $customer->customer_q_id = "";
                $customer->company_name = "";
                $customer->customer_address = "";
                $customer->save();
                $customer_id = $customer->id;
            }

            // Order Table

            $order = new orderModel();
            $order->order_status = 0;
            $order->order_ip = $request->ip();
            $order->order_date = date('Y-m-d');
            $order->order_time = date('H:i');
            $order->order_unique_id = $this->order_unique_id_generator();
            $order->order_customer_id = $customer_id;
            $order->order_customer_name = $name;
            $order->order_customer_mob = $mobile;
            $order->order_customer_mail = $customer_email;
            $order->order_table_id = $table_id;
            $order->order_promocode_id = 0;
            $order->order_cost = 0;
            $order->order_net_amount = 0;
            $order->order_discount_amt = 0;
            $order->order_profit = 0;
            $order->order_grand_total = 0;
            $order->order_tracking_status = 'Placed';
            $order->order_cart_customer_id = $customer_cookie_id;
            $order->order_cart_json_array = $json_cart_data;
            if (session('recent_customer_order_id')) {//If It Is Edited Order Mark It
                $order->is_modified_order = 1;
            }
            $order->save();
            $order_id = $order->id;

            $order_total_amount = 0;
// End Of Order Table

// order_item Table
//Get Specific Cart

            $order_data = array();
            if (count($cart_data) > 0) {
                foreach ($cart_data as $item) {
                    $order_item_quantity = 0;
                    $price = 0;
                    $order_item_total_price = 0;

                    $item_id = $item['id'];
                    $item_name = $item['name'];
                    $quantity = $item['quantity'];
                    $attribute = $item['attributes'];
                    $recipe = recipeModel::where('recipe_id', $item_id)->first();
                    ######################Order Item Table Insert ########
                    $order_item = new orderitemModel();
                    $order_item->order_item_status = 0;
                    $order_item->order_item_ip = $ip;
                    $order_item->order_id = $order_id;
                    $order_item->recipe_id = $item_id;
                    $order_item->order_item_name = $item_name;
                    $order_item->order_item_price = 0;
                    $order_item->order_item_quantity = 0;
                    $order_item->order_item_cost = 0;
                    $order_item->order_item_netamount = 0;
                    $order_item->order_item_discount_amt = 0;
                    $order_item->order_item_profit = 0;
                    $order_item->order_item_grand_total = 0;
                    $order_item->save();
                    $order_item_id = $order_item->id;
                    ###########################End Of Order Item Table Insert######


                    if ($attribute) {
                        if (isset($attribute['variant_array'])) {
                            $varient_array = $attribute['variant_array'];

                            if (count($varient_array) > 0) {
                                foreach ($varient_array as $varient_data) {
                                    $variant_id = $varient_data['variant_id'];
                                    $variant_name = $varient_data['variant_name'];
                                    $variant_quantity = $varient_data['variant_quantity'];
                                    $variant_price = $varient_data['variant_price'];
                                    $varient_total_price = $variant_quantity * $variant_price;
                                    $order_item_quantity = $order_item_quantity + $variant_quantity;
                                    $order_item_total_price = $order_item_total_price + $varient_total_price;


                                    $varient = new order_item_varientModel();
                                    $varient->order_item_varient_status = 0;
                                    $varient->order_item_id = $order_item_id;
                                    $varient->varient_id = $variant_id;
                                    $varient->order_item_varient_name = $variant_name;
                                    $varient->order_item_varient_price = $variant_price;
                                    $varient->order_item_varient_quantity = $variant_quantity;
                                    $varient->order_item_varient_total_price = $varient_total_price;
                                    $varient->save();

                                }
                            } else {
                                $price = $item['price'];
                                $order_item_quantity = $order_item_quantity + $quantity;
                                $order_item_total_price = $order_item_total_price + ($quantity * $price);
                            }


                        } else {
                            $price = $item['price'];
                            $order_item_quantity = $order_item_quantity + $quantity;
                            $order_item_total_price = $order_item_total_price + ($quantity * $price);
                        }


                        //update stock and Stock Log
                        $recipe_id = $item_id;
                        $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                        $recipe_name = $recipe_details->recipe_name;
                        $stock_in_or_out = 0;
                        $stock_current_qty = $recipe_details->recipe_stock;
                        $stock_changing_qty = $order_item_quantity;
                        $stock_updated_qty = $stock_current_qty - $stock_changing_qty;
                        $comment = 'From the Order ' . $order->order_unique_id . ' ' . $recipe_name . ' stock has been reduced ';

                        stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);
                        //End Of Update Stock And Stock Log


                        $order_item_grand_total = $order_item_total_price;


                        if (isset($attribute['addon_array'])) {
                            $addon_array = $attribute['addon_array'];
                            if (count($addon_array) > 0) {
                                foreach ($addon_array as $addons) {
                                    $addon_id = $addons['id'];
                                    $addon_name = $addons['add_on_name'];
                                    $addon_quantity = $addons['add_on_quantity'];
                                    $addon_price = $addons['add_on_price'];
                                    $addon_image = $addons['add_on_image'];
                                    $addon_total_price = $addon_quantity * $addon_price;
                                    $addon_image = $addons['add_on_image'];
                                    $order_item_grand_total = $order_item_grand_total + $addon_total_price;


                                    $addon = new order_item_add_onModel();
                                    $addon->order_item_add_on_status = 0;
                                    $addon->order_item_id = $order_item_id;
                                    $addon->add_on_id = $addon_id;
                                    $addon->order_item_add_on_name = $addon_name;
                                    $addon->order_item_add_on_price = $addon_price;
                                    $addon->order_item_add_on_quantity = $addon_quantity;
                                    $addon->order_item_add_on_total_price = $addon_total_price;
                                    $addon->order_item_addon_image = $addon_image;
                                    $addon->save();
                                }
                            }

                        }


                    }

                    //update Order Item Table
                    $data = [
                        //'order_item_price' => $price,
                        'order_item_price' => $recipe->recipe_price,
                        //'order_item_quantity' => $order_item_quantity,
                        'order_item_quantity' => $quantity,
                        //'order_item_netamount' => $order_item_total_price,
                        'order_item_netamount' => $recipe->recipe_price * $quantity,
                        //'order_item_grand_total' => $order_item_grand_total
                        'order_item_grand_total' => $recipe->recipe_price * $quantity
                    ];

                    $update_order_item = orderitemModel::where('order_item_id', $order_item_id)->update($data);
                    $order_total_amount = $order_total_amount + ($recipe->recipe_price * $quantity);
                    //update Order Item Table

                }


                //  $promocode_data=$this->get_promocode_response($promocode, $order_item_grand_total);
                $promocode_data = $this->get_promocode_response($promocode, $order_total_amount);


                if (isset($promocode_data['promocode_id'])) {
                    $promocode_id = $promocode_data['promocode_id'];
                    $sub_total = $promocode_data['sub_total'];
                    $promocode_amount = $promocode_data['promocode_amount'];
                    $grand_total = $promocode_data['grand_total'];

                    $update_usage_count = promocodeModel::where('promocode_id', $promocode_id)->increment('promocode_usage_count', 1);
                    //Promocode Details
                    $promocodes = promocodeModel::where('promocode_id', $promocode_id)->first();
                    $order_data['order_promocode_id'] = $promocode_id;
                    $order_data['order_net_amount'] = $order_total_amount;
                    $order_data['order_discount_amt'] = $promocode_amount;
                    $order_data['order_grand_total'] = $order_total_amount - $promocode_amount;

                } else {
                    $order_data['order_net_amount'] = $order_total_amount;
                    $order_data['order_grand_total'] = $order_total_amount;
                }
                //Update Order Table
                $update_order_table = orderModel::where('order_id', $order_id)->update($order_data);
                //End of Order Table

                //Change resturant Table_Status
                $table_details = tableModel::where('table_id', $table_id)->first();
                //$update_resturant_table = tableModel::where('table_id', $table_id)->update(['table_tracking_status' => 'Reserved']);
                //End Of resturant Table Status

                $notification_data = [
                    'notification_type' => 1, //New Order
                    'notification_name' => "New Order Recieved",
                    'notification_desc' => "New Order " . $order->order_unique_id . ' has been recieved by the customer ' . $name . ' for the table' . $table_details->table_name,
                    'priviliage' => 1
                ];
                $this->admin_noticication($notification_data);

                session(['order_success' => true]);
                $this->cart_clear();
                Session::forget('recent_customer_order_id');  //FOrgot edited order Session
                DB::commit();
                return response()->json(['status' => 0, 'redirect_url' => route('order_success')]);
            }

        } catch (QueryException $e) {

            DB::rollBack();

        }

    }

    public function checkout()
    {

        if (session('recent_customer_order_id')) {
            $data['edit_order_details'] = orderModel::where('order_id', session('recent_customer_order_id'))->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'order_items.recipies', 'table', 'promocode')->first();
        } else {
            $data['edit_order_details'] = array();
        }


        $data['available_tables'] = tableModel::where('table_active_status', 0);
        if (session('recent_customer_order_id')) {
            $table_id = $data['edit_order_details']->order_table_id;
            $data['available_tables']->where('table_tracking_status', 'Available')
                ->orwhere('table_id', $table_id);
        } else {
            $data['available_tables']->where('table_tracking_status', 'Available');
        }

        $data['available_tables'] = $data['available_tables']->get()->toArray();


        return view('website.checkout')->with('data', $data);
    }

    public function order_success()
    {
        $customer_cookie_id = session('customer_cookie_id');
        $data['recent_orders'] = orderModel::where('order_cart_customer_id', $customer_cookie_id)->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'order_items.recipies', 'table', 'promocode')->orderBy('order_id', 'DESC')->limit(1)->get()->toarray();

        // Session::forget('order_success');


        return view('website.order-success', compact('data'));

    }

    public function modify_order(Request $request)
    {
        $order_id = $request->order_id;
        $customer_cookie_id = session('customer_cookie_id');
        $fetch_data = orderModel::where('order_id', $order_id)->first();
        $cart_json_data = json_decode($fetch_data->order_cart_json_array, true);
        // $table_id=$fetch_data->order_table_id;
        // $table_change_to_active=tableModel::where('table_id',$table_id)->update(['table_tracking_status'=>'Available']);

        foreach ($cart_json_data as $cartdata) {
            Cart::session($customer_cookie_id)->add($cartdata);  //Update To Current Cart
        }

        session(['recent_customer_order_id' => $order_id]);
        return redirect()->route('view_cart');

    }

    public function cancel_order_by_customer(Request $request)
    {
        try {

            DB::beginTransaction();


            $order_id = $request->order_id;
            $details = orderModel::with('order_items')->where('order_id', $order_id)->first();
            $table_id = $details->order_table_id;
            $update_order = orderModel::where('order_id', $order_id)->update(['order_tracking_status' => 'Cancelled']);
            $table_change_to_active = tableModel::where('table_id', $table_id)->update(['table_tracking_status' => 'Available']);

            if ($update_order) {
                //Order Items
                $order_items = $details['order_items'];
                foreach ($order_items as $order_item) {

                    // update stock and Stock Log
                    $recipe_id = $order_item['recipe_id'];
                    $order_item_quantity = $order_item['order_item_quantity'];
                    $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                    $recipe_name = $recipe_details->recipe_name;
                    $stock_in_or_out = 1;
                    $stock_current_qty = $recipe_details->recipe_stock;
                    $stock_changing_qty = $order_item_quantity;
                    $stock_updated_qty = $stock_current_qty + $stock_changing_qty;
                    $comment = 'Due To Order  ' . $details->order_unique_id . ' Cancellation By the Customer ' . $details->order_customer_name . ' ' . $recipe_name . ' stock has been Updated ';
                    stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);
                    // End Of Update Stock And Stock Log

                }
                //End Of Order Items

                $notification_data = [
                    'notification_type' => 1, //New Order
                    'notification_name' => "Order Cancelled",
                    'notification_desc' => "Order " . $details->order_unique_id . ' has been Cancelled by the customer ' . $details->order_customer_name,
                    'priviliage' => 1
                ];
                $this->admin_noticication($notification_data);

            }

            DB::commit();

            return redirect()->route('order_success');

        } catch (QueryException $e) {

            DB::rollBack();

        }

    }

    public function proceed_to_ckeckout(Request $request)
    {

        //Get Cart datas
        $customer_cookie_id = session('customer_cookie_id');
        $cart_data = Cart::session($customer_cookie_id)->getContent();
        $json_cart_data = json_encode($cart_data->toArray(), true);


        if (count($cart_data) == 0) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Cart Required Atleast One Product']);
        }

        //Check Recipe Item Stock
        $stock_exist = true;
        foreach ($cart_data as $item) {
            $result = $this->check_item_stock($item);

            if ($result['status'] == 1) {
                $stock_exist = false;
                return response()->json($result);
            }

        }
        if ($stock_exist == true) {
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Success', 'redirect_url' => route('checkout')]);
        }

        //End Of Check Recipe Item Stock

    }

    public function payment(Request $request){
        //use  base64_encode() and base64_decode()
        $orderId = request()->segment(2);
        $amount = request()->segment(3);

        $order = orderModel::where('order_unique_id', $orderId)->first();
        $name = $order->order_customer_name;
        $phone = $order->order_customer_mob;


        return view('website.payment',compact('orderId','amount', 'name', 'phone'));
    }

    public function tesspayment(Request $request){

        $orderId = request()->segment(2);
        $amount = request()->segment(3);

        $order = orderModel::where('order_unique_id', $orderId)->first();
        $cart = ApiCartModel::where('id', $order->order_cart_customer_id)->first();

        $curl = curl_init();

//        $hashString = 'daf3c6b6-78e9-11f0-8393-0242ac16000e' . $orderId . number_format($amount, 2, '.', '') . 'QAR' . 'b2d6fc14cebde7c7aa436d8459bd61d4';
//
//// Generate hash
//        $hash = hash('sha256', $hashString);

        $to_md5 = $orderId . number_format($amount, 2, '.', '') . 'QAR' . 'Test Payment' . 'b2d6fc14cebde7c7aa436d8459bd61d4';


        $md5_hash = md5(strtoupper($to_md5));

        $hash = sha1($md5_hash);

        $data = [
            "merchant_key" => "daf3c6b6-78e9-11f0-8393-0242ac16000e",
            "operation"    => "purchase",
            "methods"      => ["card"],
            "order" => [
                "number"      => $orderId, // dynamic order number
                "amount"      => number_format($amount, 2, '.', ''),  // you can replace with variable
                "currency"    => "QAR",
                "description" => "Test Payment"
            ],
            "billing_address" => [
//                "country" => "QA",
//                "state"   => "QA",
//                "city"    => "Doha",
                "address" => $cart->address,
                //"zip"     => "123456",
                "phone"   => $cart->phone_number
            ],
            "cancel_url" => "https://albaitalkuwaiti.dmenus.com/api/payment_failed",
            "success_url"=> "https://albaitalkuwaiti.dmenus.com/api/payment_success",
            "customer" => [
                "name"  => $order->order_customer_name .' '. $order->order_customer_mob,
                "email" => "jithoshjithosh@gmail.com",
            ],
            "hash" => $hash
        ];

// Convert to JSON
        $jsonData = json_encode($data);

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://checkout.tesspayments.com/api/v1/session',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Cookie: PHPSESSID=k08i1chukgkoijturll05l28kj'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
// return $response;
        $decodedResponse = json_decode($response);
        //dd($response, $decodedResponse);
        return redirect($decodedResponse->redirect_url);
    }


}
