<?php

namespace App\Http\Controllers;

use App\Models\branchModel;
use app\Models\User;
use App\Models\sellerModel;
use Illuminate\Http\Request;
use Auth;
use Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Arr;
use DB;
use Session;


class userController extends Controller
{
    public function index()
    {
        $data['users'] = User::where('id', Auth::user()->id)->first();
        return view('admin.users.add_user')->with(['data' => $data]);
    }
    public function update_user_details(Request $request)
    {
        $user_id = Auth::user()->id;

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'username' => 'required',
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        $email = $request->email;
        $username = $request->username;
        $check_user_name_or_email_exist = User::where('u_status', 0)
            ->where('id', '!=', Auth::user()->id)
            ->Where(function ($query) use ($email, $username) {
                $query->where('email', $email);
                $query->orwhere('username', $username);
            })
            ->get();
        if (count($check_user_name_or_email_exist) > 0) {
            $error = "Username or Email Id Already Exist";
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);

        }

        $data = [
            'name' => $request->name,
            'email' => $request->email,
            'username' => $request->username,
        ];

        if ($image = $request->file('image')) {
            $imageDestinationPath = 'uploads/user_image';
            $postImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($imageDestinationPath, $postImage);
            $data['user_image'] = $postImage;
        }

        $user_update = User::where('id', Auth::user()->id)->update($data);
        if ($user_update == 1) {
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Admin updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function update_password(Request $request)
    {
        $user_id = Auth::user()->id;
        $validator = Validator::make($request->all(), [
            'current_password' => 'required',
            'new_password' => 'required',
            'confirm_password' => 'required',
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        if (Hash::check($request->current_password, Auth::user()->password) == false) { //Old Password Is Incrrect
            $error = "Old Password Is Incorrect";
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }


        if ($request->new_password != $request->confirm_password) {
            $error = "password and confirm password Not Matching";
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        if (strlen($request->new_password) < 8) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'password Contains atleast 8 charactes']);
        } else {
            $update_password = User::where('id', Auth::user()->id)->update(['password' => Hash::make($request->new_password)]);
            if ($update_password == 1) {
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Password updated successfully']);

            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }
        }


    }
    public function manage_user()
    {

        $roles = Role::where('status', 0)->pluck('name')->all();
        $branches = branchModel::all();
        return view('admin.master_settings.add_user')->with(['roles' => $roles, 'branches' => $branches]);
    }
    public function add_user(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'regex:/^[a-zA-Z\s]+$/'],
            'email' => 'required|unique:users|email',
            'mobile' => 'required|digits:8',
            'roles' => 'required',
            'username' => 'required',
            'password' => "required",
            'confirm_password' => "required",
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        if ($request->password != $request->confirm_password) {
            $error = "password and confirm password Not Matching";
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        if (strlen($request->password) < 8) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'password Contains atleast 8 charactes']);
        }
        $new_user = new User();
        $new_user->branch_id = $request->branch ?: 0;
        $new_user->name = $request->name;
        $new_user->mobile = $request->mobile;
        $new_user->email = $request->email;
        $new_user->username = $request->username;
        $new_user->password = Hash::make($request->password);

        if ($image = $request->file('image')) {
            $imageDestinationPath = 'uploads/user_image';
            $postImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($imageDestinationPath, $postImage);
            $new_user->user_image = $postImage;
        }
        $new_user->user_unique_id = $this->user_unique_idunique_id_generator();
        $new_user->seller_id = $request->seller ?: 0;
        $new_user->save();
        $new_user->assignRole($request->roles);
        ############################User Activity log#########################
        $user_activity_log['activity_ip'] = $request->ip();
        $user_activity_log['activity_user_name'] = Auth::user()->name;
        $user_activity_log['activity_user_id'] = Auth::user()->id;
        $user_activity_log['activity_action'] = "Added";
        $user_activity_log['activity_desc'] = 'New User ' . $new_user->name . ' Has Been Added By ' . Auth::user()->name;
        user_activity_log($user_activity_log);
        ###########################End Of USer Activity Log###################
        return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'User Added Successfully']);
    }
    public function user_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'user.id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $role_data = $roles = User::where('u_status', 0)
            ->select('*')
            ->Where(function ($query) use ($search) {
                $query->where('name', 'like', $search . '%');
                $query->Orwhere('mobile', 'like', $search . '%');
                $query->Orwhere('email', 'like', $search . '%');
                $query->Orwhere('username', 'like', $search . '%');
                $query->Orwhere('user_unique_id', 'like', $search . '%');
            });
        if ($colName != '' && $sort != '') {
            $role_data->orderBy($colName, $sort);
        } else {
            $role_data->orderBy('id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $role_data->count(), 'iTotalRecords' => $role_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $role_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }
    public function user_unique_idunique_id_generator()
    {
        $lastUser = User::orderby('id', 'DESC')->first();
        if ($lastUser) {
            $lastUserId = $lastUser->user_unique_id;
            $newdata = substr($lastUserId, -3);
            $newUniq = 'USR' . sprintf('%03d', ($newdata + 1));
        } else {
            $newUniq = 'USR' . sprintf('%03d', 1);
        }
        return $newUniq;
    }
    public function delete_user(Request $request)
    {
        $id = $request->id;
        $user_details = User::find($id);
        $update = User::where('id', $id)->update(['u_status' => 1]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Deleted";
            $user_activity_log['activity_desc'] = 'User ' . $user_details->name . ' Has Been Deleted By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'User removed successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }
    public function edit_user(Request $request)
    {
        $id = $request->id;
        $data['user'] = User::find($id);
        $data['roles'] = Role::pluck('name', 'name')->all();
        $data['branches'] = $data['user']->branch_id;
        $data['userRole'] = $data['user']->roles->pluck('name', 'name')->all();
        // dd($data['user']);
        return $data;
    }
    public function update_user(Request $request)
    {
        $id = $request->user_id;
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'regex:/^[a-zA-Z\s]+$/'],
            'email' => 'required|email',
            'roles' => 'required',
            'username' => 'required|min:8|max:30',
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        if ($request->password != $request->confirm_password) {
            $error = "password and confirm password Not Matching";
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        $data = [
            'branch_id' => $request->branch ?: 0,
            'name' => $request->name,
            'mobile' => $request->mobile,
            'email' => $request->email,
            'username' => $request->username,
            'seller_id' => $request->seller ?: 0,
        ];
        if ($request->password) {
            $data['password'] = Hash::make($request->password);
        }
        if ($image = $request->file('image')) {
            $imageDestinationPath = 'uploads/user_image';
            $postImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($imageDestinationPath, $postImage);
            $data['user_image'] = $postImage;
        }
        $user = User::find($id);
        DB::table('model_has_roles')->where('model_id', $id)->delete();
        $user->assignRole($request->input('roles'));
        $update = User::where('id', $id)->update($data);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'User ' . $request->name . ' Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'User Updated Successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }
    public function user_view(Request $request)
    {
        $id = $request->id;
        $data['user'] = User::find($id);
        $data['roles'] = Role::pluck('name', 'name')->all();
        $data['userRole'] = $data['user']->roles->pluck('name')->all();
        // dd($data['user']);
        return view('admin.master_settings.user-modal')->with('data', $data);
    }

    public function user_activity(Request $request)
    {
        $data['fetch_user'] = User::select('id', 'name')->where('u_status', 0)->get();
        return view('admin.users.user_activity_log')->with('data', $data);
    }
    public function user_activity_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'user_activity_logs.activity_id';
        $sort = 'DESC';

        //Checking Role
        $roles_array = Auth::user()->getRoleNames()->toArray();
        $where_condition = 1;
        if (in_array("Super Admin", $roles_array) || in_array("Admin", $roles_array)) {
            $where_condition = 0;
        }
        //End Of CHeching



        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $datas = Db::table('user_activity_logs')->where('activity_status', 0)
            ->select('user_activity_logs.*', 'users.name')
            ->leftjoin('users', 'users.id', 'user_activity_logs.activity_user_id');
        if (session('user_filter')) {
            $datas = $datas->where('activity_user_id', session('user_filter'));
        }
        $datas = $datas->Where(function ($query) use ($search) {
            $query->where('activity_desc', 'like', '%' . $search . '%');
            $query->Orwhere('name', 'like', $search . '%');
        });
        if ($where_condition == 1) {
            $datas->where('activity_user_id', Auth::user()->id);
        }
        if ($colName != '' && $sort != '') {
            $datas->orderBy($colName, $sort);
        } else {
            $datas->orderBy('activity_id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $datas->count(), 'iTotalRecords' => $datas->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $datas->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }
    public function filter_user(Request $request)
    {
        $user_id = $request->user_id;
        Session::put('user_filter', $user_id);
        return "success";
    }
    public function reset_session()
    {
        $reset_array = array('user_filter','order_status', 'order_from_date_filter','order_to_date_filter','from_date','to_date','invoice_from_date_filter','invoice_to_date_filter');
        foreach ($reset_array as $reset_key) {
            session()->forget($reset_key);
        }
        return "success";

    }

    public function change_user_active_status(Request $request)
    {
        $id = $request->id;
        $attempt_count = $request->attempt_count;
        $details = User::where('id', $id)->first();
        $update = User::where('id', $id)->update(['user_attempt' => $attempt_count]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            if ($attempt_count == 5) {
                $user_activity_log['activity_action'] = "Blocked";
                $user_activity_log['activity_desc'] = 'User ' . $details->name . ' Has Been Blocked By ' . Auth::user()->name;
                $response_messages = "User Blocked Successfully";
            } else {
                $user_activity_log['activity_action'] = "Activated";
                $user_activity_log['activity_desc'] = 'User ' . $details->name . ' Has Been Activated By ' . Auth::user()->name;
                $response_messages = "User Activated Successfully";
            }

            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => $response_messages]);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }
}
