<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\tableModel;
use Auth;
class tableController extends Controller
{
  public function index(){
     return view('admin.resturant_table.index');
  }
  public function add_table(Request $request){
       $validator = Validator::make($request->all(), [
            'res_table_name'=>'required',
            'seating_count'=>'required|numeric',
            'table_format'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        } 
        if($request->table_format==""){$request->table_format=0;}
        $insert_table=new tableModel();
        $insert_table->table_status=0;
        $insert_table->table_name=$request->res_table_name;
        $insert_table->table_seating_count=$request->seating_count;
        $insert_table->table_format=$request->table_format;
        $insert_table->table_active_status=0;
        $insert_table->table_tracking_status="Available";
        $insert_table->created_by=Auth::user()->id;
        $insert_table->updated_by=Auth::user()->id;
        $insert_table->save();
         ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Resturant Table  '.$request->res_table_name.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Table Added Successfully']);
  }
  public function table_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 5;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $table_data=tableModel::where('table_status',0)
        ->Where(function($query) use ($search) {
            $query->where('table_name', 'like', $search . '%');
        });
        $table_data->orderby('table_id','DESC');
        $data = ["iTotalDisplayRecords" => $table_data->count(), "iTotalRecords" => $table_data->count(), "TotalDisplayRecords" => $limit];
        $data['data'] = $table_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
  }
  public function change_table_status(Request $request){
        $table_id=$request->id;
        $status=$request->status;
        $data=['table_active_status'=>$status];
        $update_status=tableModel::where('table_id',$table_id)->update($data);
        $details=tableModel::where('table_id',$table_id)->first();
        if($update_status==1){
              ############################User Activity log#########################
                $user_activity_log['activity_ip']=$request->ip(); 
                $user_activity_log['activity_user_name']=Auth::user()->name;
                $user_activity_log['activity_user_id']=Auth::user()->id; 
                $user_activity_log['activity_action']="Updated";
                $active_status="Activate";
                if($status==1){$active_status="Inactivate";}
                $user_activity_log['activity_desc']='Resturant Table  '.$details->table_name.' Has Been '.$active_status.' By '.Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Status changed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
  }
  public function edit_table(Request $request){
      $table_id=$request->id;
      $table_data=tableModel::select('*')->where('table_id',$table_id)->first();
      return response()->json(['status' => '0', 'msg' => 'succes','data'=>$table_data]);
  }
  public function update_table(Request $request){
        $validator = Validator::make($request->all(), [
            'res_table_id'=>'required',
            'res_table_name'=>'required',
            'seating_count'=>'required|numeric',
             'table_format'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        $data=[
            'table_name'=>$request->res_table_name,
            'table_seating_count'=>$request->seating_count,
            'table_format'=>$request->table_format,
            'updated_by'=>Auth::user()->id,
        ];
        $update=tableModel::where('table_id',$request->res_table_id)->update($data); 
        if($update==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Resturant Table '.$request->res_table_name.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Restaurant Table updated successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
  }
  public function delete_res_table(Request $request){
        $id=$request->id;
        $update=tableModel::where('table_id',$id)->update(['table_status'=>1]);
        $details=tableModel::where('table_id',$id)->first();
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Resturant Table '.$details->table_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Restaurant Table  removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
  }
}