<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\subscriptionModel;
use App\Models\subscriptionhistoryModel;
use Illuminate\Support\Facades\Redirect;

use Auth;
class subscriptionController extends Controller
{
    public function index(){
      return view('admin.subscription.index');
    }

    public function add_subscription(Request $request){

        $validator = Validator::make($request->all(), [
            'subscription_name'=>'required',
            'subscription_desc'=>'required',
            'subscription_days'=>'required',
            'subscription_price'=>'required',
        ]);
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        
        try{
            
            $subscription=new subscriptionModel();
            $subscription->subscription_type_status=0;
            $subscription->subscription_type_ip=$request->ip();
            $subscription->subscription_type_name=$request->subscription_name;
            $subscription->subscription_type_description=$request->subscription_desc;
            $subscription->subscription_type_days=$request->subscription_days;
            $subscription->subscription_type_price=$request->subscription_price;
            $subscription->created_by=Auth::user()->id;
            $subscription->updated_by=Auth::user()->id;
            $subscription->save();
            
                    if( $subscription){
                        ###############User Activity log#########################
                        $user_activity_log['activity_ip']=$request->ip(); 
                        $user_activity_log['activity_user_name']=Auth::user()->name;
                        $user_activity_log['activity_user_id']=Auth::user()->id; 
                        $user_activity_log['activity_action']="Added";
                        $user_activity_log['activity_desc']='New Subscription Type  '.$request->subscription_type_name.' Has Been Added By '.Auth::user()->name;
                        user_activity_log($user_activity_log);
                        ###########################End Of USer Activity Log###################
                        return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subscription Type  added successfully ']);
                    }
                    else{
                        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);  
                    }
       

        }
        catch(\Exception $e){

             return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $e->getMessage()]);  
        }

    }

    public function subscription_datatable(Request $request){


        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_subscription_type.subscription_type_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }
        $coupon_data =subscriptionModel::where('subscription_type_status',0)
        ->leftjoin('users','tbl_subscription_type.created_by','users.id')
        
        ->select('tbl_subscription_type.*','users.name')
        ->Where(function($query) use ($search) {
            $query->where('subscription_type_name', 'like','%'. $search . '%');
            $query->orwhere('subscription_type_description', 'like', $search . '%');

        });
       if ($colName != '' && $sort != '') {
           $coupon_data->orderBy($colName, $sort);
       }
       else{
         $coupon_data->orderBy('subscription_type_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $coupon_data->count(), 'iTotalRecords' => $coupon_data->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $coupon_data->skip($offset)->take($limit)->get()->toArray();
       return response()->json($data);  dd($data);
    }

    public function edit_subscription(Request $request){
        $id=$request->id;
        $subscription=subscriptionModel::select('*')
        ->where('subscription_type_id',$id)
        ->first(); 
        return $subscription;
    }

    public function update_subscription(Request $request){

            $validator = Validator::make($request->all(), [
            'subscription_name'=>'required',
            'subscription_desc'=>'required',
            'subscription_days'=>'required',
            'subscription_price'=>'required',
        ]);
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        
        try{

            $id=$request->subscription_id;

            $data=[
                'subscription_type_name'=>$request->subscription_name,
                'subscription_type_description'=>$request->subscription_desc,
                'subscription_type_days'=>$request->subscription_days,
                'subscription_type_price'=>$request->subscription_price,
                'updated_by'=>Auth::user()->id
            ];


         $update=subscriptionModel::where('subscription_type_id',$id)->update($data);
        $details=subscriptionModel::where('subscription_type_id',$id)->first();
        $subscription_name=$details->subscription_type_name;

     if( $update){
        ###############User Activity log#########################
        $user_activity_log['activity_ip']=$request->ip(); 
        $user_activity_log['activity_user_name']=Auth::user()->name;
        $user_activity_log['activity_user_id']=Auth::user()->id; 
        $user_activity_log['activity_action']="Updated";
        $user_activity_log['activity_desc']='Subscription  '.$subscription_name.' Has Been Updated By '.Auth::user()->name;
        user_activity_log($user_activity_log);
        ###########################End Of USer Activity Log###################
        return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subscription Updated successfully ']);
       }
       else{
        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);  
       }


              }
        catch(\Exception $e){

             return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $e->getMessage()]);  
        }

    }

    public function delete_subscription(Request $request){

        $id=$request->id;
        $details=subscriptionModel::where('subscription_type_id',$id)->first();
        $update=subscriptionModel::where('subscription_type_id',$id)->update(['subscription_type_status'=>1]);
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Subscription   '.$details->subscription_type_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subscription removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function view_subscritpion(Request $request){
        
        $id=$request->id;
        $details=subscriptionModel::where('subscription_type_id',$id)->first();
        return view('admin.subscription.modal')->with('data',$details);
    }


    public function subscription_packages(Request $request){

    $data['packages']=subscriptionModel::where('subscription_type_status',0)->orderBy('subscription_type_id','Desc')->get()->toArray();
    return view('admin.subscription.subscription_packages')->with('data',$data);
    }

    public function subscribe(Request $request){

        try{
        $subscription_id=$request->subscription_id;
        //Get Subscription Details
        $details=subscriptionModel::where('subscription_type_id',$subscription_id)->first();
        $subscription_id=$details->subscription_type_id;
        $subscription_name=$details->subscription_type_name;
        $subscription_price=$details->subscription_type_price;
        $subscription_days=$details->subscription_type_days;

        //get Last Subscriptio History
        $get_last_subscription_history=subscriptionhistoryModel::where('subscription_history_status',0)->orderby('subscription_history_id','DESC')->limit(1)->get()->toArray();
        if(empty($get_last_subscription_history)){
            
          $subscription_from_date=date('Y-m-d');  
          $subscription_to_date=date('Y-m-d', strtotime("+$subscription_days days", strtotime($subscription_from_date)));  
          $subscription_current_status="Actived";
        }
        else{
            if(count($get_last_subscription_history)>0){

                $get_last_subscription_to_date=$get_last_subscription_history[0]['subscription_to_date'];
                
                if($get_last_subscription_to_date>date('Y-m-d')){   //Expire Date Greter Than Current Date
                $subscription_from_date=date('Y-m-d', strtotime("+1 days", strtotime($get_last_subscription_to_date))); 
                $subscription_to_date=date('Y-m-d', strtotime("+$subscription_days days", strtotime($subscription_from_date))); 
                $subscription_current_status="Hold";
                }
                else{
                $subscription_from_date=date('Y-m-d');  
                $subscription_to_date=date('Y-m-d', strtotime("+$subscription_days days", strtotime($subscription_from_date)));  
                $subscription_current_status="Actived";
                } 

            }
        }

        $subscription_history=new subscriptionhistoryModel();
        $subscription_history->subscription_history_status=0;
        $subscription_history->subscription_id=$subscription_id;
        $subscription_history->subscription_price=$subscription_price;
        $subscription_history->subscription_days=$subscription_days;
        $subscription_history->subscription_from_date=$subscription_from_date;
        $subscription_history->subscription_to_date=$subscription_to_date;
        $subscription_history->subscription_current_status=$subscription_current_status;
        $subscription_history->created_by=Auth::user()->id;
        $subscription_history->updated_by=Auth::user()->id;
        $subscription_history->save();
        
              if( $subscription_history){
                        ###############User Activity log#########################
                        $user_activity_log['activity_ip']=$request->ip(); 
                        $user_activity_log['activity_user_name']=Auth::user()->name;
                        $user_activity_log['activity_user_id']=Auth::user()->id; 
                        $user_activity_log['activity_action']="Added";
                        $user_activity_log['activity_desc']=$subscription_name.' Package Subscribed By '.Auth::user()->name;
                        user_activity_log($user_activity_log);
                        ###########################End Of USer Activity Log###################
                         return redirect()->back()->with('success', 'Subscribed Succesfully !!!');   

                    }
                    else{
                      return Redirect::back()->withErrors(['msg' => 'Something Wrong']);

                    }
                    

            }
            catch(\Exception $e){
                 return Redirect::back()->withErrors(['msg' => 'Something Wrong']);
            }   
        
        
        


    }

    
    public function subscription_history_datatable(Request $request){


        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_subscription_history.subscription_history_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }
        $coupon_data =subscriptionhistoryModel::where('subscription_history_status',0)
        ->leftjoin('users','tbl_subscription_history.created_by','users.id')
        ->leftjoin('tbl_subscription_type','tbl_subscription_type.subscription_type_id','tbl_subscription_history.subscription_id')
        ->select('tbl_subscription_history.*','tbl_subscription_type.*','users.name')
        ->Where(function($query) use ($search) {
            $query->where('subscription_type_name', 'like','%'. $search . '%');

        });
       if ($colName != '' && $sort != '') {
           $coupon_data->orderBy($colName, $sort);
       }
       else{
         $coupon_data->orderBy('subscription_history_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $coupon_data->count(), 'iTotalRecords' => $coupon_data->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $coupon_data->skip($offset)->take($limit)->get()->toArray();
       return response()->json($data); 

       
    }

    public function custom_subscription(){
      return view('admin.subscription.custom_subscription');  
    }
    
    public function add_custom_subscription(Request $request){
           $validator = Validator::make($request->all(), [
            'subscription_name'=>'required',
            'subscription_days'=>'required',
            'subscription_price'=>'required',
        ]);
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        try{

        $subscription_id=1;
        $subscription_name=$request->subscription_name;
        $subscription_price=$request->subscription_price;
        $subscription_days=$request->subscription_days;

            
                //get Last Subscriptio History
                 $get_last_subscription_history=subscriptionhistoryModel::where('subscription_history_status',0)->orderby('subscription_history_id','DESC')->limit(1)->get()->toArray();
               
                 if(empty($get_last_subscription_history)){
                    $subscription_from_date=date('Y-m-d');  
                    $subscription_to_date=date('Y-m-d', strtotime("+$subscription_days days", strtotime($subscription_from_date)));  
                    $subscription_current_status="Actived";
                    
                    }
                else{ 
                if(count($get_last_subscription_history)>0){

                $get_last_subscription_to_date=$get_last_subscription_history[0]['subscription_to_date'];
                
                if($get_last_subscription_to_date>date('Y-m-d')){   //Expire Date Greter Than Current Date
                $subscription_from_date=date('Y-m-d', strtotime("+1 days", strtotime($get_last_subscription_to_date))); 
                $subscription_to_date=date('Y-m-d', strtotime("+$subscription_days days", strtotime($subscription_from_date))); 
                $subscription_current_status="Hold";
                }
                else{
                $subscription_from_date=date('Y-m-d');  
                $subscription_to_date=date('Y-m-d', strtotime("+$subscription_days days", strtotime($subscription_from_date)));  
                $subscription_current_status="Actived";
                } 

            }
        }


        $subscription_history=new subscriptionhistoryModel();
        $subscription_history->subscription_history_status=0;
        $subscription_history->subscription_id=1;
        $subscription_history->subscription_name=$subscription_name;
        $subscription_history->subscription_price=$subscription_price;
        $subscription_history->subscription_days=$subscription_days;
        $subscription_history->subscription_from_date=$subscription_from_date;
        $subscription_history->subscription_to_date=$subscription_to_date;
        $subscription_history->subscription_current_status=$subscription_current_status;
        $subscription_history->created_by=Auth::user()->id;
        $subscription_history->updated_by=Auth::user()->id;
        $subscription_history->save();
            
            if( $subscription_history){
                        ###############User Activity log#########################
                        $user_activity_log['activity_ip']=$request->ip(); 
                        $user_activity_log['activity_user_name']=Auth::user()->name;
                        $user_activity_log['activity_user_id']=Auth::user()->id; 
                        $user_activity_log['activity_action']="Added";
                        $user_activity_log['activity_desc']=$subscription_name.' Package Subscribed By '.Auth::user()->name;
                        user_activity_log($user_activity_log);
                        ###########################End Of USer Activity Log###################
                        return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subscribed']);
                    }
                    else{
                        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Wrong']);

                    }
                    

            }
            catch(\Exception $e){
                 return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
            }  
    }

}
