<?php

namespace App\Http\Controllers;
use App\Models\categoryModel;
use App\Models\subcategoryModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Image;
use Auth;
class subcategoryController extends Controller
{
     public function __construct(){
        ini_set('memory_limit', '44M');
    }
    
  public function index(){ 
      $data["category_data"] = categoryModel::where('category_status',0)->orderBy('category_name','ASC')->get();
      $data["subcategory_data"] = subcategoryModel::where('subcategory_status',0)->orderBy('priority','ASC')->get();
      $data['available_languages']=get_available_language();
   return view('admin.subcategory.index')->with($data);
  }

  public function subcategory_datatable(Request $request){
           $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_subcategory.subcategory_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }

        $role_data=$roles = subcategoryModel::where('subcategory_status',0)
        ->leftjoin('tbl_category','tbl_subcategory.subcategory_cid','tbl_category.category_id')
        ->leftjoin('users','tbl_subcategory.created_by','users.id','tbl_category.category_name')
        ->select('tbl_subcategory.*','users.name','tbl_category.category_name')
        ->Where(function($query) use ($search) {
            $query->where('subcategory_name', 'like', $search . '%');
            // $query->where('tbl_category.category_name', 'like', $search . '%');
        });
       if ($colName != '' && $sort != '') {
           $role_data->orderBy($colName, $sort);
       }
       else{
         $role_data->orderBy('subcategory_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $role_data->count(), 'iTotalRecords' => $role_data->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $role_data->skip($offset)->take($limit)->get()->toArray();  
    return response()->json($data);
  }
  public function add_subcategory(Request $request){    
    
    
        ##########################validation Section ###############################
        $dynamic_input_required=['subcategory_name'];
        $dynamic_validation_array=validation_array('subcategory',$dynamic_input_required);  //Page,Required Fields
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['image']=image_validation_rule('subcategory',env('SUBCATEGORYIMAGESIZE'),true,env('SUBCATEGORYIMAGEFILESIZE'));  //image Validation (page,imagesize,requiredstatus)
        $validation_array['subcategory_banner']=image_validation_rule('subcategory',env('SUBCATEGORYBANNERSIZE'),false,env('SUBCATEGORYBANNERFILESIZE'));  
        $validation_array['category']='required';
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################
        $check_exist=subcategoryModel::where('subcategory_status',0)->where('subcategory_name',$request->subcategory_name_1)->first();
        if($check_exist){

            return response()->json(['status' => 1,'heading'=>'Error', 'msg' =>$request->subcategory_name_1.' already Exist']);
        }
        $subcategory=new subcategoryModel();
        $subcategory->subcategory_image='';   

           //Image Uploading Section
            if ($image = $request->file('image'))
             {  
            $original_file_destination='uploads/subcategory_org_images/';
            $desination_path='uploads/subcategory_images/';
            $image_resolution=env('SUBCATEGORYIMAGESIZE');
            $image=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $subcategory->subcategory_image =$image;
            }
         //End Of Image Uploading Section

         //Subcategory Banner Uploading Section
            if ($image = $request->file('subcategory_banner'))
             {  
            $original_file_destination='uploads/subcategory_org_images/';
            $desination_path='uploads/subcategory_images/';
            $image_resolution=env('SUBCATEGORYBANNERSIZE');
            $image=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $subcategory->subcategory_banner =$image;
            }
         //End Of Image Uploading Section

    
        $subcategory->subcategory_ip=$request->ip();
        $subcategory->subcategory_cid=$request->category;
        $subcategory->subcategory_name=$request->subcategory_name_1;
        $subcategory->subcategory_banner_heading=$request->subcategory_banner_name_1;
        $subcategory->subcategory_banner_description=$request->subcategory_banner_description_1;
        //Mutlilanguage section
           $request_para="subcategory_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $subcategory->subcategory_name_multi_language=$multi_language_names;
        //End Of Multilanguage Section

        //Mutlilanguage banner name  section
           $request_para="subcategory_banner_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $subcategory->subcategory_multi_banner_heading=$multi_language_names;
        //End Of Multilanguage Section

        //Mutlilanguage banner Descripion  section
           $request_para="subcategory_banner_description_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $subcategory->subcategory_multi_banner_description=$multi_language_names;

        //End Of Multilanguage Section

       
        $subcategory->priority=0;
        $subcategory->created_by=Auth::user()->id;
        $subcategory->updated_by=Auth::user()->id;
        $subcategory->subcategory_permalink=permalink_generator($request->subcategory_name_1);
        $subcategory->save();
        if($subcategory){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Subcategory '.$request->subcategory_name_1.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subcategory added successfully ']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
  }



    public function subcategory_view(Request $request){
       $id=$request->id;
       $data['subcategories']=subcategoryModel::where('subcategory_id',$id)
        ->leftjoin('tbl_category','tbl_subcategory.subcategory_cid','tbl_category.category_id')
       ->first();
       $subcategory_name_multi_language=json_decode($data['subcategories']->subcategory_name_multi_language,true);
       $subcategory_banner_name_multi_language=json_decode($data['subcategories']->subcategory_multi_banner_heading,true);
       $subcategory_banner_description_multi_language=json_decode($data['subcategories']->subcategory_multi_banner_description,true);
       $available_languages=get_available_language();
    #########################Sub Multi Subcategory Name #################
       $multi_subcategory_name_array=array();
       foreach($subcategory_name_multi_language as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
               
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => 'Subcategory Name '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_subcategory_name_array,$languag_data);
                $data['multi_subcategory_name_array']=$multi_subcategory_name_array;
            }
            }

       }
       #########################End Of Sub Multi Subcategory Name #################
         #########################Sub  Category Banner Name #################
       $multi_subcategory_banner_name_array=array();
       foreach($subcategory_banner_name_multi_language as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
               
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => 'Subcategory Banner Name '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_subcategory_banner_name_array,$languag_data);
                $data['multi_subcategory_banner_name_array']=$multi_subcategory_banner_name_array;
            }
            }

       }

       #########################End Of Sub  Category  Banner Name #################

         #########################Sub  Category Banner Description #################
       $multi_subcategory_banner_description_array=array();
       foreach($subcategory_banner_description_multi_language as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
               
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => 'Subcategory Banner Description '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_subcategory_banner_description_array,$languag_data);
                $data['multi_subcategory_banner_description_array']=$multi_subcategory_banner_description_array;
            }
            }

       }

       #########################End Of Sub  Category  Banner Description #################
        return view('admin.subcategory.modal',compact('data'));
        
    }




      public function edit_subcategory(Request $request){    
      $id=$request->id;
      $data=subcategoryModel::select('*')->where('subcategory_id',$id)->first();
      return response()->json($data);
    }

       public function update_subcategory(Request $request){
        $id=$request->subcategory_id;
         ##########################validation Section ###############################
        $dynamic_input_required=['subcategory_name'];
        $dynamic_validation_array=validation_array('category',$dynamic_input_required);  //Page,Required Fields
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['image']=image_validation_rule('subcategory',env('SUBCATEGORYIMAGESIZE'),false,env('SUBCATEGORYIMAGEFILESIZE'));
        $validation_array['subcategory_banner']=image_validation_rule('subcategory',env('SUBCATEGORYBANNERSIZE'),false,env('SUBCATEGORYBANNERFILESIZE'));  
        $validation_array['category']='required';
        $validation_array['subcategory_id']='required|numeric';
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################
        $check_exist=subcategoryModel::where('subcategory_status',0)->where('subcategory_id','!=',$id)->where('subcategory_name',$request->subcategory_name_1)->first();
        if($check_exist){
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' =>$request->subcategory_name_1.' already Exist']);
        }
        

        //Mutlilanguage section
           $request_para="subcategory_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
        //End Of Multilanguage Section
        //Mutlilanguage banner name  section
           $request_para="subcategory_banner_name_";
           $multi_banner_heading=get_mutli_language_json_input($request->all(),$request_para);
        //End Of Multilanguage Section
        //Mutlilanguage banner Descripion  section
           $request_para="subcategory_banner_description_";
           $multi_banner_description=get_mutli_language_json_input($request->all(),$request_para);
        //End Of Multilanguage Section


    $data=[
        'subcategory_ip'=>$request->ip(),
        'subcategory_cid'=>$request->category,
        'subcategory_name'=>$request->subcategory_name_1,
        'subcategory_name_multi_language'=>$multi_language_names,
        'subcategory_banner_heading'=>$request->subcategory_banner_name_1,
        'subcategory_multi_banner_heading'=> $multi_banner_heading,
        'subcategory_banner_description'=>$request->subcategory_banner_description_1,
        'subcategory_multi_banner_description'=>$multi_banner_description,
        'priority'=>0,
        'subcategory_permalink'=>permalink_generator($request->subcategory_name_1),
    ];

    
        //Image Uploading Section
            if ($image = $request->file('image'))
             {  
            $original_file_destination='uploads/subcategory_org_images/';
            $desination_path='uploads/subcategory_images/';
            $image_resolution=env('SUBCATEGORYIMAGESIZE');
            $image=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $data['subcategory_image'] =$image;
            }
        //End Of Image Uploading Section

        //Subcategory Banner Uploading Section
            if ($image = $request->file('subcategory_banner'))
             {  
            $original_file_destination='uploads/subcategory_org_images/';
            $desination_path='uploads/subcategory_images/';
            $image_resolution=env('SUBCATEGORYBANNERSIZE');
            $image=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
             $data['subcategory_banner'] =$image;
            }
         //End Of Image Uploading Section

        
      $update=subcategoryModel::where('subcategory_id',$id)->update($data); 
     if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Subcategory '.$request->subcategory_name_1.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subcategory updated successfully']);
     }
     else{
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
     }
     
    }

     public function delete_subcategory(Request $request){
        $id=$request->id;
        $details=subcategoryModel::where('subcategory_id',$id)->first();
        $update=subcategoryModel::where('subcategory_id',$id)->update(['subcategory_status'=>1]);
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Subcategory '.$details->subcategory_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subcategory removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }
    
    public function change_order(Request $request){
        $ids = $request->ids;
        $i=0;
        $array = explode(',',$ids);
    
        foreach($array as $id){
            $i++;

            $update=subcategoryModel::where('subcategory_id',$id)->update(['priority' => $i]);
        }
        
        return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Subcategory  Order Updated ']);
        
    }



}