<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\stocklogModel;
use App\Models\recipeModel;
use DB;
use Auth;
class stockController extends Controller
{

    public function index(){
        return view('admin.stock.index');
    }

    public function stock_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        
         $fetch_data=recipeModel::select('recipe_id','recipe_name','recipe_price','recipe_offer_price','recipe_stock')->Where(function($query) use ($search)  
	                     {
	                        $query->Where('recipe_name', 'like', '%'.$search . '%');
                            $query->orwhere('recipe_name_multi_language', 'like', '%'.$search . '%');
	                        });

        $fetch_data->orderBy('recipe_id','Desc');

        $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);

    }
   

    public function stock_log(){
      return view('admin.stock.stocklog');
    }

    public function stock_log_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;


        $fetch_data=stocklogModel::Where(function($query) use ($search)  
	                     {
	                        $query->Where('stock_log_item_name', 'like', '%'.$search . '%');
                            $query->orwhere('stock_log_comment', 'like', '%'.$search . '%');
	                        });
        if(session('from_date'))
        {
        $from_date = date("Y-m-d", strtotime(session('from_date')));
        if(session('to_date'))
        	{
            $to_date = date("Y-m-d", strtotime(session('to_date')));
        	$fetch_data=$fetch_data->where('stock_log_date','>=',    $from_date);
        	$fetch_data->where('stock_log_date','<=',$to_date);
        	}
        else
        	{
        	$fetch_data=$fetch_data->where('stock_log_date',$from_date);
        	}
        }

        $fetch_data->orderBy('stock_log_id','Desc');


        $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);

    }

    public function update_stock(Request $request){

        try{
             DB::begintransaction();
        $item_id=$request->item_id;
        $updating_stock=$request->updating_stock;

        $get_item_details=recipeModel::where('recipe_id',$item_id)->first();
        $current_stock=$get_item_details->recipe_stock;
        $stock_diff=0;
        
        if($updating_stock>$current_stock){
            $stock_diff=$updating_stock-$current_stock ;
            $stock_in_or_out=1;
            $stock_action="updated";
        }
        else if ($updating_stock < $current_stock){
            $stock_diff=$current_stock-$updating_stock ;
            $stock_in_or_out=0;
            $stock_action="reduced";
        }


    if($stock_diff){
    // update stock and Stock Log
    $recipe_id=$item_id;
    $recipe_name=$get_item_details->recipe_name;
    $stock_current_qty=$current_stock;
    $stock_changing_qty=$stock_diff;
    $stock_updated_qty=$updating_stock;
    $comment='Item '.$recipe_name.' stock has been '.$stock_action.' by '.Auth::user()->name;
     stock_and_stock_log($recipe_name,$recipe_id,$stock_in_or_out,$stock_current_qty,$stock_changing_qty,$stock_updated_qty,$comment);
    DB::commit();
     return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Stock Updated successfully']);
    }
    else{
        return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'No Changes In Stock']);
    }

        }
        catch(QueryException $e){

            Db::rollback();
        }
    }

}