<?php

namespace App\Http\Controllers;
use App\Models\categoryModel;
use App\Models\sectionModel;
use App\Models\recipeModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
class sectionController extends Controller
{
    public function index(){
        $data['available_languages']=get_available_language();
        $data['category_wise_recipies']=categoryModel::with('recipe')->get();
        return view('admin.website.section',compact('data'));
    }
    public function add_section(Request $request){
          
        ##########################validation Section ###############################
        $dynamic_input_required=['section_name'];
        $dynamic_validation_array=validation_array('section',$dynamic_input_required);
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
         $validation_array['section_recipies']='required';
 
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################
                
        $section =new sectionModel();
        $section->section_status=0;
        $section->section_ip=$request->ip();
        $section->section_name=$request->section_name_1;
        $section->section_permalink=permalink_generator($request->section_name_1);
        //Mutlilanguage section
           $request_para="section_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $section->section_name_multi_language=$multi_language_names;
        //End Of Multilanguage Section
        $section->section_recipies=json_encode($request->section_recipies,true);
        $section->added_by=Auth::user()->id;
        $section->updated_by=Auth::user()->id;
        $section->save();
        if($section){
           ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Section '.$request->section_name_1.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Section added successfully ']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
        
                        
    }

    public function section_datatable(Request $request){
         $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_section.section_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }


        $fetch = sectionModel::where('section_status',0)
        ->leftjoin('users','tbl_section.added_by','users.id')
        ->select('tbl_section.*','users.name')
        ->Where(function($query) use ($search) {
            $query->where('section_name', 'like', $search . '%');
        });
       if ($colName != '' && $sort != '') {
           $fetch->orderBy($colName, $sort);
       }
       else{
         $fetch->orderBy('category_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $fetch->count(), 'iTotalRecords' => $fetch->count(), 'TotalDisplayRecords' => $limit];
       $sections= $fetch->skip($offset)->take($limit)->get()->toArray();
       $i=0;
       foreach( $sections as $section){
        $recipes=json_decode($section['section_recipies'],true);
        $section_recipies=recipeModel::select('recipe_name')->whereIn('recipe_id',$recipes)->get();
        $sections[$i]['recipies']=$section_recipies;
        $i++;
       }
       $data['data']=$sections;
       return response()->json($data);
    }

    public function edit_section(Request $request){
      $id=$request->id;
      $data=sectionModel::select('*')->where('section_id',$id)->first();
      $recipes=json_decode($data->section_recipies,true);
      $data->recipies=$recipes;
      return response()->json($data);
    }

    public function update_section(Request $request ){
        ##########################validation Section ###############################
        $dynamic_input_required=['section_name'];
        $dynamic_validation_array=validation_array('section',$dynamic_input_required);
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
         $validation_array['section_recipies']='required';
          $validation_array['section_id']='required';
 
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################

        $data=['section_name'=>$request->section_name_1,
              'section_recipies'=>json_encode($request->section_recipies,true),
              'section_permalink'=>permalink_generator($request->section_name_1),
              'updated_by'=>Auth::user()->id
         ];

         //Mutlilanguage section
           $request_para="section_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $data['section_name_multi_language']=$multi_language_names;
        //End Of Multilanguage Section

         $update=sectionModel::where('section_id',$request->section_id)->update($data);

          if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Section '.$request->section_name_1.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Section updated successfully']);
     }
     else{
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
     }

    }

    public function delete_section(Request $request){
        $id=$request->id;
        $details=sectionModel::where('section_id',$id)->first();
        $update=sectionModel::where('section_id',$id)->update(['section_status'=>1]);
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Section '.$details->section_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Section removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function change_section_status(Request $request){
        $section_id=$request->section_id;
        $status=$request->status;
        $details=sectionModel::where('section_id',$section_id)->first();
        $update=sectionModel::where('section_id',$section_id)->update(['section_active_status'=>$status]);
        if($status==0){  $change_status="Activated"; }else{  $change_status="Inactivated";   }
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']=$change_status;
       $user_activity_log['activity_desc']='Section '.$details->section_name.' Has Been '.$change_status. ' By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Section  '.$change_status.'  successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function section_view(Request $request){
       $id=$request->id;
       $data['section_data']=sectionModel::where('section_id',$id)->first();

        //Section Recipies
        $section_recipies_id=json_decode($data['section_data']->section_recipies,true);
        $data['recipies']=recipeModel::select('recipe_name','recipe_price','recipe_image','recipe_id','recipe_offer_price')->whereIn('recipe_id',$section_recipies_id)->get();
        //End Of Section Recipies

        $section_name_multi_language=json_decode($data['section_data']->section_name_multi_language,true);
        $available_languages=get_available_language();
        #######################Section Name Multilanguage Section  ############
       $multi_name_array=array();
       foreach($section_name_multi_language as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
               
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => 'Section Name '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_name_array,$languag_data);
                $data['multi_name_array']=$multi_name_array;
            }
            }

       }
    #######################End Of Section Name Multilanguage Section  ###########
    
       return view('admin.website.section_modal')->with('data',$data);
    }

    public function section_remove_recipe(Request $request){
        $id=$request->id;
        $section_id=$request->section_id;
        $get_section_details=sectionModel::where('section_id',$section_id)->first();
        $section_name=$get_section_details->section_name;
        $section_recipies=$get_section_details->section_recipies;
        $section_recipies=json_decode( $section_recipies,true);
     // dd($section_recipies);
             // Search for the value  and get its index
            $index = array_search($id, $section_recipies);

            // If the value is found, remove it from the array
            if ($index !== false) {
                unset($section_recipies[$index]);
            }
        $recipe_name=recipeModel::where('recipe_id',$id)->first()->recipe_name;
        $return_recipies=recipeModel::whereIn('recipe_id',$section_recipies)->get()->toArray();
        $update=sectionModel::where('section_id',$section_id)->update(['section_recipies'=>json_encode($section_recipies,true)]);
        if($update==1){
           ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Recipe '.$recipe_name.' From The Section '.$section_name.'  Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Recipe removed successfully','data'=>$return_recipies]);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }


    }
    
} 