<?php

namespace App\Http\Controllers;

use App\Models\branchModel;
use App\Models\orderModel;
use App\Models\inventoryModel;
use App\Models\layoutModel;
use App\Models\User;
use App\Models\orderitemModel;
use App\Models\inventoryitemModel;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\dailywiseExport;
use App\Exports\dailywisesaleExport;
use App\Exports\monthwisesaleExport;
use App\Exports\monthlywiseExport;
use App\Exports\customerExport;
use App\Exports\mostsoldproductexport;
use App\Exports\mostsolditemtexport;
use Illuminate\Http\Request;
use DB;
use PDF;

class reportController extends Controller
{

    ##############################Daily Wise Report Section###########################
    public function daily_wise()
    {
        return view('admin.reports.daily.index ');
    }

    public function daily_wise_datatable(Request $request)
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $limit = ($request->length != '') ? $request->length : 15;
            $offset = ($request->start != '') ? $request->start : 0;
            $search = $request->search['value'];
            $order = $request->order;
            $columns = $request->columns;

            $fetch_data = orderModel::
            // selectRaw('order_date,count(order_id) as total_order_count')
            selectRaw('order_date,count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_id  end ) as total_order_count,
          count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count,
          count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count,
          sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_grand_total  end ) as grand_total,
          sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum,
          sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum
          ')->where('delivery_type', 1)->where('branch_id', $branch_id->id);
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }
            $fetch_data->groupBy('order_date')->orderBy('order_date', 'DESC');

            $iTotalRecords = count($fetch_data->get()->toArray());
            $data = ["iTotalDisplayRecords" => $iTotalRecords, "iTotalRecords" => $iTotalRecords, "TotalDisplayRecords" => $limit];
            $dataMod = $fetch_data->skip($offset)->take($limit)->get();

            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;


            foreach ($dataMod as $key => $item) {


                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }


            foreach ($dataMod as $key => $item) {
                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;

            }
            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }else{
            $limit = ($request->length != '') ? $request->length : 15;
            $offset = ($request->start != '') ? $request->start : 0;
            $search = $request->search['value'];
            $order = $request->order;
            $columns = $request->columns;

            $fetch_data = orderModel::
            // selectRaw('order_date,count(order_id) as total_order_count')
            selectRaw('order_date,count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_id  end ) as total_order_count,
          count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count,
          count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count,
          sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_grand_total  end ) as grand_total,
          sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum,
          sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum
          ');
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }
            $fetch_data->groupBy('order_date')->orderBy('order_date', 'DESC');

            $iTotalRecords = count($fetch_data->get()->toArray());
            $data = ["iTotalDisplayRecords" => $iTotalRecords, "iTotalRecords" => $iTotalRecords, "TotalDisplayRecords" => $limit];
            $dataMod = $fetch_data->skip($offset)->take($limit)->get();

            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;


            foreach ($dataMod as $key => $item) {


                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }


            foreach ($dataMod as $key => $item) {
                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;

            }
            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }
    }


    #################################Excel Section###################
    public function daily_report_excel_export()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = orderModel::
            selectRaw('order_date,count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_id  end ) as total_order_count,
          count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count,
          count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count,
          sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_grand_total  end ) as grand_total,
          sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum,
          sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum
          ')->where('delivery_type', 1)->where('branch_id', $branch_id->id);
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }
            $fetch_data->groupBy('order_date')->orderBy('order_date', 'DESC');

            $dataMod = $fetch_data->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Daily Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Order Daily Report";


            return Excel::download(new dailywiseExport($data), $file_name . '.xlsx');
        }else{
            $fetch_data = orderModel::
            selectRaw('order_date,count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_id  end ) as total_order_count,
          count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count,
          count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count,
          sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_grand_total  end ) as grand_total,
          sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum,
          sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum
          ');
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }
            $fetch_data->groupBy('order_date')->orderBy('order_date', 'DESC');

            $dataMod = $fetch_data->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Daily Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Order Daily Report";


            return Excel::download(new dailywiseExport($data), $file_name . '.xlsx');
        }

    }


    public function daily_report_pdf_export()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = orderModel::
            selectRaw('order_date,count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_id  end ) as total_order_count,
          count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count,
          count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count,
          sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_grand_total  end ) as grand_total,
          sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum,
          sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum
          ')->where('delivery_type', 1)->where('branch_id', $branch_id->id);
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }
            $fetch_data->groupBy('order_date')->orderBy('order_date', 'DESC');

            $dataMod = $fetch_data->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Daily Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }

            $data['filter_range'] = $filter_range;
            $data['heading'] = "Order Daily Report";
            $data['company_details'] = layoutModel::first();


            $pdf = PDF::loadView('admin.reports.daily.daily_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }else{
            $fetch_data = orderModel::
            selectRaw('order_date,count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_id  end ) as total_order_count,
          count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count,
          count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count,
          sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" then order_grand_total  end ) as grand_total,
          sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum,
          sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum
          ');
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }
            $fetch_data->groupBy('order_date')->orderBy('order_date', 'DESC');

            $dataMod = $fetch_data->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Daily Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }

            $data['filter_range'] = $filter_range;
            $data['heading'] = "Order Daily Report";
            $data['company_details'] = layoutModel::first();


            $pdf = PDF::loadView('admin.reports.daily.daily_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }

    }
    ###############################End Of Daily Wise Report Section###################

    ##############################Month Wise Report Section###########################
    public function monthly_wise()
    {
        return view('admin.reports.monthly.index ');
    }

    public function month_wise_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $data1 = orderModel::select(
                DB::raw('count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or  order_tracking_status="Invoiced" then order_id  end ) as total_order_count'),
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count'),
                DB::raw('count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count'),
                DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled"  or  order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum'),
                DB::raw('sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year')
            )->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->Where(function ($query) use ($search) {
                    $query->Where('order_date', 'like', $search . '%');
                });
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('order_date', '>=', $from_date);
                    $data1->where('order_date', '<=', $to_date);
                } else {
                    $data1->where('order_date', $from_date);
                }
            }
            $data1->whereYear('order_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $data = ["iTotalDisplayRecords" => count($data1->get()), "iTotalRecords" => count($data1->get()), "TotalDisplayRecords" => $limit];
            $dataMod = $data1->skip($offset)->take($limit)->get();

            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;


            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }

            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }else{
            $data1 = orderModel::select(
                DB::raw('count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or  order_tracking_status="Invoiced" then order_id  end ) as total_order_count'),
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count'),
                DB::raw('count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count'),
                DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled"  or  order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum'),
                DB::raw('sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year')
            )
                ->Where(function ($query) use ($search) {
                    $query->Where('order_date', 'like', $search . '%');
                });
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('order_date', '>=', $from_date);
                    $data1->where('order_date', '<=', $to_date);
                } else {
                    $data1->where('order_date', $from_date);
                }
            }
            $data1->whereYear('order_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $data = ["iTotalDisplayRecords" => count($data1->get()), "iTotalRecords" => count($data1->get()), "TotalDisplayRecords" => $limit];
            $dataMod = $data1->skip($offset)->take($limit)->get();

            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;


            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }

            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }
    }

    public function monthly_report_excel_export()
    {

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $data1 = orderModel::select(
                DB::raw('count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or  order_tracking_status="Invoiced" then order_id  end ) as total_order_count'),
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count'),
                DB::raw('count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count'),
                DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled"  or  order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum'),
                DB::raw('sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year')
            )->where('delivery_type', 1)->where('branch_id', $branch_id->id);


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('order_date', '>=', $from_date);
                    $data1->where('order_date', '<=', $to_date);
                } else {
                    $data1->where('order_date', $from_date);
                }
            }
            $data1->whereYear('order_date', date('Y'));
            $data1->groupBy('month_name', 'year');

            $dataMod = $data1->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Monthly Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Order Month Wise Report";
            return Excel::download(new monthlywiseExport($data), $file_name . '.xlsx');
        }else{
            $data1 = orderModel::select(
                DB::raw('count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or  order_tracking_status="Invoiced" then order_id  end ) as total_order_count'),
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count'),
                DB::raw('count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count'),
                DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled"  or  order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum'),
                DB::raw('sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year')
            );


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('order_date', '>=', $from_date);
                    $data1->where('order_date', '<=', $to_date);
                } else {
                    $data1->where('order_date', $from_date);
                }
            }
            $data1->whereYear('order_date', date('Y'));
            $data1->groupBy('month_name', 'year');

            $dataMod = $data1->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Monthly Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Order Month Wise Report";
            return Excel::download(new monthlywiseExport($data), $file_name . '.xlsx');
        }

    }

    public function monthly_report_pdf_export()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $data1 = orderModel::select(
                DB::raw('count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or  order_tracking_status="Invoiced" then order_id  end ) as total_order_count'),
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count'),
                DB::raw('count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count'),
                DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled"  or  order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum'),
                DB::raw('sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year')
            )->where('delivery_type', 1)->where('branch_id', $branch_id->id);


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('order_date', '>=', $from_date);
                    $data1->where('order_date', '<=', $to_date);
                } else {
                    $data1->where('order_date', $from_date);
                }
            }
            $data1->whereYear('order_date', date('Y'));
            $data1->groupBy('month_name', 'year');

            $dataMod = $data1->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Monthly Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {
                    $filter_range = session('from_date') . ' to ' . session('to_date');

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $filter_range = "Date " . session('from_date');
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Order Month Wise Report";


            $data['company_details'] = layoutModel::first();

            $data['filter_range'] = $filter_range;


            $pdf = PDF::loadView('admin.reports.monthly.monthly_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }else{
            $data1 = orderModel::select(
                DB::raw('count(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or  order_tracking_status="Invoiced" then order_id  end ) as total_order_count'),
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as approved_count'),
                DB::raw('count(case when order_tracking_status="Cancelled"  then order_id   end ) as cancelled_count'),
                DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled"  or  order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total   end ) as approved_sum'),
                DB::raw('sum(case when order_tracking_status="Cancelled"  then order_grand_total   end ) as cancelled_sum'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year')
            );


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('order_date', '>=', $from_date);
                    $data1->where('order_date', '<=', $to_date);
                } else {
                    $data1->where('order_date', $from_date);
                }
            }
            $data1->whereYear('order_date', date('Y'));
            $data1->groupBy('month_name', 'year');

            $dataMod = $data1->get();


            $total_order = 0;
            $total_approved_order = 0;
            $total_cancelled_order = 0;
            $total_order_amount = 0;
            $total_approved_amount = 0;
            $total_cancelled_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_order = $total_order + $item['total_order_count'];
                $total_approved_order = $total_approved_order + $item['approved_count'];
                $total_cancelled_order = $total_cancelled_order + $item['cancelled_count'];
                $total_order_amount = $total_order_amount + $item['grand_total'];
                $total_approved_amount = $total_approved_amount + $item['approved_sum'];
                $total_cancelled_amount = $total_cancelled_amount + $item['cancelled_sum'];

            }
            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->approved_count == "") {
                    $item->approved_count = 0;
                }

                if ($item->cancelled_count == "") {
                    $item->cancelled_count = 0;
                }
                if ($item->grand_total == "") {
                    $item->grand_total = 0;
                }
                if ($item->approved_sum == "") {
                    $item->approved_sum = 0;
                }
                if ($item->cancelled_sum == "") {
                    $item->cancelled_sum = 0;
                }


                $item->total_order = $total_order;
                $item->total_approved_order = $total_approved_order;
                $item->total_cancelled_order = $total_cancelled_order;
                $item->total_order_amount = $total_order_amount;
                $item->total_approved_amount = $total_approved_amount;
                $item->total_cancelled_amount = $total_cancelled_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Monthly Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {
                    $filter_range = session('from_date') . ' to ' . session('to_date');

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $filter_range = "Date " . session('from_date');
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Order Month Wise Report";


            $data['company_details'] = layoutModel::first();

            $data['filter_range'] = $filter_range;


            $pdf = PDF::loadView('admin.reports.monthly.monthly_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }


    }


    ###############################End Of Month Wise Report Section###################


    ###################################Customer wise report######################

    public function customer_wise()
    {
        return view('admin.reports.customer_wise.index');
    }

    public function customer_wise_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = orderModel::select('tbl_customers.customer_name', 'tbl_customers.customer_mob',
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as total_order_count'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total  end ) as total_order_amount'))
                ->leftjoin('tbl_customers', 'tbl_customers.customer_id', 'tbl_orders.order_customer_id')
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->where('order_tracking_status', 'Approved')
                ->Where(function ($query) use ($search) {
                    $query->Where('tbl_customers.customer_name', 'like', $search . '%');
                });


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }

            $fetch_data->groupBy('order_customer_id')->orderBy('total_order_amount', 'Desc');


            $data = ["iTotalDisplayRecords" => count($fetch_data->get()), "iTotalRecords" => count($fetch_data->get()), "TotalDisplayRecords" => $limit];
            $dataMod = $fetch_data->skip($offset)->take($limit)->get();


            $grand_order_count = $grand_order_amount = 0;

            foreach ($dataMod as $key => $item) {
                $grand_order_count = $grand_order_count + $item['total_order_count'];
                $grand_order_amount = $grand_order_amount + $item['total_order_amount'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->total_order_amount == "") {
                    $item->total_order_amount = 0;
                }

                $item->grand_order_count = $grand_order_count;
                $item->grand_order_amount = $grand_order_amount;
            }

            $data['data'] = $dataMod->toArray();

            return response()->json($data);
        }else{
            $fetch_data = orderModel::select('tbl_customers.customer_name', 'tbl_customers.customer_mob',
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as total_order_count'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total  end ) as total_order_amount'))
                ->leftjoin('tbl_customers', 'tbl_customers.customer_id', 'tbl_orders.order_customer_id')
                ->where('order_tracking_status', 'Approved')
                ->Where(function ($query) use ($search) {
                    $query->Where('tbl_customers.customer_name', 'like', $search . '%');
                });


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }

            $fetch_data->groupBy('order_customer_id')->orderBy('total_order_amount', 'Desc');


            $data = ["iTotalDisplayRecords" => count($fetch_data->get()), "iTotalRecords" => count($fetch_data->get()), "TotalDisplayRecords" => $limit];
            $dataMod = $fetch_data->skip($offset)->take($limit)->get();


            $grand_order_count = $grand_order_amount = 0;

            foreach ($dataMod as $key => $item) {
                $grand_order_count = $grand_order_count + $item['total_order_count'];
                $grand_order_amount = $grand_order_amount + $item['total_order_amount'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->total_order_amount == "") {
                    $item->total_order_amount = 0;
                }

                $item->grand_order_count = $grand_order_count;
                $item->grand_order_amount = $grand_order_amount;
            }

            $data['data'] = $dataMod->toArray();

            return response()->json($data);
        }


    }

    public function customer_report_excel_export()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = orderModel::select('tbl_customers.customer_name', 'tbl_customers.customer_mob',
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as total_order_count'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total  end ) as total_order_amount'))
                ->leftjoin('tbl_customers', 'tbl_customers.customer_id', 'tbl_orders.order_customer_id')
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->where('order_tracking_status', 'Approved');


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }

            $fetch_data->groupBy('order_customer_id')->orderBy('total_order_amount', 'Desc');

            $dataMod = $fetch_data->get();


            $grand_order_count = $grand_order_amount = 0;

            foreach ($dataMod as $key => $item) {
                $grand_order_count = $grand_order_count + $item['total_order_count'];
                $grand_order_amount = $grand_order_amount + $item['total_order_amount'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->total_order_amount == "") {
                    $item->total_order_amount = 0;
                }

                $item->grand_order_count = $grand_order_count;
                $item->grand_order_amount = $grand_order_amount;
            }


            $data['data'] = $dataMod->toArray();


            $file_name = "Customer Wise  Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            return Excel::download(new customerExport($data), $file_name . '.xlsx');
        }else{
            $fetch_data = orderModel::select('tbl_customers.customer_name', 'tbl_customers.customer_mob',
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as total_order_count'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total  end ) as total_order_amount'))
                ->leftjoin('tbl_customers', 'tbl_customers.customer_id', 'tbl_orders.order_customer_id')
                ->where('order_tracking_status', 'Approved');


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }

            $fetch_data->groupBy('order_customer_id')->orderBy('total_order_amount', 'Desc');

            $dataMod = $fetch_data->get();


            $grand_order_count = $grand_order_amount = 0;

            foreach ($dataMod as $key => $item) {
                $grand_order_count = $grand_order_count + $item['total_order_count'];
                $grand_order_amount = $grand_order_amount + $item['total_order_amount'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->total_order_amount == "") {
                    $item->total_order_amount = 0;
                }

                $item->grand_order_count = $grand_order_count;
                $item->grand_order_amount = $grand_order_amount;
            }


            $data['data'] = $dataMod->toArray();


            $file_name = "Customer Wise  Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            return Excel::download(new customerExport($data), $file_name . '.xlsx');
        }


    }

    public function customer_report_pdf_export()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = orderModel::select('tbl_customers.customer_name', 'tbl_customers.customer_mob',
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as total_order_count'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total  end ) as total_order_amount'))
                ->leftjoin('tbl_customers', 'tbl_customers.customer_id', 'tbl_orders.order_customer_id')
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->where('order_tracking_status', 'Approved');


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }

            $fetch_data->groupBy('order_customer_id')->orderBy('total_order_amount', 'Desc');

            $dataMod = $fetch_data->get();


            $grand_order_count = $grand_order_amount = 0;

            foreach ($dataMod as $key => $item) {
                $grand_order_count = $grand_order_count + $item['total_order_count'];
                $grand_order_amount = $grand_order_amount + $item['total_order_amount'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->total_order_amount == "") {
                    $item->total_order_amount = 0;
                }

                $item->grand_order_count = $grand_order_count;
                $item->grand_order_amount = $grand_order_amount;
            }


            $data['data'] = $dataMod->toArray();


            $file_name = "Customer Wise  Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;
                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }
            $data['company_details'] = layoutModel::first();
            $data['heading'] = "Order Customer Wise Report";
            $data['filter_range'] = $filter_range;

            $pdf = PDF::loadView('admin.reports.customer_wise.customer_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }else{
            $fetch_data = orderModel::select('tbl_customers.customer_name', 'tbl_customers.customer_mob',
                DB::raw('count(case when order_tracking_status="Approved"  then order_id  end ) as total_order_count'),
                DB::raw('sum(case when order_tracking_status="Approved"  then order_grand_total  end ) as total_order_amount'))
                ->leftjoin('tbl_customers', 'tbl_customers.customer_id', 'tbl_orders.order_customer_id')
                ->where('order_tracking_status', 'Approved');


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('order_date', '>=', $from_date);
                    $fetch_data->where('order_date', '<=', $to_date);
                } else {
                    $fetch_data->where('order_date', $from_date);
                }
            }

            $fetch_data->groupBy('order_customer_id')->orderBy('total_order_amount', 'Desc');

            $dataMod = $fetch_data->get();


            $grand_order_count = $grand_order_amount = 0;

            foreach ($dataMod as $key => $item) {
                $grand_order_count = $grand_order_count + $item['total_order_count'];
                $grand_order_amount = $grand_order_amount + $item['total_order_amount'];

            }


            foreach ($dataMod as $key => $item) {

                if ($item->total_order_count == "") {
                    $item->total_order_count = 0;
                }

                if ($item->total_order_amount == "") {
                    $item->total_order_amount = 0;
                }

                $item->grand_order_count = $grand_order_count;
                $item->grand_order_amount = $grand_order_amount;
            }


            $data['data'] = $dataMod->toArray();


            $file_name = "Customer Wise  Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;
                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }
            $data['company_details'] = layoutModel::first();
            $data['heading'] = "Order Customer Wise Report";
            $data['filter_range'] = $filter_range;

            $pdf = PDF::loadView('admin.reports.customer_wise.customer_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }
    }

    ############################### End Of Customer wise report###############

    public function item_wise()
    {
        return view('admin.reports.item_wise.index');
    }

    public function most_sold_item_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;


        $fetch_data = orderitemModel::select('recipe_name', 'recipe_price', 'recipe_offer_price',
            DB::raw('sum(order_item_quantity) as total_item_count'),
        )
            ->leftjoin('tbl_recipe', 'tbl_recipe.recipe_id', 'tbl_order_items.recipe_id')
            ->leftjoin('tbl_orders', 'tbl_orders.order_id', 'tbl_order_items.order_id')
            ->where('tbl_order_items.order_item_status', 0)
            ->where('tbl_orders.order_status', 0)
            ->where('tbl_orders.order_tracking_status', '!=', 'Cancelled')
            ->Where(function ($query) use ($search) {
                $query->Where('recipe_name', 'like', $search . '%');
            });


        if (session('from_date')) {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
            if (session('to_date')) {
                $to_date = date("Y-m-d", strtotime(session('to_date')));
                $fetch_data = $fetch_data->where('order_date', '>=', $from_date);
                $fetch_data->where('order_date', '<=', $to_date);
            } else {
                $fetch_data = $fetch_data->where('order_date', $from_date);
            }
        }


        $fetch_data = $fetch_data->groupBy('tbl_order_items.recipe_id')
            ->orderBy('total_item_count', 'Desc');


        $iTotalRecords = count($fetch_data->get()->toArray());
        $data = ["iTotalDisplayRecords" => $iTotalRecords, "iTotalRecords" => $iTotalRecords, "TotalDisplayRecords" => $limit];
        $dataMod = $fetch_data->skip($offset)->take($limit)->get();

        $total_count = 0;


        foreach ($dataMod as $key => $item) {
            $total_count = $total_count + $item['total_item_count'];

        }


        foreach ($dataMod as $key => $item) {
            $item->total_count = $total_count;
        }

        $data['data'] = $dataMod->toArray();
        return response()->json($data);
    }

    public function sold_item_excel_export()
    {


        $fetch_data = orderitemModel::select('recipe_name', 'recipe_price', 'recipe_offer_price',
            DB::raw('sum(order_item_quantity) as total_item_count'),
        )
            ->leftjoin('tbl_recipe', 'tbl_recipe.recipe_id', 'tbl_order_items.recipe_id')
            ->leftjoin('tbl_orders', 'tbl_orders.order_id', 'tbl_order_items.order_id')
            ->where('tbl_order_items.order_item_status', 0)
            ->where('tbl_orders.order_status', 0)
            ->where('tbl_orders.order_tracking_status', '!=', 'Cancelled');


        if (session('from_date')) {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
            if (session('to_date')) {
                $to_date = date("Y-m-d", strtotime(session('to_date')));
                $fetch_data = $fetch_data->where('order_date', '>=', $from_date);
                $fetch_data->where('order_date', '<=', $to_date);
            } else {
                $fetch_data = $fetch_data->where('order_date', $from_date);
            }
        }


        $fetch_data = $fetch_data->groupBy('tbl_order_items.recipe_id')
            ->orderBy('total_item_count', 'Desc');

        $dataMod = $fetch_data->get();

        $total_count = 0;


        foreach ($dataMod as $key => $item) {
            $total_count = $total_count + $item['total_item_count'];

        }


        foreach ($dataMod as $key => $item) {
            $item->total_count = $total_count;
        }


        $data['data'] = $dataMod->toArray();

        $file_name = "Most Order Item Report";
        if (session('from_date')) {
            if (session('to_date')) {

                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $to_date = date("d-m-Y", strtotime(session('to_date')));

                $file_name = $file_name . '-' . $from_date . '-' . $to_date;

            } else {
                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $file_name = $file_name . '-' . $from_date;
            }

        }

        $data['heading'] = "Most Order Product Report";
        return Excel::download(new mostsoldproductexport($data), $file_name . '.xlsx');


    }


    public function sold_item_pdf_export()
    {

        $fetch_data = orderitemModel::select('recipe_name', 'recipe_price', 'recipe_offer_price',
            DB::raw('sum(order_item_quantity) as total_item_count'),
        )
            ->leftjoin('tbl_recipe', 'tbl_recipe.recipe_id', 'tbl_order_items.recipe_id')
            ->leftjoin('tbl_orders', 'tbl_orders.order_id', 'tbl_order_items.order_id')
            ->where('tbl_order_items.order_item_status', 0)
            ->where('tbl_orders.order_status', 0)
            ->where('tbl_orders.order_tracking_status', '!=', 'Cancelled');


        if (session('from_date')) {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
            if (session('to_date')) {
                $to_date = date("Y-m-d", strtotime(session('to_date')));
                $fetch_data = $fetch_data->where('order_date', '>=', $from_date);
                $fetch_data->where('order_date', '<=', $to_date);
            } else {
                $fetch_data = $fetch_data->where('order_date', $from_date);
            }
        }


        $fetch_data = $fetch_data->groupBy('tbl_order_items.recipe_id')
            ->orderBy('total_item_count', 'Desc');

        $dataMod = $fetch_data->get();

        $total_count = 0;


        foreach ($dataMod as $key => $item) {
            $total_count = $total_count + $item['total_item_count'];

        }


        foreach ($dataMod as $key => $item) {
            $item->total_count = $total_count;
        }


        $data['data'] = $dataMod->toArray();


        $file_name = "Most Order Recipe Report";
        $filter_range = "";
        if (session('from_date')) {
            if (session('to_date')) {

                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $to_date = date("d-m-Y", strtotime(session('to_date')));

                $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                $filter_range = session('from_date') . ' to ' . session('to_date');

            } else {
                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $file_name = $file_name . '-' . $from_date;
                $filter_range = "Date " . session('from_date');
            }

        }

        $data['filter_range'] = $filter_range;
        $data['heading'] = "Most Order Item  Report";
        $data['company_details'] = layoutModel::first();


        $pdf = PDF::loadView('admin.reports.item_wise.item_wise_pdf_export', compact('data'));
        return $pdf->download($file_name . '.pdf');


    }


    ####################################Sale Report Section ##################################

    public function daily_wise_sale()
    {
        return view('admin.reports.sales.daily.index ');
    }

    public function daily_wise_datatable_sale(Request $request)
    {

        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = inventoryModel::
            selectRaw('invoice_date,count(invoice_id) as total_invoice_count,
          count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count,
          count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count,
          count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count,
          sum(invoice_grand_total) as total,
          sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total,
          sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total,
          sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total
          ')->where('delivery_type', 1)->where('branch_id', $branch_id->id);
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('invoice_date', '>=', $from_date);
                    $fetch_data->where('invoice_date', '<=', $to_date);
                } else {
                    $fetch_data->where('invoice_date', $from_date);
                }
            }
            $fetch_data->groupBy('invoice_date')->orderBy('invoice_date', 'DESC');

            $iTotalRecords = count($fetch_data->get()->toArray());
            $data = ["iTotalDisplayRecords" => $iTotalRecords, "iTotalRecords" => $iTotalRecords, "TotalDisplayRecords" => $limit];
            $dataMod = $fetch_data->skip($offset)->take($limit)->get();


            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }else{
            $fetch_data = inventoryModel::
            selectRaw('invoice_date,count(invoice_id) as total_invoice_count,
          count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count,
          count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count,
          count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count,
          sum(invoice_grand_total) as total,
          sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total,
          sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total,
          sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total
          ');
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('invoice_date', '>=', $from_date);
                    $fetch_data->where('invoice_date', '<=', $to_date);
                } else {
                    $fetch_data->where('invoice_date', $from_date);
                }
            }
            $fetch_data->groupBy('invoice_date')->orderBy('invoice_date', 'DESC');

            $iTotalRecords = count($fetch_data->get()->toArray());
            $data = ["iTotalDisplayRecords" => $iTotalRecords, "iTotalRecords" => $iTotalRecords, "TotalDisplayRecords" => $limit];
            $dataMod = $fetch_data->skip($offset)->take($limit)->get();


            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }


    }

    public function daily_report_pdf_export_sale(Request $request)
    {

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = inventoryModel::
            selectRaw('invoice_date,count(invoice_id) as total_invoice_count,
          count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count,
          count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count,
          count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count,
          sum(invoice_grand_total) as total,
          sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total,
          sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total,
          sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total
          ')->where('delivery_type', 1)->where('branch_id', $branch_id->id);
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('invoice_date', '>=', $from_date);
                    $fetch_data->where('invoice_date', '<=', $to_date);
                } else {
                    $fetch_data->where('invoice_date', $from_date);
                }
            }
            $fetch_data->groupBy('invoice_date')->orderBy('invoice_date', 'DESC');


            $dataMod = $fetch_data->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Daily Sale Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }

            $data['filter_range'] = $filter_range;
            $data['heading'] = " Daily Sale Report";
            $data['company_details'] = layoutModel::first();

            $pdf = PDF::loadView('admin.reports.sales.daily.daily_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }else{
            $fetch_data = inventoryModel::
            selectRaw('invoice_date,count(invoice_id) as total_invoice_count,
          count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count,
          count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count,
          count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count,
          sum(invoice_grand_total) as total,
          sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total,
          sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total,
          sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total
          ');
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('invoice_date', '>=', $from_date);
                    $fetch_data->where('invoice_date', '<=', $to_date);
                } else {
                    $fetch_data->where('invoice_date', $from_date);
                }
            }
            $fetch_data->groupBy('invoice_date')->orderBy('invoice_date', 'DESC');


            $dataMod = $fetch_data->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Daily Sale Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }

            $data['filter_range'] = $filter_range;
            $data['heading'] = " Daily Sale Report";
            $data['company_details'] = layoutModel::first();

            $pdf = PDF::loadView('admin.reports.sales.daily.daily_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }
    }


    public function daily_report_excel_export_sale(Request $request)
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = inventoryModel::
            selectRaw('invoice_date,count(invoice_id) as total_invoice_count,
          count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count,
          count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count,
          count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count,
          sum(invoice_grand_total) as total,
          sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total,
          sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total,
          sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total
          ')->where('delivery_type', 1)->where('branch_id', $branch_id->id);
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('invoice_date', '>=', $from_date);
                    $fetch_data->where('invoice_date', '<=', $to_date);
                } else {
                    $fetch_data->where('invoice_date', $from_date);
                }
            }
            $fetch_data->groupBy('invoice_date')->orderBy('invoice_date', 'DESC');


            $dataMod = $fetch_data->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();


            $file_name = "Daily Sale Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Daily Sale Report";

            return Excel::download(new dailywisesaleExport($data), $file_name . '.xlsx');
        }else{
            $fetch_data = inventoryModel::
            selectRaw('invoice_date,count(invoice_id) as total_invoice_count,
          count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count,
          count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count,
          count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count,
          sum(invoice_grand_total) as total,
          sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total,
          sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total,
          sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total
          ');
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $fetch_data->where('invoice_date', '>=', $from_date);
                    $fetch_data->where('invoice_date', '<=', $to_date);
                } else {
                    $fetch_data->where('invoice_date', $from_date);
                }
            }
            $fetch_data->groupBy('invoice_date')->orderBy('invoice_date', 'DESC');


            $dataMod = $fetch_data->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();


            $file_name = "Daily Sale Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Daily Sale Report";

            return Excel::download(new dailywisesaleExport($data), $file_name . '.xlsx');
        }


    }

    public function monthly_wise_sale()
    {
        return view('admin.reports.sales.monthly.index');
    }

    public function month_wise_datatable_sale(Request $request)
    {

        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $data1 = inventoryModel::select(
                DB::raw('count(invoice_id) as total_invoice_count'),
                DB::raw('count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count'),
                DB::raw('count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count'),
                DB::raw('count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count'),
                DB::raw('sum(invoice_grand_total) as total'),
                DB::raw('sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total'),
                DB::raw('sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year')

            )->where('delivery_type', 1)->where('branch_id', $branch_id->id)
                ->Where(function ($query) use ($search) {
                    $query->Where('invoice_date', 'like', $search . '%');
                });
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('invoice_date', '>=', $from_date);
                    $data1->where('invoice_date', '<=', $to_date);
                } else {
                    $data1->where('invoice_date', $from_date);
                }
            }
            $data1->whereYear('invoice_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $data = ["iTotalDisplayRecords" => count($data1->get()), "iTotalRecords" => count($data1->get()), "TotalDisplayRecords" => $limit];
            $dataMod = $data1->skip($offset)->take($limit)->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }else{
            $data1 = inventoryModel::select(
                DB::raw('count(invoice_id) as total_invoice_count'),
                DB::raw('count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count'),
                DB::raw('count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count'),
                DB::raw('count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count'),
                DB::raw('sum(invoice_grand_total) as total'),
                DB::raw('sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total'),
                DB::raw('sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year')

            )
                ->Where(function ($query) use ($search) {
                    $query->Where('invoice_date', 'like', $search . '%');
                });
            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('invoice_date', '>=', $from_date);
                    $data1->where('invoice_date', '<=', $to_date);
                } else {
                    $data1->where('invoice_date', $from_date);
                }
            }
            $data1->whereYear('invoice_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $data = ["iTotalDisplayRecords" => count($data1->get()), "iTotalRecords" => count($data1->get()), "TotalDisplayRecords" => $limit];
            $dataMod = $data1->skip($offset)->take($limit)->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();
            return response()->json($data);
        }

    }

    public function monthly_report_pdf_exports_sale()
    {

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $data1 = inventoryModel::select(
                DB::raw('count(invoice_id) as total_invoice_count'),
                DB::raw('count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count'),
                DB::raw('count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count'),
                DB::raw('count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count'),
                DB::raw('sum(invoice_grand_total) as total'),
                DB::raw('sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total'),
                DB::raw('sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year')

            )->where('delivery_type', 1)->where('branch_id', $branch_id->id);


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('invoice_date', '>=', $from_date);
                    $data1->where('invoice_date', '<=', $to_date);
                } else {
                    $data1->where('invoice_date', $from_date);
                }
            }
            $data1->whereYear('invoice_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $dataMod = $data1->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();


            $file_name = "Monthly Sale Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }

            $data['filter_range'] = $filter_range;
            $data['heading'] = " Monthly Sale Report";
            $data['company_details'] = layoutModel::first();

            $pdf = PDF::loadView('admin.reports.sales.monthly.monthly_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }else{
            $data1 = inventoryModel::select(
                DB::raw('count(invoice_id) as total_invoice_count'),
                DB::raw('count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count'),
                DB::raw('count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count'),
                DB::raw('count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count'),
                DB::raw('sum(invoice_grand_total) as total'),
                DB::raw('sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total'),
                DB::raw('sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year')

            );


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('invoice_date', '>=', $from_date);
                    $data1->where('invoice_date', '<=', $to_date);
                } else {
                    $data1->where('invoice_date', $from_date);
                }
            }
            $data1->whereYear('invoice_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $dataMod = $data1->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();


            $file_name = "Monthly Sale Report";
            $filter_range = "";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                    $filter_range = session('from_date') . ' to ' . session('to_date');

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                    $filter_range = "Date " . session('from_date');
                }

            }

            $data['filter_range'] = $filter_range;
            $data['heading'] = " Monthly Sale Report";
            $data['company_details'] = layoutModel::first();

            $pdf = PDF::loadView('admin.reports.sales.monthly.monthly_pdf_export', compact('data'));
            return $pdf->download($file_name . '.pdf');
        }

    }

    public function monthly_report_excel_export_sale()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $data1 = inventoryModel::select(
                DB::raw('count(invoice_id) as total_invoice_count'),
                DB::raw('count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count'),
                DB::raw('count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count'),
                DB::raw('count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count'),
                DB::raw('sum(invoice_grand_total) as total'),
                DB::raw('sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total'),
                DB::raw('sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year')

            )->where('delivery_type', 1)->where('branch_id', $branch_id->id);


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('invoice_date', '>=', $from_date);
                    $data1->where('invoice_date', '<=', $to_date);
                } else {
                    $data1->where('invoice_date', $from_date);
                }
            }
            $data1->whereYear('invoice_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $dataMod = $data1->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Monthly Sale Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Monthly Sale Report";

            return Excel::download(new monthwisesaleExport($data), $file_name . '.xlsx');
        }else{
            $data1 = inventoryModel::select(
                DB::raw('count(invoice_id) as total_invoice_count'),
                DB::raw('count(case when invoice_payment_type="cash"  then invoice_id  end ) as cash_count'),
                DB::raw('count(case when invoice_payment_type="card"  then invoice_id   end ) as card_count'),
                DB::raw('count(case when invoice_payment_type="cash&card"  then invoice_id   end ) as cash_and_card_count'),
                DB::raw('sum(invoice_grand_total) as total'),
                DB::raw('sum(case when invoice_payment_type="cash" then invoice_grand_total  end ) as cash_total'),
                DB::raw('sum(case when invoice_payment_type="card"  then invoice_grand_total   end ) as card_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total   end ) as cash_and_card_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year')

            );


            if (session('from_date')) {
                $from_date = date("Y-m-d", strtotime(session('from_date')));
                if (session('to_date')) {
                    $to_date = date("Y-m-d", strtotime(session('to_date')));
                    $data1->where('invoice_date', '>=', $from_date);
                    $data1->where('invoice_date', '<=', $to_date);
                } else {
                    $data1->where('invoice_date', $from_date);
                }
            }
            $data1->whereYear('invoice_date', date('Y'));
            $data1->groupBy('month_name', 'year');


            $dataMod = $data1->get();

            $total_count = $total_card_count = $total_cash_count = $total_cash_and_card_count = $total_cash_amount = $total_card_amount = $total_cash_and_card_amount = $total_amount = 0;

            foreach ($dataMod as $key => $item) {
                $total_count = $total_count + $item['total_invoice_count'];
                $total_cash_count = $total_cash_count + $item['cash_count'];
                $total_card_count = $total_card_count + $item['card_count'];
                $total_cash_and_card_count = $total_cash_and_card_count + $item['cash_and_card_count'];
                $total_amount = $total_amount + $item['total'];
                $total_cash_amount = $total_cash_amount + $item['cash_total'];
                $total_card_amount = $total_card_amount + $item['card_total'];
                $total_cash_and_card_amount = $total_cash_and_card_amount + $item['cash_and_card_total'];
            }


            foreach ($dataMod as $key => $item) {
                $item->total_count = $total_count;
                $item->total_cash_count = $total_cash_count;
                $item->total_card_count = $total_card_count;
                $item->total_cash_and_card_count = $total_cash_and_card_count;
                $item->total_amount = $total_amount;
                $item->total_cash_amount = $total_cash_amount;
                $item->total_card_amount = $total_card_amount;
                $item->total_cash_and_card_amount = $total_cash_and_card_amount;
            }
            $data['data'] = $dataMod->toArray();

            $file_name = "Monthly Sale Report";
            if (session('from_date')) {
                if (session('to_date')) {

                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $to_date = date("d-m-Y", strtotime(session('to_date')));

                    $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                } else {
                    $from_date = date("d-m-Y", strtotime(session('from_date')));
                    $file_name = $file_name . '-' . $from_date;
                }

            }

            $data['heading'] = "Monthly Sale Report";

            return Excel::download(new monthwisesaleExport($data), $file_name . '.xlsx');
        }

    }

    public function item_wise_report_sale()
    {
        return view('admin.reports.sales.item_wise.index');
    }

    public function most_sold_item_datatable_sale(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;


        $fetch_data = inventoryitemModel::select('recipe_name', 'recipe_price', 'recipe_offer_price',
            DB::raw('sum(inventory_item_quantity) as total_item_count'),
        )->with('varient')
            ->leftjoin('tbl_recipe', 'tbl_recipe.recipe_id', 'tbl_inventory_items.inventory_item_id')
            ->leftjoin('tbl_inventory', 'tbl_inventory.invoice_id', 'tbl_inventory_items.inventory_id')
            ->where('tbl_inventory_items.item_status', 0)
            ->where('tbl_inventory_items.inventory_item_type', 1)
            ->where('tbl_inventory.invoice_status', 0)
            ->Where(function ($query) use ($search) {
                $query->Where('recipe_name', 'like', $search . '%');
            });


        if (session('from_date')) {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
            if (session('to_date')) {
                $to_date = date("Y-m-d", strtotime(session('to_date')));
                $fetch_data = $fetch_data->where('invoice_date', '>=', $from_date);
                $fetch_data->where('invoice_date', '<=', $to_date);
            } else {
                $fetch_data = $fetch_data->where('invoice_date', $from_date);
            }
        }


        $fetch_data = $fetch_data->groupBy('tbl_inventory_items.inventory_item_id')
            ->orderBy('total_item_count', 'Desc');


        $iTotalRecords = count($fetch_data->get()->toArray());
        $data = ["iTotalDisplayRecords" => $iTotalRecords, "iTotalRecords" => $iTotalRecords, "TotalDisplayRecords" => $limit];
        $dataMod = $fetch_data->skip($offset)->take($limit)->get();


        $total_count = 0;


        foreach ($dataMod as $key => $item) {
            $total_count = $total_count + $item['total_item_count'];

        }


        foreach ($dataMod as $key => $item) {
            $item->total_count = $total_count;
        }

        $data['data'] = $dataMod->toArray();

        // dd($data['data']);
        return response()->json($data);
    }

    public function sold_item_pdf_export_sale()
    {
        $fetch_data = inventoryitemModel::select('recipe_name', 'recipe_price', 'recipe_offer_price',
            DB::raw('sum(inventory_item_quantity) as total_item_count'),
        )->with('varient')
            ->leftjoin('tbl_recipe', 'tbl_recipe.recipe_id', 'tbl_inventory_items.inventory_item_id')
            ->leftjoin('tbl_inventory', 'tbl_inventory.invoice_id', 'tbl_inventory_items.inventory_id')
            ->where('tbl_inventory_items.item_status', 0)
            ->where('tbl_inventory_items.inventory_item_type', 1)
            ->where('tbl_inventory.invoice_status', 0);

        if (session('from_date')) {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
            if (session('to_date')) {
                $to_date = date("Y-m-d", strtotime(session('to_date')));
                $fetch_data = $fetch_data->where('invoice_date', '>=', $from_date);
                $fetch_data->where('invoice_date', '<=', $to_date);
            } else {
                $fetch_data = $fetch_data->where('invoice_date', $from_date);
            }
        }


        $fetch_data = $fetch_data->groupBy('tbl_inventory_items.inventory_item_id')
            ->orderBy('total_item_count', 'Desc');


        $dataMod = $fetch_data->get();


        $total_count = 0;


        foreach ($dataMod as $key => $item) {
            $total_count = $total_count + $item['total_item_count'];

        }


        foreach ($dataMod as $key => $item) {
            $item->total_count = $total_count;
        }

        $data['data'] = $dataMod->toArray();


        $file_name = "Most Sold Recipe Report";
        $filter_range = "";
        if (session('from_date')) {
            if (session('to_date')) {

                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $to_date = date("d-m-Y", strtotime(session('to_date')));

                $file_name = $file_name . '-' . $from_date . '-' . $to_date;

                $filter_range = session('from_date') . ' to ' . session('to_date');

            } else {
                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $file_name = $file_name . '-' . $from_date;
                $filter_range = "Date " . session('from_date');
            }

        }

        $data['filter_range'] = $filter_range;
        $data['heading'] = "Most Sold Item  Report";
        $data['company_details'] = layoutModel::first();


        $pdf = PDF::loadView('admin.reports.sales.item_wise.item_wise_pdf_export', compact('data'));
        return $pdf->download($file_name . '.pdf');

    }

    public function sold_item_excel_export_sale()
    {
        $fetch_data = inventoryitemModel::select('recipe_name', 'recipe_price', 'recipe_offer_price',
            DB::raw('sum(inventory_item_quantity) as total_item_count'),
        )->with('varient')
            ->leftjoin('tbl_recipe', 'tbl_recipe.recipe_id', 'tbl_inventory_items.inventory_item_id')
            ->leftjoin('tbl_inventory', 'tbl_inventory.invoice_id', 'tbl_inventory_items.inventory_id')
            ->where('tbl_inventory_items.item_status', 0)
            ->where('tbl_inventory_items.inventory_item_type', 1)
            ->where('tbl_inventory.invoice_status', 0);

        if (session('from_date')) {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
            if (session('to_date')) {
                $to_date = date("Y-m-d", strtotime(session('to_date')));
                $fetch_data = $fetch_data->where('invoice_date', '>=', $from_date);
                $fetch_data->where('invoice_date', '<=', $to_date);
            } else {
                $fetch_data = $fetch_data->where('invoice_date', $from_date);
            }
        }


        $fetch_data = $fetch_data->groupBy('tbl_inventory_items.inventory_item_id')
            ->orderBy('total_item_count', 'Desc');


        $dataMod = $fetch_data->get();


        $total_count = 0;


        foreach ($dataMod as $key => $item) {
            $total_count = $total_count + $item['total_item_count'];

        }


        foreach ($dataMod as $key => $item) {
            $item->total_count = $total_count;
        }

        $data['data'] = $dataMod->toArray();


        $file_name = "Most Sold Item Report";
        if (session('from_date')) {
            if (session('to_date')) {

                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $to_date = date("d-m-Y", strtotime(session('to_date')));

                $file_name = $file_name . '-' . $from_date . '-' . $to_date;

            } else {
                $from_date = date("d-m-Y", strtotime(session('from_date')));
                $file_name = $file_name . '-' . $from_date;
            }

        }

        $data['heading'] = "Most Sold Item Report";
        return Excel::download(new mostsolditemtexport($data), $file_name . '.xlsx');

    }

    #####################################End Of Sale Report Section #########################

}
