<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\recipe_add_on_Model;
use Illuminate\Support\Facades\Validator;
use Auth;

class recipe_add_on_Controller extends Controller
{
    public function index(){
       $data['available_languages']=get_available_language();
       return view('admin.recipe_add_on.index')->with($data);
    }

    public function add_add_on_recipe(Request $request){
        ##########################validation Section ###############################
        $dynamic_input_required=['adds_on_name'];
        $dynamic_validation_array=validation_array('adds_on',$dynamic_input_required);
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['adds_on_price']='required|numeric';
        $validation_array['image']=image_validation_rule('adds_on',env('ADDSONIMAGESIZE'),true,env('ADDSONIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,File_Max_Size)
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################
                    
        $recipe_add_on=new recipe_add_on_Model();
        $recipe_add_on->add_on_status=0;
        $recipe_add_on->add_on_ip=$request->ip();
         $recipe_add_on->add_on_name=$request->adds_on_name_1;

         //Mutlilanguage Name  section
           $request_para="adds_on_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $recipe_add_on->add_on_multi_name=$multi_language_names;
        //End Of Multilanguage name Section
        $recipe_add_on->add_on_price=$request->adds_on_price;
         //Image Uploading Section
       if ($image = $request->file('image')) {  
            $original_file_destination='uploads/add_on_org_images/';
            $desination_path='uploads/add_on_images/';
            $image_resolution=env('ADDSONIMAGESIZE');
            $icon=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $recipe_add_on->add_on_image =$icon;
        }
        //End Of Image Uploading Section

        $recipe_add_on->add_on_active_status=0;
        $recipe_add_on->created_by=Auth::user()->id;
        $recipe_add_on->updated_by=Auth::user()->id;
         $recipe_add_on->save();
        if($recipe_add_on){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Adds On '.$request->adds_on_name_1.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Adds On added successfully ']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    
    }

    public function add_on_datatable(Request $request){
            $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_recipe_adds_on.add_on_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }


        $category_data=$roles = recipe_add_on_Model::where('add_on_status',0)
        ->leftjoin('users','tbl_recipe_adds_on.created_by','users.id')
        ->select('tbl_recipe_adds_on.*','users.name')
        ->Where(function($query) use ($search) {
            $query->where('add_on_name', 'like', $search . '%');
            $query->orwhere('add_on_multi_name', 'like', $search . '%');

        });
       if ($colName != '' && $sort != '') {
           $category_data->orderBy($colName, $sort);
       }
       else{
         $category_data->orderBy('add_on_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $category_data->count(), 'iTotalRecords' => $category_data->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $category_data->skip($offset)->take($limit)->get()->toArray();

       return response()->json($data);
    }
    public function view_add_on(Request $request){
        $id=$request->id;
       $data['recipe_addd_on']=recipe_add_on_Model::where('add_on_id',$id)->first();
       $add_on_name_multi_language=json_decode($data['recipe_addd_on']->add_on_multi_name,true);
       $available_languages=get_available_language();
    #######################Category Name Multilanguage Section  ############
       $multi_name_array=array();
       foreach($add_on_name_multi_language as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
              
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => 'Recipe Add On Name '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_name_array,$languag_data);
                $data['multi_name_array']=$multi_name_array;
            }
            }

       }
    #######################End Of Category Name Multilanguage Section  ###########

        return view('admin.recipe_add_on.modal',compact('data'));
    }
    
    public function change_add_on__status(Request $request){
                $add_on_id=$request->id;
                $status=$request->status;
                $data=['add_on_active_status'=>$status];
                $update_status=recipe_add_on_Model::where('add_on_id',$add_on_id)->update($data);
                $details=recipe_add_on_Model::where('add_on_id',$add_on_id)->first();
                if($update_status==1){
                    ############################User Activity log#########################
                        $user_activity_log['activity_ip']=$request->ip(); 
                        $user_activity_log['activity_user_name']=Auth::user()->name;
                        $user_activity_log['activity_user_id']=Auth::user()->id; 
                        $user_activity_log['activity_action']="Updated";
                        $active_status="Activate";
                        if($status==1){$active_status="Inactivate";}
                        $user_activity_log['activity_desc']='Add On Recipe  '.$details->add_on_name.' Has Been '.$active_status.' By '.Auth::user()->name;
                        user_activity_log($user_activity_log);
                        ###########################End Of USer Activity Log###################
                    return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Status changed successfully']);
                }
                else{
                    return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
                }
        }
    
    public function edit_add_on(Request $request){
      $id=$request->id;
      $data=recipe_add_on_Model::select('*')->where('add_on_id',$id)->first();
      return response()->json($data);
    }

    public function update_add_on_recipe(Request $request){
       
        ########################## Validation Rule ####################
        $dynamic_input_required=['adds_on_name'];
        $dynamic_validation_array=validation_array('adds_on',$dynamic_input_required);
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['adds_on_price']='required|numeric';
        $validation_array['image']=image_validation_rule('adds_on',env('ADDSONIMAGESIZE'),false,env('ADDSONIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,Max_file_size)
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################

        
        $data=['add_on_ip' =>$request->ip(),
                'add_on_name'=>$request->adds_on_name_1,
                'add_on_price'=>$request->adds_on_price,
                'updated_by'=>Auth::user()->id
                    ];

        //Mutlilanguage Name  section
           $request_para="adds_on_name_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $data['add_on_multi_name']=$multi_language_names;
        //End Of Multilanguage name Section

        //Image Uploading Section
       if ($image = $request->file('image')) {  
            $original_file_destination='uploads/add_on_org_images/';
            $desination_path='uploads/add_on_images/';
            $image_resolution=env('ADDSONIMAGESIZE');
            $icon=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $data['add_on_image'] =$icon;
        }
        //End Of Image Uploading Section

    $update=recipe_add_on_Model::where('add_on_id',$request->add_on_id)->update($data); 
    
    if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Add On  '.$request->adds_on_name_1.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Add On updated successfully']);
     }
     else{
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
     }
   

    }

    public function delete_add_on(Request $request){
        $id=$request->id;
        $details=recipe_add_on_Model::where('add_on_id',$id)->first();
        $update=recipe_add_on_Model::where('add_on_id',$id)->update(['add_on_status'=>1]);
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Add On '.$details->add_on_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Add On    removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }

}