<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\categoryModel;
use App\Models\subcategoryModel;
use App\Models\recipeModel;
use App\Models\recipe_add_on_Model;
use App\Models\recipevarientModel;
use Auth;
use Image;
use Session;
use Illuminate\Support\Facades\Validator;

class recipeController extends Controller
{

    public function __construct()
    {
        ini_set('memory_limit', '440M');
    }


    public function index()
    {
        $data['categories'] = categoryModel::orderby('category_name', 'ASC')->get();
        $data['available_languages'] = get_available_language();
        $data['add_ons'] = recipe_add_on_Model::orderby('add_on_name', 'ASC')->groupBy('add_on_name')->get();

        return view('admin.recipe.index')->with(['data' => $data]);
    }

    public function fetch_subcategory(Request $request)
    {
        $id = $request->id;
        $data['subcatgories'] = subcategoryModel::where('subcategory_cid', $id)->where('subcategory_status', 0)->get();
        return $data;
    }

    public function add_recipe(Request $request)
    {
        ####################################validation Section ######################
        $dynamic_input_required = ['recipe_name'];
        $dynamic_validation_array = validation_array('recipe', $dynamic_input_required);  //Page,Required Fields
        $validation_array = $dynamic_validation_array['validation_array'];
        $custom_validation_array = $dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['category'] = 'required';
        $validation_array['recipe_name_ar'] = 'required';
        $validation_array['recipe_type'] = 'required';
        $validation_array['item_no'] = 'required';
        $validation_array['recipe_price'] = 'required|numeric';
        $validation_array['recipe_offer_price'] = 'required|numeric';
        $validation_array['recipe_preparation_time'] = 'numeric';
        $validation_array['stock_reminder'] = 'required|numeric';
        $validation_array['stock'] = 'required|numeric';
        $validation_array['image'] = 'required|image|mimes:png,jpg|max:2048';
        //$validation_array['image'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), true, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus)
        $validation_array['sub_image_1'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus)
        $validation_array['sub_image_2'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus)
        $validation_array['sub_image_3'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus)
        $validation_array['sub_image_4'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus)
        $validation_array['video'] = 'mimes:mp4,avi,mov|max:1000000';

        //End of  No Langauage Vdation push  To  Array

        $validator = Validator::make($request->all(), $validation_array, $custom_validation_array);


        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        ##############################End Of Validation Section ##############
        ##############################Check Exist The Same Recipe Exist ###############
        $check_exist = recipeModel::where('recipe_status', 0)->where('recipe_name', $request->recipe_name)->first();
        if ($check_exist) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $request->recipe_name . ' already Exist']);
        }
        #########################End Of Check Exist The Same Recipe Exist##################
        $recipe = new recipeModel();
        $recipe->recipe_image = '';

        //Image Uploading Section
        if ($image = $request->file('image')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $recipe->recipe_image = $image;
            $recipe->image_url = env('APP_URL').'/'.$desination_path.$image;
        }
        //End Of Image Uploading Section
        //Sub Image  1
        if ($image = $request->file('sub_image_1')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $recipe->recipe_sub_image_1 = $image;
        }
        //End Sub Image 1
        //Sub Image  2
        if ($image = $request->file('sub_image_2')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $recipe->recipe_sub_image_2 = $image;
        }
        //End Sub Image 2
        //Sub Image  3
        if ($image = $request->file('sub_image_3')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $recipe->recipe_sub_image_3 = $image;
        }
        //End Sub Image 3
        //Sub Image  4
        if ($image = $request->file('sub_image_4')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $recipe->recipe_sub_image_4 = $image;
        }
        //End Sub Image 4

        //Recipe Video Section
        if ($image = $request->file('video')) {
            $imageDestinationPath = 'uploads/recipe_videos';
            $postImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($imageDestinationPath, $postImage);
            $recipe->recipe_video = "$postImage";
        }
        //End of Recipe Video Section

        $recipe->recipe_status = 0;
        $recipe->recipe_ip = $request->ip();
        $recipe->recipe_category_id = $request->category;
        $recipe->recipe_veg_or_non = $request->recipe_type;
        $recipe->recipe_subcategory_id = $request->sub_category;
        $recipe->item_no = $request->item_no;
        $recipe->recipe_name = $request->recipe_name_1;
        $recipe->recipe_name_ar = $request->recipe_name_ar;
        $recipe->recipe_price = $request->recipe_price;
        if ($request->recipe_offer_price == "") {
            $request->recipe_offer_price = $request->recipe_price;
        }
        $recipe->recipe_offer_price = $request->recipe_offer_price;
        $recipe->recipe_description = $request->description_1;
        $recipe->recipe_description_ar = $request->description_ar;
        //Mutlilanguage section
        $request_para = "recipe_name_";
        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
        $recipe->recipe_name_multi_language = $multi_language_names;
        //End Of Multilanguage Section

        //Mutlilanguage section
        $request_para = "description_";
        $multi_language_description = get_mutli_language_json_input($request->all(), $request_para);
        $recipe->recipe_description_multi_language = $multi_language_description;
        //End Of Multilanguage Section

        $recipe->recipe_preparation_time = $request->recipe_preparation_time;
        $recipe->recipe_active_status = 1;
        $recipe->recipe_permalink = permalink_generator($request->recipe_name_1);
        $recipe->recipe_add_ons = json_encode($request->recipe_add_on, true);

        //Property Section
        $property_array = array();

        if($request->property_name) {
            foreach ($request->property_name as $key => $property) {
                if ($property) {
                    $property_array[$key] = $property;
                }
            }
            $recipe->recipe_properties = json_encode($property_array, true);
        }
        //End Of Propertiy Section
        //Stock and Stock Reminder
        $recipe->recipe_stock_reminder = $request->stock_reminder;
        $recipe->recipe_stock = $request->stock;
        $recipe->created_by = Auth::user()->id;
        $recipe->updated_by = Auth::user()->id;
        $recipe->save();
        if ($recipe) {
            //Set To Recipe Varient
            if ($request->variant_name != "") {
                $this->update_recipe_varinet($recipe->id, $request->variant_name, $request->variant_price, $request->default_recipe);
            }
            //End Of Set To Recipe Varient
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Added";
            $user_activity_log['activity_desc'] = 'New Recipe ' . $request->recipe_name . ' Has Been Added By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Recipe added successfully ']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function recipe_datatable(Request $request)
    {

        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_recipe.recipe_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $fetch_data = $roles = recipeModel::where('recipe_status', 0)
            ->leftjoin('tbl_category', 'tbl_recipe.recipe_category_id', 'tbl_category.category_id')
            ->leftjoin('users', 'tbl_recipe.created_by', 'users.id')
            ->select('tbl_recipe.*', 'tbl_category.category_name', 'users.name')
            ->Where(function ($query) use ($search) {
                $query->where('tbl_recipe.recipe_name', 'like', '%' . $search . '%');
                $query->Orwhere('tbl_category.category_name', 'like', $search . '%');
            });
        //category_wise Filter
        if (session('admin_category_filter')) {
            $fetch_data->where('recipe_category_id', session('admin_category_filter'));
        }
        //End OfCategory Wise Filter
        //Recipe Type Filter
        if (session('admin_recipe_type_filter')) {
            $fetch_data->where('recipe_veg_or_non', session('admin_recipe_type_filter'));
        }
        //End Of recipe Type Filter
        //Most Recommended Filter
        if (session('admin_recipe_most_recommended')) {
            $fetch_data->where('recipe_recommended_status', 1);
        }
        //End Of Most Recommended Filter

        if ($colName != '' && $sort != '') {
            $fetch_data->orderBy($colName, $sort);
        } else {
            $fetch_data->orderBy('recipe_id', 'DESC');
        }

        $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);

    }

    public function delete_recipe(Request $request)
    {
        $id = $request->id;
        $details = recipeModel::where('recipe_id', $id)->first();
        $update = recipeModel::where('recipe_id', $id)->update(['recipe_status' => 1]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Deleted";
            $user_activity_log['activity_desc'] = 'Recipe ' . $details->recipe_name . ' Has Been Deleted By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Recipe removed successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function edit_recipe(Request $request)
    {
        $id = $request->id;
        $recipe_data = recipeModel::select('*')->where('recipe_id', $id)->first();
        $recipe_data->total_add_on = recipe_add_on_Model::orderby('add_on_name', 'ASC')->get();

        $recipe_varients = recipevarientModel::where('recipe_id', $id)->where('varient_status', 0)->get()->toArray();
        $recipe_data->recipe_variants = $recipe_varients;
        return response()->json($recipe_data);
    }

    public function update_recipe(Request $request)
    {
        ####################################validation Section ######################
        $dynamic_input_required = ['recipe_name'];
        $dynamic_validation_array = validation_array('recipe', $dynamic_input_required);  //Page,Required Fields
        $validation_array = $dynamic_validation_array['validation_array'];
        $custom_validation_array = $dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['recipe_id'] = 'required|numeric';
        $validation_array['category'] = 'required';
        $validation_array['recipe_name_ar'] = 'required';
        $validation_array['recipe_type'] = 'required';
        $validation_array['item_no'] = 'required';
        $validation_array['recipe_price'] = 'required|numeric';
        $validation_array['recipe_offer_price'] = 'numeric';
        $validation_array['recipe_preparation_time'] = 'required|numeric';
        $validation_array['stock_reminder'] = 'required|numeric';
        $validation_array['stock'] = 'required|numeric';
        $validation_array['image'] = 'required|image|mimes:png,jpg|max:2048';
       // $validation_array['image'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus,max_upload_size)
        $validation_array['sub_image_1'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus,max_upload_size)
        $validation_array['sub_image_2'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE')); //image Validation (page,imagesize,requiredstatus,max_upload_size)
        $validation_array['sub_image_3'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus,max_upload_size)
        $validation_array['sub_image_4'] = image_validation_rule('recipe', env('RECIPE_IMAGE_SIZE'), false, env('RECIPE_IMAGE_FILE_SIZE'));  //image Validation (page,imagesize,requiredstatus,max_upload_size)
        $validation_array['video'] = 'mimes:mp4,avi,mov|max:1000000';
        //End of  No Langauage Vdation push  To  Array

        $validator = Validator::make($request->all(), $validation_array, $custom_validation_array);


        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        ##############################End Of Validation Section ##############
        $id = $request->recipe_id;

        if ($request->recipe_offer_price == "") {
            $request->recipe_offer_price = $request->recipe_price;
        }

        $data = [
            'recipe_category_id' => $request->category,
            'recipe_subcategory_id' => $request->sub_category,
            'recipe_veg_or_non' => $request->recipe_type,
            'item_no' => $request->item_no,
            'recipe_name' => $request->recipe_name_1,
            'recipe_name_ar' => $request->recipe_name_ar,
            'recipe_permalink' => permalink_generator($request->recipe_name_1),
            'recipe_price' => $request->recipe_price,
            'recipe_offer_price' => $request->recipe_offer_price,
            'recipe_preparation_time' => $request->recipe_preparation_time,
            'recipe_description' => $request->description_1,
            'recipe_description_ar' => $request->description_ar,
            'recipe_add_ons' => json_encode($request->recipe_add_on, true),
            'updated_by' => Auth::user()->id,
        ];
        //Set To Recipe Varient
        if ($request->variant_name != "") {
            $this->update_recipe_varinet($id, $request->variant_name, $request->variant_price, $request->default_recipe);
        }
        //End Of Set To Recipe Varient
        //Property Section
        if ($request->property_name) {
            $property_array = array();

            foreach ($request->property_name as $key => $property) {
                if ($property) {
                    $property_array[$key] = $property;
                }
            }
            $data['recipe_properties'] = json_encode($property_array, true);
        }
        //End Of Propertiy Section


        //Mutlilanguage section
        $request_para = "recipe_name_";
        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
        $data['recipe_name_multi_language'] = $multi_language_names;
        //End Of Multilanguage Section

        //Mutlilanguage section
        $request_para = "description_";
        $multi_language_description = get_mutli_language_json_input($request->all(), $request_para);
        $data['recipe_description_multi_language'] = $multi_language_description;
        //End Of Multilanguage Section


        //Image Uploading Section
        if ($image = $request->file('image')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['recipe_image'] = $image;
            $data['image_url'] = env('APP_URL').'/'.$desination_path.$image;
        }
        //End Of Image Uploading Section
        //Sub Image  1
        if ($image = $request->file('sub_image_1')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['recipe_sub_image_1'] = $image;
        }
        //End Sub Image 1
        //Sub Image  2
        if ($image = $request->file('sub_image_2')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['recipe_sub_image_2'] = $image;
        }
        //End Sub Image 2
        //Sub Image  3
        if ($image = $request->file('sub_image_3')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['recipe_sub_image_3'] = $image;
        }
        //End Sub Image 3
        //Sub Image  4
        if ($image = $request->file('sub_image_4')) {
            $original_file_destination = 'uploads/recipe_org_images/';
            $desination_path = 'uploads/recipe_images/';
            $image_resolution = env('RECIPE_IMAGE_SIZE');
            $image = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['recipe_sub_image_4'] = $image;
        }
        //End Sub Image 4

        //Recipe Video Section
        if ($image = $request->file('video')) {
            $imageDestinationPath = 'uploads/recipe_videos';
            $postImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($imageDestinationPath, $postImage);
            $data['recipe_video'] = "$postImage";
        }
        //End of Recipe Video Section

        //Stock and Stock Reminder
        $data['recipe_stock_reminder'] = $request->stock_reminder;
        $data['recipe_stock'] = $request->stock;


        $update = recipeModel::where('recipe_id', $id)->update($data);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Recipe ' . $request->recipe_name_1 . ' Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Recipe updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function view_recipe(Request $request)
    {
        $id = $request->id;
        $data['recipe'] = recipeModel::with('recipe_varient')->where('recipe_status', 0)
            ->leftjoin('tbl_category', 'tbl_recipe.recipe_category_id', 'tbl_category.category_id')
            ->leftjoin('tbl_subcategory', 'tbl_recipe.recipe_subcategory_id', 'tbl_subcategory.subcategory_id')
            ->leftjoin('users', 'tbl_recipe.created_by', 'users.id')
            ->select('tbl_recipe.*', 'tbl_category.category_name', 'users.name', 'tbl_subcategory.*')
            ->where('recipe_id', $id)
            ->first();
        // recipe_varient
        #######################Multiple Language Recipe Name ######################
        $recipe_name_multi_language = json_decode($data['recipe']->recipe_name_multi_language, true);
        $available_languages = get_available_language();
        $multi_recipe_name_array = array();
        foreach ($recipe_name_multi_language as $key => $language_value) {
            foreach ($available_languages as $available_language) {
                if ($available_language['language_id'] == $key) {

                    $languag_data = [
                        'language_value' => $language_value,
                        'language_label' => 'Recipe Name ' . $available_language['language_short_code'],
                        'language_id' => $available_language['language_id'],
                        'language_name' => $available_language['language_name'],
                        'language_short_code' => $available_language['language_short_code'],
                        'language_permalink' => $available_language['language_permalink'],

                    ];
                    array_push($multi_recipe_name_array, $languag_data);
                    $data['multi_recipe_name_array'] = $multi_recipe_name_array;
                }
            }
        }
        #######################End Of Multiple Language Recipe Name ######################

        #######################Multiple Language Description  ######################
        $recipe_description_multi_language = json_decode($data['recipe']->recipe_description_multi_language, true);
        $available_languages = get_available_language();
        $multi_recipe_description_array = array();
        foreach ($recipe_description_multi_language as $key => $language_value) {
            foreach ($available_languages as $available_language) {
                if ($available_language['language_id'] == $key) {

                    $languag_data = [
                        'language_value' => $language_value,
                        'language_label' => 'Recipe Description ' . $available_language['language_short_code'],
                        'language_id' => $available_language['language_id'],
                        'language_name' => $available_language['language_name'],
                        'language_short_code' => $available_language['language_short_code'],
                        'language_permalink' => $available_language['language_permalink'],

                    ];
                    array_push($multi_recipe_description_array, $languag_data);
                    $data['multi_recipe_description_array'] = $multi_recipe_description_array;
                }
            }
        }
        #######################End Of Multiple Language Description ######################
        #########################Recipe Add On Section ################################
        $add_on_ids = $data['recipe']->recipe_add_ons;
        $add_on_ids = json_decode($add_on_ids, 'true');
        $data['add_ons'] = array();
        if (empty($add_on_ids)) {
            $data['add_ons'] = array();
        } else {
            $data['add_ons'] = recipe_add_on_Model::whereIN('add_on_id', $add_on_ids)->get();
        }
        #######################End Of Recipe Add O Section #####################

        return view('admin.recipe.modal')->with($data);
    }

    public function change_status(Request $request)
    {
        $recipe_id = $request->recipe_id;
        $status = $request->status;
        $details = recipeModel::where('recipe_id', $recipe_id)->first();
        $update = recipeModel::where('recipe_id', $recipe_id)->update(['recipe_active_status' => $status]);
        $activated_status = "Activated";
        if ($status == 0) {
            $activated_status = "Inactivated";
        }
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Recipe ' . $details->recipe_name . ' Has Been ' . $activated_status . ' By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Recipe ' . $activated_status . ' successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function change_recommended_status(Request $request)
    {

        $recipe_id = $request->recipe_id;
        $recommended_status_id = $request->check_status;
        //Check Current Recommended Count
        $recommended_count = $recipe = recipeModel::where('recipe_status', 0)
            ->where('recipe_active_status', 1)
            ->where('recipe_recommended_status', 1)
            ->count();
        if ($recommended_count > 8) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Recommend Food Limit Reached.']);
        }

        //Update Recipe_recommended_status
        $details = recipeModel::where('recipe_id', $recipe_id)->first();
        $update = recipeModel::where('recipe_id', $recipe_id)->update(['recipe_recommended_status' => $recommended_status_id]);
        $recommended_status = "Activated";
        if ($recommended_status_id == 0) {
            $recommended_status = "Inactivated";
        }
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Recipe ' . $details->recipe_name . ' Has Been Recommented Status ' . $recommended_status . ' By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Recipe Recomment Status ' . $recommended_status . ' successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }


    }

    public function category_wise_filter(Request $request)
    {
        $category_id = $request->category_id;
        Session::put('admin_category_filter', $category_id);
    }

    public function recipe_type_filter(Request $request)
    {
        $recipe_type = $request->recipe_type;
        Session::put('admin_recipe_type_filter', $recipe_type);

    }

    public function most_recommended_filter(Request $request)
    {

        if ($request->status == "true") {
            Session::put('admin_recipe_most_recommended', 'most_recommended');
        } else {
            $session_array = array('admin_recipe_most_recommended');
            reset_session($session_array);
        }
    }

    public function reset_recipe_filter(Request $request)
    {
        $session_array = array('admin_category_filter', 'admin_recipe_type_filter', 'admin_recipe_most_recommended');
        reset_session($session_array);
    }

    public function update_recipe_varinet($recipe_id, $varient_names, $varinet_prices, $default_recipe)
    {
        //Delete Existing Varient from_db
        $delete = recipevarientModel::where('recipe_id', $recipe_id)->update(['varient_status' => 1]);
        $i = 0;
        $j = 1;
        $default_recipe_status = false;
        foreach ($varient_names as $key => $varient_name) {

            if (isset($varinet_prices[$key])) {
                $varinet_price = $varinet_prices[$key];
            } else {
                $varinet_price = 0;
            }

            if ($varient_name != "" && $varinet_price > 0) {

                if ($default_recipe == $j) {
                    $default_recipe_status = true;
                    $varient_default = 1;
                } else {
                    $varient_default = 0;
                }

                // $varient_default=0;
                // if($i==0){ $varient_default=1; }
                $varinet = new recipevarientModel();
                $varinet->varient_status = 0;
                $varinet->default_status = $varient_default;
                $varinet->recipe_id = $recipe_id;
                $varinet->varient_name = $varient_name;
                $varinet->varient_price = $varinet_price;
                $varinet->save();
                $i++;
                $j++;
            }

        }
        if ($default_recipe_status == false && count($varient_names) > 0) {
            $update = recipevarientModel::where('recipe_id', $recipe_id)->orderBy('varient_id', 'ASC')->limit(1)->update(['default_status' => 1]);
        }
        return;

    }

}
