<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\customerModel;
use App\Models\recipeModel;
use App\Models\promotionModel;
use Illuminate\Support\Facades\Validator;
use Auth;
class promotionController extends Controller
{
   public function index(){
       $customers=customerModel::where('customer_status',0)->get();
       $recipes=recipeModel::where('recipe_status',0)->get();
       return view('admin.promotion.index')->with(['customers'=>$customers,'recipes'=>$recipes]);
   }
   public function add_promotion(Request $request){
    $validator = Validator::make($request->all(), [
         'promotion_name'=>'required',
         'promotion_desc'=>'required',
         'discount_type'=>'required|numeric',
         'amount_discount'=>'required|numeric',
         'from_date'=>'required',
         'to_date'=>'required',
         'promotion_customers'=>'required',
         'promotion_recipes'=>'required',
     ]);
     
     if ($validator->fails()) { 
         foreach (array_values($validator->messages()->toArray()) as $msg) {
             $error = implode(' ', $msg).'<br>';
         }
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
     }  
     $promotions=new promotionModel();
     $promotions->promotion_status=0;
     $promotions->promotion_name=$request->promotion_name;
     $promotions->promotion_desc=$request->promotion_desc;
     $promotions->promotion_discount_type=$request->discount_type;
     $promotions->promotion_discount=$request->amount_discount;
     $promotions->from_date=$request->from_date;
     $promotions->to_date=$request->to_date;
     $promotions->promotion_customers=implode(',', $request->promotion_customers);
     $promotions->promotion_recipies=implode(',', $request->promotion_recipes);
     $promotions->promotion_active_status=0;
     $promotions->created_by=Auth::user()->id;
     $promotions->updated_by=Auth::user()->id;
     $promotions->save();
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Promotion '.$request->promotion_name.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
     return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Promotion Added Succesfully']);
   }

   public function promotion_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 5;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $promotion_data=promotionModel::where('promotion_status',0)
        ->Where(function($query) use ($search) {
            $query->where('promotion_name', 'like', $search . '%');
        });
        $promotion_data->orderby('promotion_id','DESC');
        $data = ["iTotalDisplayRecords" => $promotion_data->count(), "iTotalRecords" => $promotion_data->count(), "TotalDisplayRecords" => $limit];
        $data['data'] = $promotion_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
   }
   public function change_promotion_status(Request $request){
      $promotion_id=$request->id;
      $status=$request->status;
      $data=['promotion_active_status'=>$status];
      $update_status=promotionModel::where('promotion_id',$promotion_id)->update($data);
      $details=promotionModel::where('promotion_id',$promotion_id)->first();
      if($update_status==1){
            ############################User Activity log#########################
                $user_activity_log['activity_ip']=$request->ip(); 
                $user_activity_log['activity_user_name']=Auth::user()->name;
                $user_activity_log['activity_user_id']=Auth::user()->id; 
                $user_activity_log['activity_action']="Updated";
                $active_status="Activate";
                if($status==1){$active_status="Inactivate";}
                $user_activity_log['activity_desc']='Promotion '.$details->promotion_name.' Has Been '.$active_status.' By '.Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
          return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Status changed successfully']);
      }
      else{
          return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
      }
   }
   public function edit_promotion(Request $request){
      $promotion_id=$request->id;
      $promotion_data=promotionModel::select('*')->where('promotion_id',$promotion_id)->first();
      return response()->json(['status' => '0', 'msg' => 'succes','data'=>$promotion_data]);
   }
   public function update_promotion(Request $request){
      $validator = Validator::make($request->all(), [
         'promotion_name'=>'required',
         'promotion_desc'=>'required',
         'discount_type'=>'required|numeric',
         'amount_discount'=>'required|numeric',
         'from_date'=>'required',
         'to_date'=>'required',
         'promotion_customers'=>'required',
         'promotion_recipes'=>'required',
     ]);
     
     if ($validator->fails()) { 
         foreach (array_values($validator->messages()->toArray()) as $msg) {
             $error = implode(' ', $msg).'<br>';
         }
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
     } 
     $data=['promotion_name'=>$request->promotion_name,
            'promotion_desc'=>$request->promotion_desc,
            'promotion_discount_type'=>$request->discount_type,
            'promotion_discount'=>$request->amount_discount,
            'from_date'=>$request->from_date,
            'to_date'=>$request->to_date,
            'promotion_customers'=>implode(',', $request->promotion_customers),
            'promotion_recipies'=>implode(',', $request->promotion_recipes),
            'updated_by'=>Auth::user()->id,
    ];
       $update=promotionModel::where('promotion_id',$request->promotion_id)->update($data); 
        if($update==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Promotion '.$request->promotion_name.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Promotion updated successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
   }
   public function delete_promotion(Request $request){
      $id=$request->id;
      $delete=promotionModel::where('promotion_id',$id)->update(['promotion_status'=>1]);
      $details=promotionModel::where('promotion_id',$id)->first();
      if($delete==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Promotion '.$details->promotion_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
          return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Promocode removed successfully']);
      }
      else{
          return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
      }
   }
}