<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\promocodeModel;
use Illuminate\Support\Facades\Validator;
use Auth;

class promocodeController extends Controller
{
   public function index(){
    $promocodes=promocodeModel::where('promocode_status',0)->orderby('promocode_id','DESC')->get();
    return view('admin.promocode.index')->with('data',$promocodes);
   }
   public function add_promocode(Request $request){
      $validator = Validator::make($request->all(), [
         'promocode_name'=>'required',
         'short_code'=>'required',
         'offer_type'=>'required|numeric',
         'amount_discount'=>'required|numeric',
         'min_purchase_amt'=>'required|numeric',
         'from_date'=>'required',
         'to_date'=>'required',
         'maximum_usage'=>'required|numeric',
     ]);
     
     if ($validator->fails()) { 
         foreach (array_values($validator->messages()->toArray()) as $msg) {
             $error = implode(' ', $msg).'<br>';
         }
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
     }
     $promocode=new promocodeModel();
     $promocode->promocode_name=$request->promocode_name;
     $promocode->promocode_short_code=$request->short_code;
     $promocode->promocode_offer_type=$request->offer_type;
     $promocode->promocode_amount_or_discount=$request->amount_discount;
     $promocode->promocode_min_purchase_amt=$request->min_purchase_amt;
     $promocode->promocode_from_date=$request->from_date;
     $promocode->promocode_to_date=$request->to_date;
     $promocode->promocode_maximum_usage_per_customer=$request->maximum_usage_per_customer;
     $promocode->promocode_maximum_usage=$request->maximum_usage;
     $promocode->created_by=Auth::user()->id;
     $promocode->updated_by=Auth::user()->id;
     $promocode->save();
      ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Promocode '.$request->promocode_name.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
     return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Promocode Added Succesfully']);
   }
   public function change_promocode_status(Request $request){
      $promocode_id=$request->promocode_id;
      $status=$request->status;
      $data=['promocode_active_status'=>$status];
      $update_status=promocodeModel::where('promocode_id',$promocode_id)->update($data);
      $details=promocodeModel::where('promocode_id',$promocode_id)->first();
      if($update_status==1){
           ############################User Activity log#########################
                $user_activity_log['activity_ip']=$request->ip(); 
                $user_activity_log['activity_user_name']=Auth::user()->name;
                $user_activity_log['activity_user_id']=Auth::user()->id; 
                $user_activity_log['activity_action']="Updated";
                $active_status="Activate";
                if($status==1){$active_status="Inactivate";}
                $user_activity_log['activity_desc']='Promocode '.$details->promocode_name.' Has Been '.$active_status.' By '.Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
          return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Status changed successfully']);
      }
      else{
          return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
      }
   }
   public function edit_promocode(Request $request){
      $promocode_id=$request->id;
      $promocode_data=promocodeModel::select('*')->where('promocode_id',$promocode_id)->first();
      return response()->json(['status' => '0', 'msg' => 'succes','data'=>$promocode_data]);
   }
   public function update_promocode(Request $request){
      $validator = Validator::make($request->all(), [
         'promocode_name'=>'required',
         'short_code'=>'required',
         'offer_type'=>'required|numeric',
         'amount_discount'=>'required|numeric',
         'min_purchase_amt'=>'required|numeric',
         'from_date'=>'required',
         'to_date'=>'required',
         'maximum_usage'=>'required|numeric',
     ]);
     
     if ($validator->fails()) { 
         foreach (array_values($validator->messages()->toArray()) as $msg) {
             $error = implode(' ', $msg).'<br>';
         }
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
     }
     $data=[
        'promocode_name'=>$request->promocode_name,
        'promocode_short_code'=>$request->short_code,
        'promocode_offer_type'=>$request->offer_type,
        'promocode_amount_or_discount'=>$request->amount_discount,
        'promocode_min_purchase_amt'=>$request->min_purchase_amt,
        'promocode_from_date'=>$request->from_date,
        'promocode_to_date'=>$request->to_date,
        'promocode_maximum_usage_per_customer'=>$request->maximum_usage_per_customer,
        'promocode_maximum_usage'=>$request->maximum_usage,
        'updated_by'=>auth::user()->id,
     ];
     $update=promocodeModel::where('promocode_id',$request->promocode_id)->update($data); 
        if($update==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Promocode '.$request->promocode_name.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Promocode updated successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
   }
   public function delete_promocode(Request $request){
      $id=$request->id;
      $delete=promocodeModel::where('promocode_id',$id)->update(['promocode_status'=>1]);
      $details=promocodeModel::where('promocode_id',$id)->first();
      if($delete==1){
           ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Promocode '.$details->promocode_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
          return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Promocode removed successfully']);
      }
      else{
          return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
      }
   }
   public function promocode_datatable(Request $request){
    $limit = ($request->length != '') ? $request->length : 5;
    $offset = ($request->start != '') ? $request->start : 0;
    $search = $request->search['value'];
    $promocodes=promocodeModel::where('promocode_status',0)->orderby('promocode_id','DESC')
    ->Where(function($query) use ($search) {
        $query->where('promocode_name', 'like', $search . '%');
        $query->orwhere('promocode_short_code', 'like', $search . '%');
    });
    $data = ["iTotalDisplayRecords" => $promocodes->count(), "iTotalRecords" => $promocodes->count(), "TotalDisplayRecords" => $limit];
    $data['data'] = $promocodes->skip($offset)->take($limit)->get()->toArray();
    return response()->json($data);
   }


}