<?php

namespace App\Http\Controllers;

use App\Models\ApiCartModel;
use App\Models\recipeModel;
use App\Models\customerModel;
use App\Models\categoryModel;
use App\Models\recipe_add_on_Model;
use App\Models\promocodeModel;
use App\Models\orderModel;
use App\Models\inventoryModel;
use App\Models\inventoryitemModel;
use Illuminate\Http\Request;
use App\Traits\websiteTrait;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use App\Models\tableModel;
use DB;
use Auth;

class posController extends Controller
{
    use websiteTrait;


    public function pos()
    {
        $order_id = session('order_id');
        $data['order_details'] = $data['order_item_array'] = "";
        $order_item_array = array();
        //If Invoicing From An Order
        if ($order_id) {
            $order_details = orderModel::where('order_id', $order_id)->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'table', 'promocode')->first();
            $order_items = $order_details->order_items;
            $i = 0;

            $data['order_details'] = $order_details;

            foreach ($order_items as $order_item) {
                $order_item_add_on = $order_item->order_item_add_on;
                $order_item_varient = $order_item->order_item_varient;

                //recipe_detais

                $recipe_details = recipeModel::where('recipe_id', $order_item['recipe_id'])->first();
                if ($recipe_details) {
                    $item_org_price = $recipe_details->recipe_price;
                    $item_stock = $recipe_details->recipe_stock;
                } else {
                    $item_org_price = $order_item['order_item_price'];
                    $item_stock = 0;
                }

                if (count($order_item_varient) > 0) {
                    foreach ($order_item_varient as $varient) {

                        $order_item_array[$i] = [
                            'item_id' => $order_item['recipe_id'],
                            'item_varient_id' => $varient['varient_id'],
                            'item_name' => $order_item['order_item_name'] . ' ' . $varient['order_item_varient_name'],
                            'item_org_price' => $varient['order_item_varient_price'],
                            'item_price' => $varient['order_item_varient_price'],
                            'item_quantity' => $varient['order_item_varient_quantity'],
                            'item_stock' => $item_stock,
                            'item_type' => 'recipe'
                        ];
                        $i++;
                    }

                } else {


                    $order_item_array[$i] = [
                        'item_id' => $order_item['recipe_id'],
                        'item_varient_id' => 0,
                        'item_name' => $order_item['order_item_name'],
                        'item_org_price' => $item_org_price,
                        'item_price' => $order_item['order_item_price'],
                        'item_quantity' => $order_item['order_item_quantity'],
                        'item_stock' => $item_stock,
                        'item_type' => 'recipe'
                    ];
                    $i++;

                }

                if (count($order_item_add_on) > 0) {
                    foreach ($order_item_add_on as $addon) {


                        $order_item_array[$i] = [
                            'item_id' => $addon['add_on_id'],
                            'item_varient_id' => -1,
                            'item_name' => $addon['order_item_add_on_name'],
                            'item_org_price' => $addon['order_item_add_on_price'],
                            'item_price' => $addon['order_item_add_on_price'],
                            'item_quantity' => $addon['order_item_add_on_quantity'],
                            'item_stock' => 100,
                            'item_type' => 'add_on'
                        ];
                        $i++;
                    }
                }

            }


        }
        $data['order_item_array'] = $order_item_array;

        //End Of Invoicing From An Order

        $data['categories'] = categoryModel::select('category_id', 'category_name', 'category_icon')->orderBy('priority', 'Asc')->get();

        $data['add_ons'] = recipe_add_on_model::where('add_on_active_status', 0)->count();

        $data['recent_invoice'] = inventoryModel::select('invoice_id', 'inventory_unique_id')->orderBy('invoice_id', 'Desc')->limit(4)->get();


        return view('admin.pos.index', compact('data'));
    }

    public function pos_categories()
    {

        $categories = categoryModel::select('category_id', 'category_name', 'category_icon')->orderBy('priority', 'Asc')->get()->toArray();

        $add_ons = recipe_add_on_model::where('add_on_active_status', 0)->count();

        $items_details = array();
        $i = 0;
        foreach ($categories as $category) {

            $items_details[$i] = [
                'item_id' => $category['category_id'],
                'item_name' => $category['category_name'],
                'item_img' => url('/uploads/category_images/') . '/' . $category['category_icon'],
                'item_type' => 'recipe',

            ];


            $i++;
        }

        if ($add_ons > 0) {

            $items_details[$i] = [
                'item_id' => 0,
                'item_name' => "Add ons",
                'item_img' => url('/uploads/category_images/') . '/' . $category['category_icon'],
                'item_type' => 'add_on',

            ];

        }

        $data['items_details'] = $items_details;


        return response()->json($data);

    }

    public function category_wise_item(Request $request)
    {

        $id = $request->id;
        $type = $request->type;

        if ($type == "recipe") {

            $category_details = categoryModel::where('category_id', $id)->first(); //Category Details
            if ($category_details) {
                $data['parent_name'] = $category_details->category_name;

            }

            $fetch_items = recipeModel::with('recipe_varient', 'category', 'subcategory')->where('recipe_status', 0)
                ->select('tbl_recipe.*')
                ->where('recipe_category_id', $id)
                ->where('recipe_stock', '>', 0)
                ->where('recipe_active_status', 1)
                ->get();

            $items_details = array();
            $i = 0;
            foreach ($fetch_items as $fetch_item) {

                $varient_array = array();

                if (isset($fetch_item['recipe_varient'])) {
                    $varient_array = $fetch_item['recipe_varient'];
                }


                $recipe_price = $fetch_item['recipe_price'];
                if ($fetch_item['recipe_price'] > $fetch_item['recipe_offer_price']) {
                    $recipe_price = $fetch_item['recipe_offer_price'];
                }


                $items_details[$i] = [
                    'item_id' => $fetch_item['recipe_id'],
                    'item_varient_id' => 0,
                    'item_category_id' => $fetch_item['recipe_category_id'],
                    'item_name' => $fetch_item['recipe_name'],
                    'item_org_price' => $fetch_item['recipe_price'],
                    'item_price' => $recipe_price,
                    'item_img' => url('/uploads/recipe_images/' . $fetch_item['recipe_image']),
                    'item_stock' => $fetch_item['recipe_stock'],
                    'item_type' => 'recipe',
                    'varient_array' => $varient_array,
                ];
                $i++;
            }
        } else if ($type = "add_on") {

            $data['parent_name'] = "Add ons";

            $add_on_data = recipe_add_on_model::where('add_on_active_status', 0)->get();
            $i = 0;
            foreach ($add_on_data as $add_on) {
                $items_details[$i] = [
                    'item_id' => $add_on['add_on_id'],
                    'item_category_id' => 0,
                    'item_name' => $add_on['add_on_name'],
                    'item_org_price' => $add_on['add_on_price'],
                    'item_price' => $add_on['add_on_price'],
                    'item_img' => url('/uploads/add_on_images/' . $add_on['add_on_image']),
                    'item_stock' => 100,
                    'item_type' => 'add_on',
                    'varient_array' => array()
                ];
                $i++;

            }


        }

        $data['items_details'] = $items_details;

        return response()->json($data);

    }

    public function search_term(Request $request)
    {

        $search_term = $request->search_term;

        $data['parent_name'] = "Search";
        //serach recipes
        $fetch_items = recipeModel::with('recipe_varient', 'category', 'subcategory')->where('recipe_status', 0)
            ->select('tbl_recipe.*')
            ->where('recipe_stock', '>', 0)
            ->where('recipe_active_status', 1)
            ->where('recipe_name_multi_language', 'LIKE', '%' . $search_term . '%')
            ->get();


        $i = 0;
        $items_details = array();
        foreach ($fetch_items as $fetch_item) {

            $varient_array = array();

            if (isset($fetch_item['recipe_varient'])) {
                $varient_array = $fetch_item['recipe_varient'];
            }


            $recipe_price = $fetch_item['recipe_price'];
            if ($fetch_item['recipe_price'] > $fetch_item['recipe_offer_price']) {
                $recipe_price = $fetch_item['recipe_offer_price'];
            }


            $items_details[$i] = [
                'item_id' => $fetch_item['recipe_id'],
                'item_varient_id' => 0,
                'item_category_id' => $fetch_item['recipe_category_id'],
                'item_name' => $fetch_item['recipe_name'],
                'item_org_price' => $fetch_item['recipe_price'],
                'item_price' => $recipe_price,
                'item_img' => url('/uploads/recipe_images/' . $fetch_item['recipe_image']),
                'item_stock' => $fetch_item['recipe_stock'],
                'item_type' => 'recipe',
                'varient_array' => $varient_array
            ];
            $i++;
        }

        //search_add_ons

        $add_on_data = recipe_add_on_model::where('add_on_active_status', 0)
            ->where('add_on_multi_name', 'LIKE', '%' . $search_term . '%')
            ->get();

        foreach ($add_on_data as $add_on) {

            $items_details[$i] = [
                'item_id' => $add_on['add_on_id'],
                'item_category_id' => 0,
                'item_name' => $add_on['add_on_name'],
                'item_org_price' => $add_on['add_on_price'],
                'item_price' => $add_on['add_on_price'],
                'item_img' => url('/uploads/add_on_images/' . $add_on['add_on_image']),
                'item_stock' => 100,
                'item_type' => 'add_on',
                'varient_array' => array()
            ];
            $i++;

        }

        $data['items_details'] = $items_details;

        return response()->json($data);
    }


    public function add_customer_via_pos(Request $request)
    {

        $mobile_number_length = session('layout_data')['mobile_max_length'];

        $validation_array = [
            'customer_mobile' => 'required|numeric|digits:' . $mobile_number_length,
            'customer_name' => 'required',
        ];
        if ($request->customer_email) {
            $validation_array['customer_email'] = 'email';
        }

        $validator = Validator::make($request->all(), $validation_array);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        $check_exist = customerModel::where('customer_status', 0)->where('customer_mob', $request->customer_mobile)->first();
        if ($check_exist) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'The Mobile Number ' . $request->mobile_number . ' already Registered']);
        }

        try {
            DB::beginTransaction();

            $customer = new customerModel();
            $customer->customer_ip = $request->ip();
            $customer->customer_name = $request->customer_name;
            $customer->customer_mob = $request->customer_mobile;
            $customer->customer_unique_id = $this->get_customer_sku();
            $customer->customer_mail_id = $request->customer_email;
            $customer->customer_q_id = "";
            $customer->company_name = "";
            $customer->customer_address = "";
            $customer->save();
            $customer_id = $customer->id;

            DB::commit();
            $customer_name_with_mob = $customer->customer_name . ' - ' . $customer->customer_mob;
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Customer Added', 'customer_id' => $customer_id, 'customer_name_with_mob' => $customer_name_with_mob]);

        } catch (QueryException $e) {
            DB::rollBack();
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Weny Wronf']);
        }

    }


    public function recipe_wise_varient(Request $request)
    {

        $recipe_id = $request->id;

        $items_details = array();

        $recipe_name = "";

        $fetch_item = recipeModel::with('recipe_varient', 'category', 'subcategory')->where('recipe_status', 0)
            ->select('tbl_recipe.*')
            ->where('recipe_id', $recipe_id)
            ->where('recipe_stock', '>', 0)
            ->where('recipe_active_status', 1)
            ->first();

        if ($fetch_item) {
            $recipe_id = $fetch_item->recipe_id;
            $recipe_name = $fetch_item->recipe_name;
            $recipe_image = $fetch_item->recipe_image;

            if (!empty($fetch_item->recipe_varient)) {

                $varients = $fetch_item->recipe_varient;
                $i = 0;
                foreach ($varients as $varient) {

                    $varient_id = $varient['varient_id'];
                    $varient_name = $varient['varient_name'];
                    $varient_price = $varient['varient_price'];

                    $items_details[$i] = [
                        'item_id' => $recipe_id,
                        'item_varient_id' => $varient_id,
                        'item_name' => $recipe_name . ' ' . $varient_name,
                        'item_org_price' => $varient_price,
                        'item_price' => $varient_price,
                        'item_img' => url('/uploads/recipe_images/' . $fetch_item['recipe_image']),
                        'item_stock' => $fetch_item['recipe_stock'],
                        'item_type' => 'recipe',
                    ];
                    $i++;

                }
            }
        }
        $data['parent_name'] = $recipe_name;
        $data['items_details'] = $items_details;
        return response()->json($data);


    }

    public function customer_autocomplete(Request $request)
    {

        $search_term = $request->search_term;

        $get_customer = customerModel::select('customer_id', 'customer_name', 'customer_mob')->Where(function ($query) use ($search_term) {
            $query->where('customer_name', 'like', '%' . $search_term . '%');
            $query->Orwhere('customer_mob', 'like', $search_term . '%');
        });
        $get_customer = $get_customer->get();

        return response()->json($get_customer);

    }

    public function offer_code_fetching(Request $request)
    {
        $offer_val = $request->offer_val;
        $sub_total = $request->sub_total;
        $promocode_result = $this->get_promocode_response($offer_val, $sub_total);
        return response()->json($promocode_result);
    }

    public function get_promocode_response($promocode, $total_amount)
    {
        $grand_total = $total_amount;
        $currency = session('layout_data')['currency'];
        //check promocode exist
        $fetch_promocode_details = promocodeModel::where('promocode_short_code', $promocode)->where('promocode_active_status', 0)->first();
        if ($fetch_promocode_details) {
            $today_date = date('Y-m-d');
            $promocode_id = $fetch_promocode_details->promocode_id;
            $promocode_from_date = $fetch_promocode_details->promocode_from_date;
            $promocode_to_date = $fetch_promocode_details->promocode_to_date;
            $promocode_usage_count = $fetch_promocode_details->promocode_usage_count;
            $promocode_maximum_usage = $fetch_promocode_details->promocode_maximum_usage;
            $promocode_min_purchase_amt = $fetch_promocode_details->promocode_min_purchase_amt;
            $promocode_offer_type = $fetch_promocode_details->promocode_offer_type;
            $promocode_amount_or_discount = $fetch_promocode_details->promocode_amount_or_discount;

            if ($today_date >= $promocode_from_date && $today_date <= $promocode_to_date) {


                if ($promocode_usage_count < $promocode_maximum_usage) {


                    if ($total_amount >= $promocode_min_purchase_amt) {

                        if ($promocode_offer_type == 0) {  //Amount Offer Section

                            $promocode_amount = $promocode_amount_or_discount;

                            $grand_total = $total_amount - $promocode_amount;

                            $data = ['status' => 0, 'heading' => 'Success', 'msg' => 'Promocode Applied', 'sub_total' => $total_amount, 'promocode_id' => $promocode_id, 'promocode_amount' => $promocode_amount, 'grand_total' => $grand_total];


                        } else if ($promocode_offer_type == 1) {  //Percentage Offer Section

                            $discount = $promocode_amount_or_discount;

                            $promocode_amount = ($total_amount * $discount) / 100;
                            $grand_total = $total_amount - $promocode_amount;

                            $data = ['status' => 0, 'heading' => 'Success', 'msg' => 'Promocode Applied', 'sub_total' => $total_amount, 'promocode_id' => $promocode_id, 'promocode_amount' => $promocode_amount, 'grand_total' => $grand_total];


                        }


                    } else {

                        $data = ['status' => 1, 'heading' => 'Error', 'msg' => 'To Apply Promocode Need Minimum ' . $promocode_min_purchase_amt . ' ' . $currency . ' Required', 'grand_total' => $grand_total];

                    }


                } else {

                    $data = ['status' => 1, 'heading' => 'Error', 'msg' => 'Promocode Expired', 'grand_total' => $grand_total];

                }

            } else {

                $data = ['status' => 1, 'heading' => 'Error', 'msg' => 'Promocode Expired', 'grand_total' => $grand_total];

            }

        } else {
            $data = ['status' => 1, 'heading' => 'Error', 'msg' => 'Promocode doesnt Exist ', 'grand_total' => $grand_total];
        }

        return $data;

    }

    public function create_invoice(Request $request)
    {
//dd($request->all());
        try {
            // dd($request->all());

            DB::beginTransaction();

            $order_id = $request->order_id;
            $customer_id = $request->customer_id;
            $sub_total = $request->sub_total;
            $offer_code = $request->offer_code;
            $offer_code_amount = $request->offer_code_amount;
            $discount_percentage = $request->discount_percentage;
            $discount_amount = $request->discount_amount;
            $payment_type = $request->payment_type;
            $grand_amount = $request->grand_amount;

            $exist = inventoryModel::where('invoice_order_id', $order_id)->first();
            if(!$exist) {
                //if Items Not Exist
                if ($request->item_id == "") {
                    return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Atlease one item required']);
                }
                //End Of Item Not Exist

                //Check Invoice Promocode Exist
                if ($request->offer_code_id) {
                    if ($order_id == "") {

                        $response = check_promocode_status($request->offer_code_id, $customer_id);

                        if ($response['status'] == 1) { //Any Error Occures
                            return response()->json($response);
                        }

                    }
                }
                //End Of Check Invoice Promoceode Exist

                //Item Details
                $item_name_array = $request->item_name;
                $quantity_array = $request->quantity;
                $item_id_array = $request->item_id;
                $item_varient_id_array = $request->item_varient_id;
                $item_price_array = $request->item_price;
                $item_total_price_array = $request->item_total_price;
                $item_org_price_array = $request->item_org_price;
                $item_org_total_price_array = $request->item_org_total_price;
                $item_stock_array = $request->item_stock;
                $item_type_array = $request->item_type;
                $order_item_quantity_array = $request->order_item_quantity;

                //End Of Item Details


                //Fetch Order Details
                $order_unique_id = "";
                if ($order_id) {
                    $order_details = orderModel::where('order_id', $order_id)->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'table', 'promocode')->first();
                    $order_unique_id = $order_details->order_unique_id;
                    //Set To Order Status Invoiced
                    //$update_prder_status = orderModel::where('order_id', $order_id)->update(['order_tracking_status' => 'Invoiced']);
                    //Set The Table To Available
                    $table_id = $order_details->order_table_id;
                    $update_table = tableModel::where('table_id', $table_id)->update(['table_tracking_status' => 'Available']);

                } else {
                    $order_id = 0;
                }

                //fetch Customer_Details
                $customer_name = $customer_mob = "";
                if ($customer_id) {
                    $customer_details = customerModel::where('customer_id', $customer_id)->first();
                    if ($request->customer_and_mobile) {
                        $customer_array = explode('--', $request->customer_and_mobile);
                        if (!empty($customer_array)) {
                            $customer_name = trim($customer_array[0]);
                        } else {
                            $customer_name = "Guest";
                        }
                    } else {
                        $customer_name = $customer_details->customer_name;
                    }
                    $customer_mob = $customer_details->customer_mob;
                }

                $inv_discount_amount = 0;
                if ($offer_code) {
                    $inv_discount_amount = $offer_code_amount;
                } else if ($discount_amount > 0) {
                    $inv_discount_amount = $discount_amount;
                } else if ($discount_percentage > 0) {
                    $inv_discount_amount = $request->discount_percentage_amount;
                }

                //Discount Percentage Calculation
                $discount_percentage = number_format(($inv_discount_amount / $sub_total) * 100, 2);
                //End Of Discount Percentage Calculatio

                $order2 = orderModel::where('order_unique_id', $order_unique_id)->first();
                $cart_data = ApiCartModel::where('id', $order2->order_cart_customer_id)->first();
                //Inventory Table
                $inventory = new inventoryModel();
                $inventory->invoice_ip = $request->ip();
                $inventory->invoice_status = 0;
                $inventory->invoice_order_id = $order_id;
                $inventory->invoice_orders_unique_id = $order_unique_id;
                $inventory->invoice_date = date('Y-m-d');
                $inventory->invoice_time = date('H:i');
                $inventory->inventory_unique_id = $this->inventoryuniqueIdGenerator();
                $inventory->invoice_payment_type = $payment_type;
                $inventory->invoice_customer_id = $customer_id;
                $inventory->invoice_customer_name = $customer_name;
                $inventory->invoice_contact_number = $customer_mob;
                $inventory->invoice_sub_total = $sub_total;
                $inventory->invoice_discount_amount = $inv_discount_amount;
                $inventory->invoice_shipping_charge = 0;
                $inventory->invoice_grand_total = $grand_amount;
                $inventory->invoice_cost = 0;
                $inventory->invoice_profit = 0;
                $inventory->delivery_type = $cart_data->delivery_type ?: 0;
                $inventory->branch_id = $cart_data->branch_id ?: NULL;
                $inventory->invoice_added_by = Auth::user()->id;
                $inventory->invoice_promocode_id = $request->offer_code_id;
                $inventory->save();
                $inventory_id = $inventory->id;

                //End Of Inventory Table

                //Inventory Item Table


                for ($i = 0; $i < count($item_id_array); $i++) {


                    $item_id = $item_id_array[$i];
                    $item_name = $item_name_array[$i];
                    $item_quantity = $quantity_array[$i];
                    $item_varient_id = $item_varient_id_array[$i];
                    $item_price = $item_price_array[$i];
                    $item_total_price = $item_total_price_array[$i];
                    $item_org_price = $item_org_price_array[$i];
                    $item_org_total_price = $item_org_total_price_array[$i];
                    $item_stock = $item_stock_array[$i];
                    $item_type = $item_type_array[$i];
                    $order_item_quantity = $order_item_quantity_array[$i];

                    //Item Discount Amount Calculation
                    $item_discount_amount = ($item_price * $discount_percentage) / 100;
                    $item_total_discount_amount = $item_discount_amount * $item_quantity;
                    //End Of Item Amount calculation

                    if ($item_type == "recipe") {
                        $item_type_id = 1;
                    } else {
                        $item_type_id = 2;
                    }  //Set To Value in item Type

                    $inventoryitem = new inventoryitemModel();
                    $inventoryitem->item_ip = $request->ip();
                    $inventoryitem->item_status = 0;
                    $inventoryitem->inventory_id = $inventory_id;
                    $inventoryitem->inventory_product_name = $item_name;
                    $inventoryitem->inventory_item_id = $item_id;
                    $inventoryitem->inventory_item_type = $item_type_id;
                    $inventoryitem->inventory_item_varient = $item_varient_id;
                    $inventoryitem->inventory_item_price = $item_price;
                    $inventoryitem->inventory_item_mrp = $item_org_price;
                    $inventoryitem->inventory_item_quantity = $item_quantity;
                    $inventoryitem->inventory_item_total = $item_total_price;
                    $inventoryitem->inventory_item_cost = 0;
                    $inventoryitem->item_discount_amount = $item_total_discount_amount;
                    $inventoryitem->inventory_item_total_price = $item_total_price - $item_total_discount_amount;
                    $inventoryitem->inventory_item_profit = 0;
                    $inventoryitem->added_by = Auth::user()->id;
                    $inventoryitem->updated_by = Auth::user()->id;
                    $inventoryitem->save();

                    //If is is a not Order
                    if ($order_id == "" || $order_id == 0) {
                        if ($item_type_id == 1) {

                            // update stock and Stock Log
                            $recipe_id = $item_id;
                            $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                            $recipe_name = $recipe_details->recipe_name;
                            $stock_in_or_out = 0;
                            $stock_current_qty = $recipe_details->recipe_stock;
                            $stock_changing_qty = $item_quantity;
                            $stock_updated_qty = $stock_current_qty - $stock_changing_qty;
                            $comment = 'From the Invoice  ' . $inventory->inventory_unique_id . ' ' . $recipe_name . ' stock has been reduced ';

                            stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);
                            // End Of Update Stock And Stock Log

                        }

                    }
                    //Pos Not From A Order
                    //Its From A Order
                    else {
                        if ($item_type_id == 1) {
                            $stock_diff = $item_quantity - $order_item_quantity;

                            if ($stock_diff != 0) {  //From an order and quantity Changes

                                if ($stock_diff < 0) {  //If Item Qty Reduce Than Order Qty

                                    //Update Stock And Stock Log
                                    $recipe_id = $item_id;
                                    $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                                    $recipe_name = $recipe_details->recipe_name;
                                    $stock_in_or_out = 1;
                                    $stock_changing_qty = abs($stock_diff);
                                    $comment = 'From the Order   #' . $order_unique_id . ' Editing ' . $recipe_name . ' stock has been updated ';

                                    $stock_current_qty = $recipe_details->recipe_stock;

                                    $stock_updated_qty = $stock_current_qty + $stock_changing_qty;
                                    $comment = 'From the Invoice   #' . $inventory->inventory_unique_id . '  Editing ' . $recipe_name . ' stock has been reduced ';

                                    stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);

                                    // End Of Update Stock And Stock Log


                                } else if ($stock_diff > 0) {//item Qty Greater Than Order Qty
                                    //Update Stock And Stock Log
                                    $recipe_id = $item_id;
                                    $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                                    $recipe_name = $recipe_details->recipe_name;

                                    $stock_in_or_out = 0;
                                    $stock_changing_qty = abs($stock_diff);
                                    $comment = 'From the Invoice   #' . $inventory->inventory_unique_id . ' ' . $recipe_name . ' stock has been Reduced ';


                                    $stock_current_qty = $recipe_details->recipe_stock;

                                    $stock_updated_qty = $stock_current_qty - $stock_changing_qty;
                                    $comment = 'From the Invoice  ' . $inventory->inventory_unique_id . ' ' . $recipe_name . ' stock has been reduced ';

                                    stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);

                                    // End Of Update Stock And Stock Log

                                }


                            }
                        }
                        //End Of Item From a Order


                        ############################User Activity log#########################
                        $user_activity_log['activity_ip'] = $request->ip();
                        $user_activity_log['activity_user_name'] = Auth::user()->name;
                        $user_activity_log['activity_user_id'] = Auth::user()->id;
                        $user_activity_log['activity_action'] = "Invoice Created";
                        $user_activity_log['activity_desc'] = 'Invoice  ' . $inventory->inventory_unique_id . ' Has Been Generated By ' . Auth::user()->name;
                        user_activity_log($user_activity_log);
                        ###########################End Of USer Activity Log###################


                    }
                }

                //End Of Inventory Item Table
                DB::commit();

                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Invoice Created Successfully', 'invoice_id' => $inventory_id]);
            }else{
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Invoice Already Created Successfully']);

            }

        } catch (QueryException $e) {

            DB::rollBack();

            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);


        }


    }

    public function inventoryuniqueIdGenerator()
    {
        $lastInv = inventoryModel::orderby('invoice_id', 'DESC')->first();
        if ($lastInv) {
            $inv_unique_id = $lastInv->inventory_unique_id;
            $newdata = substr($inv_unique_id, -6);
            $newUniq = env('INVUNIQID') . sprintf('%06d', ($newdata + 1));
        } else {
            $newUniq = env('INVUNIQID') . sprintf('%06d', 1);
        }
        return $newUniq;
    }

    public function order_invoice($order_id)
    {
        $data = ['order_id' => $order_id];
        return Redirect::route('pos_module')->with($data);
    }

    public function recent_invoices()
    {
        $data['recent_invoice'] = inventoryModel::select('invoice_id', 'inventory_unique_id')->orderBy('invoice_id', 'Desc')->limit(4)->get();

        return response()->json($data);

    }


}
