<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use App\Models\pointModel;
use Auth;

use Illuminate\Http\Request;

class pointController extends Controller
{
    public function index(){
    $points=pointModel::first();
    return view('admin.points.index')->with('data',$points);
    }
    public function update_points(Request $request){
        $validator = Validator::make($request->all(), [
            'qr_for_credit_to_customer_point'=>'required|numeric',
            'one_point_qr_value'=>'required|numeric',
            'min_purchase_amount'=>'required|numeric',
            'points_expire_days'=>'required|numeric',
            'point_status'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        else{
          $one_point_needed_qr=$request->qr_for_credit_to_customer_point;
          $one_point_qr_value=$request->one_point_qr_value;
          $min_purchase_amount=$request->min_purchase_amount;
          $points_expire_days=$request->points_expire_days;
          $points_status=$request->point_status;
          $fetch_point=pointModel::all();
          if(count($fetch_point)>0){
            $data=['point_status'=>$points_status,
                   'money_needed_for_1_point'=>$one_point_needed_qr,
                   'one_point_value'=>$one_point_qr_value,
                   'min_amount_redeem_point'=>$min_purchase_amount,
                   'point_validity'=>$points_expire_days,
                  ];  
                $update_status=pointModel::orderby('point_id','Desc')->update($data);
                if($update_status==1){   
                   ############################User Activity log#########################
                  $user_activity_log['activity_ip']=$request->ip(); 
                  $user_activity_log['activity_user_name']=Auth::user()->name;
                  $user_activity_log['activity_user_id']=Auth::user()->id; 
                  $user_activity_log['activity_action']="Updated";
                  $user_activity_log['activity_desc']=' Ponits Has Been Updated By '.Auth::user()->name;
                  user_activity_log($user_activity_log);
                  ###########################End Of USer Activity Log###################
                  return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Successfuly Updated Points']);         }
                else{ return response()->json(['status' => 1,'heading'=>'Erroe', 'msg' => 'Something Went Wrong']);     }  
          }
          else{
            $point_model=new pointModel();
            $point_model->point_status=$points_status;
            $point_model->money_needed_for_1_point=$one_point_needed_qr;
            $point_model->one_point_value=$one_point_qr_value;
            $point_model->min_amount_redeem_point=$min_purchase_amount;
            $point_model->point_validity=$points_expire_days;
            $point_model->save();
             ############################User Activity log#########################
                  $user_activity_log['activity_ip']=$request->ip(); 
                  $user_activity_log['activity_user_name']=Auth::user()->name;
                  $user_activity_log['activity_user_id']=Auth::user()->id; 
                  $user_activity_log['activity_action']="Added";
                  $user_activity_log['activity_desc']=' Ponits Has Been Added By '.Auth::user()->name;
                  user_activity_log($user_activity_log);
                  ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Successfuly Updated Points']);
            
          }
          

        } 
    }
}