<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use PDF;
use DB;
use App\Models\formdataModel;

class pdfController extends Controller
{
    
        public function __construct()
    {
ini_set('memory_limit', '44M');

    }

 
    public function daily_report_export(){

        $file_name='Daily Report';
        if(session('from_date')){
            if(session('to_date')){
                $file_name="Daily Report ".date("d-m-Y", strtotime(session('from_date'))).' To '.date("d-m-Y", strtotime(session('to_date')));
            }
            else{
                
                 $file_name="Daily Report ".date("d-m-Y", strtotime(session('from_date')));
            }
        }


      $data1   = formdataModel::
       selectRaw('form_date,count(form_data_id) as total_form_count,
       sum(form_rating) as total_rating')
	    ->where('form_data_status',0)
	   ->orderBy('form_date','DESC')
	   	->groupBy('form_date');              
	   if(session('from_date'))
        {
            $from_date = date("Y-m-d", strtotime(session('from_date')));
        if(session('to_date'))
        	{
            $to_date = date("Y-m-d", strtotime(session('to_date')));
        	$data1->where('form_date','>=',    $from_date);
        	$data1->where('form_date','<=',$to_date);
        	}
        else
        	{
        	$data1->where('form_date',$from_date);
        	}
        }

        $datas=$data1->get();

        $company_details=get_branch_data();



            $data = [
            'company_details'=>$company_details,
            'report_data'=>$datas, 
            'report_heading'=>'Daily Report',
            ];

        $pdf = PDF::loadView('admin.reports.daily.daily_pdf_export', $data);
        return $pdf->download($file_name.'.pdf');

        // return view('admin.reports.daily.daily_pdf_export')->with('data',$data);
    }

    public function monthly_report_export(){
         $file_name='Monthly Report';
        if(session('from_date')){
            if(session('to_date')){
                $file_name="Monthly Report ".date("d-m-Y", strtotime(session('from_date'))).' To '.date("d-m-Y", strtotime(session('to_date')));
            }
            else{
                
                 $file_name="Monthly Report ".date("d-m-Y", strtotime(session('from_date')));
            }
        }

          $data1 = formdataModel::select(
                            DB::raw("sum(form_rating) as total_rating"),
                            DB::raw("count(form_data_id) as total_form_count"),
                            DB::raw("MONTHNAME(form_date) as month_name"),
                            DB::raw('YEAR(form_date) year')
                            );
                            if(session('from_date'))
                            {
                            $from_date = date("Y-m-d", strtotime(session('from_date')));
                            if(session('to_date'))
                                {
                                $to_date = date("Y-m-d", strtotime(session('to_date')));
                                $data1->where('form_date','>=',    $from_date);
                                $data1->where('form_date','<=',$to_date);
                                }
                            else
                                {
                                $data1->where('form_date',$from_date);
                                }
                            }
                       $data1 ->groupBy('month_name','year');

	                    $datas = $data1->get();

                        $company_details=get_branch_data();

            $data = [
            'company_details'=>$company_details,
            'report_data'=>$datas, 
            'report_heading'=>'Monthly Report',
            ];

        $pdf = PDF::loadView('admin.reports.monthly.monthly_pdf_export', $data);
        return $pdf->download($file_name.'.pdf');



    }
  
}
