<?php

namespace App\Http\Controllers;

use App\Jobs\SendFeedback;
use App\Models\branchModel;
use App\Models\categoryModel;
use App\Models\DeliveryStatus;
use App\Models\FeedBack;
use App\Models\orderitemModel;
use Illuminate\Http\Request;
use App\Models\orderModel;
use DB;
use App\Models\layoutModel;
use App\Models\tableModel;
use App\Models\recipeModel;
use Auth;
use Illuminate\Support\Facades\Validator;

class orderController extends Controller
{
    public function index()
    {
        $data['branches'] = branchModel::all();

        return view('admin.order.index', $data);
    }

    public function order_datattable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_orders.order_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }
        if (Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = orderModel::with('table', 'customer_cart', 'customer_cart.branch')
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->Where(function ($query) use ($search) {
                    $query->where('order_unique_id', 'like', $search . '%');
                    $query->orwhere('order_customer_name', 'like', $search . '%');
                    $query->orwhere('order_customer_mob', 'like', $search . '%');
                });
        } else {
            $fetch_data = orderModel::with('table', 'customer_cart', 'customer_cart.branch')
                ->Where(function ($query) use ($search) {
                    $query->where('order_unique_id', 'like', $search . '%');
                    $query->orwhere('order_customer_name', 'like', $search . '%');
                    $query->orwhere('order_customer_mob', 'like', $search . '%');
                });
        }
        if ($colName != '' && $sort != '') {
            $fetch_data->orderBy($colName, $sort);
        } else {
            $fetch_data->orderBy('order_id', 'DESC');
        }

        if (session('order_from_date_filter')) {

            if (session('order_to_date_filter')) {
                $fetch_data->where('order_date', '>=', session('order_from_date_filter'));
                $fetch_data->where('order_date', '<=', session('order_to_date_filter'));
            } else {
                $fetch_data->where('order_date', session('order_from_date_filter'));
            }

        }

        if (session('order_status')) {
            $fetch_data->where('order_tracking_status', session('order_status'));
        }

        if (session('branch_id')) {
            $fetch_data->where('branch_id', session('branch_id'));
        }

        $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }

    public function order_datattable2(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $user_id = $request->user_id;
        $columns = $request->columns;
        $colName = 'tbl_orders.order_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }
        $fetch_data = orderModel::with('table', 'customer_cart', 'customer_cart.branch')
            ->where('order_customer_id', $user_id)
            ->Where(function ($query) use ($search) {
                $query->where('order_unique_id', 'like', $search . '%');
                $query->orwhere('order_customer_name', 'like', $search . '%');
                $query->orwhere('order_customer_mob', 'like', $search . '%');
            });
        if ($colName != '' && $sort != '') {
            $fetch_data->orderBy($colName, $sort);
        } else {
            $fetch_data->orderBy('order_id', 'DESC');
        }

        if (session('order_from_date_filter')) {

            if (session('order_to_date_filter')) {
                $fetch_data->where('order_date', '>=', session('order_from_date_filter'));
                $fetch_data->where('order_date', '<=', session('order_to_date_filter'));
            } else {
                $fetch_data->where('order_date', session('order_from_date_filter'));
            }

        }

        if (session('order_status')) {
            $fetch_data->where('order_tracking_status', session('order_status'));
        }

        $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }

    public function get_tracking(Request $request)
    {
        $order_id = $request->id;
        $data['order_details'] = ordermodel::where('order_id', $order_id)->first();
        $tracking_status[1] = "Product dispatched";
        $tracking_status[2] = "Product on transit";
        $tracking_status[3] = "Product delivered";
        $data['tracking_status'] = $tracking_status;

        // return response()->json($data);
        return view('admin.order.order_tracking_modal')->with(['data' => $data]);
    }

    public function change_tracking(Request $request)
    {
        $order_id = $request->id;
        $order_tracking_status = $request->tracking_status;
        $customer_mob = ordermodel::where('order_id', $order_id)->first()->order_customer_mob;
        $update_order = ordermodel::where('order_id', $order_id)->update(['order_tracking_status' => $order_tracking_status]);
//        if ($order_tracking_status == "Delivered") {
//            $update_order = ordermodel::where('order_id', $order_id)->update(['o_payment_status' => 'Paid']);
//        }

        if ($order_tracking_status == "Delivered") {
            $feed_back = FeedBack::find(1);
            //SendFeedback::dispatch($customer_mob, $feed_back->message)->delay(now()->addMinutes($feed_back->time));
            dispatch(new SendFeedback($customer_mob, $feed_back->message))
                ->delay(now()->addMinutes($feed_back->time));
//            SendFeedback::dispatch([
//                'cid' => $customer_mob,
//                'message'   => $feed_back->message,
//            ])->delay(now()->addMinutes($feed_back->time));
        }

        if ($update_order == 1) {
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Order Tracking Status Changed']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Wrong']);
        }


    }

    public function vieworder(Request $request)
    {
        $id = $request->id;
        $data['order_details'] = orderModel::where('order_id', $id)
            ->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'table', 'promocode', 'customer_cart')->first();
        $data['company_details'] = layoutModel::first();

        return view('admin.order.order_modal')->with('data', $data);
    }

    public function change_status2(Request $request)
    {
        $status = $request->status;
        session()->put('order_status', $status);
        return;
    }

    public function change_branch(Request $request)
    {
        $branch_id = $request->branch_id;
        session()->put('branch_id', $branch_id);
        return;
    }

    public function order_from_date_filter(Request $request)
    {
        $from_date = $request->from_date;
        $date = date_create_from_format('m/d/Y', $from_date);
        $from_date = date_format($date, 'Y-m-d');
        session()->put('order_from_date_filter', $from_date);
        return;

    }

    public function order_to_date_filter(Request $request)
    {
        $to_date = $request->to_date;
        $date = date_create_from_format('m/d/Y', $to_date);
        $to_date = date_format($date, 'Y-m-d');
        session()->put('order_to_date_filter', $to_date);
        return;

    }

    public function cancel_order(Request $request)
    {
        $id = $request->id;

        try {
            // Start a database transaction
            DB::beginTransaction();


            $details = orderModel::with('order_items')->where('order_id', $id)->first();
            $table_id = $details->order_table_id;
            $cancel_order = orderModel::where('order_id', $id)->update(['order_tracking_status' => 'Cancelled']);
            //if cancelling order table status change to available
            $table_change_to_active = tableModel::where('table_id', $table_id)->update(['table_tracking_status' => 'Available']);
            DB::commit();


            if ($cancel_order) {

                //Order Items
                $order_items = $details['order_items'];
                foreach ($order_items as $order_item) {

                    // update stock and Stock Log
                    $recipe_id = $order_item['recipe_id'];
                    $order_item_quantity = $order_item['order_item_quantity'];
                    $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                    $recipe_name = $recipe_details->recipe_name;
                    $stock_in_or_out = 1;
                    $stock_current_qty = $recipe_details->recipe_stock;
                    $stock_changing_qty = $order_item_quantity;
                    $stock_updated_qty = $stock_current_qty + $stock_changing_qty;
                    $comment = 'Due To Order  ' . $details->order_unique_id . ' Cancellation By ' . Auth::user()->name . ' ' . $recipe_name . ' stock has been Updated ';
                    stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);

                }
                // End Of Update Stock And Stock Log


                ############################User Activity log#########################
                $user_activity_log['activity_ip'] = $request->ip();
                $user_activity_log['activity_user_name'] = Auth::user()->name;
                $user_activity_log['activity_user_id'] = Auth::user()->id;
                $user_activity_log['activity_action'] = "Cancelled";
                $user_activity_log['activity_desc'] = 'Order ' . $details->order_unique_id . ' Has Been Cancelled By ' . Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Order Cancelled successfully']);
            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }


        } catch (QueryException $e) {

            DB::rollBack();

        }

    }

    public function approve_order(Request $request)
    {
        try {
            DB::beginTransaction();
            $id = $request->id;

            $details = orderModel::where('order_id', $id)->first();
            $update = orderModel::where('order_id', $id)->update(['order_tracking_status' => 'Approved']);
            DB::commit();
            if ($update == 1) {
                ############################User Activity log#########################
                $user_activity_log['activity_ip'] = $request->ip();
                $user_activity_log['activity_user_name'] = Auth::user()->name;
                $user_activity_log['activity_user_id'] = Auth::user()->id;
                $user_activity_log['activity_action'] = "Approved";
                $user_activity_log['activity_desc'] = 'Order ' . $details->order_unique_id . ' Has Been Approved By ' . Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Order Approved successfully']);
            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }

        } catch (QueryException $e) {

            DB::rollBack();
        }
    }

    public function print_order(Request $request)
    {
        $id = $request->order_id;
        $data['order_details'] = orderModel::where('order_id', $id)->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'table', 'promocode')->first();
        $data['company_details'] = layoutModel::first();
        return view('admin.order.order_print')->with('data', $data);

    }

    public function payment_response(Request $request)
    {
        dd($request->all());
    }

    public function order_status()
    {
        return view('admin.order.delivery_status');
    }

    public function status_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_delivery_status.id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $category_data = $roles = DeliveryStatus::Where(function ($query) use ($search) {
            $query->where('status', 'like', $search . '%');

        });
        if ($colName != '' && $sort != '') {
            $category_data->orderBy($colName, $sort);
        } else {
            $category_data->orderBy('id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $category_data->count(), 'iTotalRecords' => $category_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $category_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }

    public function edit_status(Request $request)
    {
        $id = $request->id;
        $data = DeliveryStatus::find($id);
        return response()->json($data);
    }

    public function update_status(Request $request)
    {
        $id = $request->status_id;
        $validator = Validator::make($request->all(), [
            'message_en' => 'required',
            'message_ar' => 'required',
        ]);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        ########################End Of Validation Section##########################


        $data = [
            'message' => $request->message_en,
            'message_ar' => $request->message_ar,
        ];

        $update = DeliveryStatus::where('id', $id)->update($data);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Delivery Status Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Delivery Status updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function status_view(Request $request)
    {
        $id = $request->id;
        $data['status'] = DeliveryStatus::find($id);

        return view('admin.order.modal', compact('data'));
    }
}
