<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\layoutModel;
use App\Models\countryModel;
use Auth;

class layoutController extends Controller
{
    public function index()
    {

        $data['layout_data'] = layoutModel::first();
         $data['country_data'] = countryModel::all();
        return view('admin.layouts.index')->with('data', $data);
    }

    public function add_website_layout(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'website_name' => 'required',
            'website_link' => 'required',
            'website_email' => 'required|email',
            'website_phone' => 'required',
            'website_address' => 'required',
            'primary_color' => 'required',
            'admin_primary_color' => 'required',
            'developed_by' => 'required',
            'developed_compnay_link' => 'required',
            'country'=>'required|numeric',
            // 'website_logo'=>'dimensions:width=1050,height=300',
            // 'website_icon'=>'dimensions:width=32,height=32',
            'admin_logo' => 'dimensions:width=428,height=144',
            'admin_d_logo' => 'dimensions:width=428,height=144',
            'admin_sm_logo' => 'dimensions:width=107,height=102',
            'admin_d_sm_logo' => 'dimensions:width=107,height=102',
            'admin_background_image' => 'dimensions:width=1920,height=900',
            'notification_sound' => 'required'
        ]);

 
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }


        $data = [
            'website_name' => $request->website_name,
            'website_link' => $request->website_link,
            'website_email' => $request->website_email,
            'website_phone' => $request->website_phone,
            'website_address' => $request->website_address,
            'website_country' => $request->country,
            'website_title' => $request->title,
            'theme_color' => $request->primary_color,
            'developed_by' => $request->developed_by,
            'developer_link' => $request->developed_compnay_link,
            'meta_data' => $request->meta_description,
            'admin_theme_color' => $request->admin_primary_color,
            'notification_sound' => $request->notification_sound,
            'facebook_link'=> $request->facebbok,
            'instagram_link'=> $request->instagram,
            'twitter_link'=> $request->twitter,
            'youtube_link'=> $request->youtube,
            'whats_app_number'=> $request->whatsapp,

        ];
        //Logo Section
        if ($request->file('website_logo')) {
            $image = $request->file('website_logo');
            $imageDestinationPath = 'uploads/layouts';
            $postImage = date('YmdHis') . rand(0, 9999) ."." .  $image->getClientOriginalExtension();
            $image->move($imageDestinationPath, $postImage);
            $data['webste_logo'] = $postImage;
        }
        //End Of Logo Section

        //Icon Secton Section
        if ($request->file('website_icon')) {
            $image1 = $request->file('website_icon');
            $imageDestinationPath1 = 'uploads/layouts';
            $postImage1 = date('YmdHis') . rand(0, 9999) . "." . $image1->getClientOriginalExtension();
            $image1->move($imageDestinationPath1, $postImage1);
            $data['website_icon'] = $postImage1;
        }
        //End Of Icon Section

        //Admin Logo   Section
        if ($request->file('admin_logo')) {
            $image2 = $request->file('admin_logo');
            $imageDestinationPath2 = 'uploads/layouts';
            $postImage2 = date('YmdHis') . rand(0, 9999) . "." . $image2->getClientOriginalExtension();
            $image2->move($imageDestinationPath2, $postImage2);
            $data['admin_logo'] = $postImage2;
        }
        //End Of Icon Section

        //Admin Logo Darkmode Section
        if ($request->file('admin_d_logo')) {
            $image3 = $request->file('admin_d_logo');
            $imageDestinationPath3 = 'uploads/layouts';
            $postImage3 = date('YmdHis') . rand(0, 9999) . "." . $image3->getClientOriginalExtension();
            $image3->move($imageDestinationPath3, $postImage3);
            $data['admin_d_logo'] = $postImage3;
        }
        //End Of Admin Logo Darkmode

        //Admin Logo SM Section
        if ($request->file('admin_sm_logo')) {
            $image4 = $request->file('admin_sm_logo');
            $imageDestinationPath4 = 'uploads/layouts';
            $postImage4 = date('YmdHis') . rand(0, 9999) . "." . $image4->getClientOriginalExtension();
            $image4->move($imageDestinationPath4, $postImage4);
            $data['admin_logo_sm'] = $postImage4;
        }
        //End  Logo SM Section

        //Icon Secton Section
        if ($request->file('admin_d_sm_logo')) {
            $image5 = $request->file('admin_d_sm_logo');
            $imageDestinationPath5 = 'uploads/layouts';
            $postImage5 = date('YmdHis') . rand(0, 9999) . "." . $image5->getClientOriginalExtension();
            $image5->move($imageDestinationPath5, $postImage5);
            $data['admin_d_logo_sm'] = $postImage5;
        }
        //End Of Icon Section
        //Admin Background   Section
        
        
        if ($request->file('admin_background_image')) {
            $image6 = $request->file('admin_background_image');
            $imageDestinationPath6 = 'uploads/layouts';
            $postImage6 = date('YmdHis') . rand(0, 9999) . "." . $image6->getClientOriginalExtension();
            $image6->move($imageDestinationPath6, $postImage6);
            $data['admin_background_image'] = $postImage6;
        }
        
        
        //End Of Admin Background  Section
        $update = layoutModel::where('layout_id', 1)->update($data);


        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Layout  Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Layout Updated Successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }


    }



}