<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\languageModel;
use Auth;

class languageController extends Controller
{
    public function index()
    {

        return view('admin.language.index');

    }

    public function add_language(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'language_name' => 'required',
            'language_short_code' => 'required',
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        try {

            //Check Language Already Exist
            $check_language_exist = $this->check_language_exist('save', $request->language_name);
            if ($check_language_exist == true) {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $request->language_name . ' Language Alreday Exist']);
            }
            $language = new languageModel();
            $language->language_ip = $request->ip();
            $language->language_status = 0;
            $language->language_short_code = $request->language_short_code;
            $language->language_name = $request->language_name;
            $language->created_by = Auth::user()->id;
            $language->updated_by = Auth::user()->id;
            $language->language_permalink = strtolower($this->permalink_generator($request->language_short_code));
            $language->save();
            if ($language) {
                ###############User Activity log#########################
                $user_activity_log['activity_ip'] = $request->ip();
                $user_activity_log['activity_user_name'] = Auth::user()->name;
                $user_activity_log['activity_user_id'] = Auth::user()->id;
                $user_activity_log['activity_action'] = "Added";
                $user_activity_log['activity_desc'] = 'New Language  ' . $request->language_name . ' Has Been Added By ' . Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Language added successfully ']);
            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }
        } catch (\Exception $e) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $e->getMessage()]);
        }
    }


    public function language_datatable(Request $request)
    {

        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_languages.language_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }
        $coupon_data = languageModel::where('language_status', 0)
            ->leftjoin('users', 'tbl_languages.created_by', 'users.id')

            ->select('tbl_languages.*', 'users.name')
            ->Where(function ($query) use ($search) {
                $query->where('language_name', 'like', '%' . $search . '%');
                $query->orwhere('language_short_code', 'like', $search . '%');

            });
        if ($colName != '' && $sort != '') {
            $coupon_data->orderBy($colName, $sort);
        } else {
            $coupon_data->orderBy('language_id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $coupon_data->count(), 'iTotalRecords' => $coupon_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $coupon_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);

    }

    public function edit_language(Request $request)
    {
        $id = $request->id;
        $language = languageModel::select('*')
            ->where('language_id', $id)
            ->first();

        return $language;
    }

    public function update_language(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'language_name' => 'required',
            'language_id' => 'required',
            'language_short_code' => 'required',
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        try {

            //Check Language Already Exist
            $check_language_exist = $this->check_language_exist('update', $request->language_name);
            if ($check_language_exist == true) {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $request->language_name . ' Language Alreday Exist']);
            }

            $data = [
                'language_ip' => $request->ip(),
                'language_short_code' => $request->language_short_code,
                'language_name' => $request->language_name,
                'language_permalink' => strtolower($this->permalink_generator($request->language_short_code)),
                'updated_by' => Auth::user()->id,
            ];
            $details = languageModel::where('language_id', $request->language_id)->first();
            $language_name = $details->language_name;
            $update = languageModel::where('language_id', $request->language_id)->update($data);

            if ($update) {
                ###############User Activity log#########################
                $user_activity_log['activity_ip'] = $request->ip();
                $user_activity_log['activity_user_name'] = Auth::user()->name;
                $user_activity_log['activity_user_id'] = Auth::user()->id;
                $user_activity_log['activity_action'] = "Updated";
                $user_activity_log['activity_desc'] = ' Language  ' . $language_name . ' Has Been Updated By ' . Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Language Updated successfully ']);
            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }
        } catch (\Exception $e) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $e->getMessage()]);
        }

    }

    public function delete_language(Request $request)
    {

        $id = $request->id;
        $details = languageModel::where('language_id', $id)->first();
        $update = languageModel::where('language_id', $id)->update(['language_status' => 1]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Deleted";
            $user_activity_log['activity_desc'] = 'Language ' . $details->language_name . ' Has Been Deleted By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Language removed successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }



    }


    protected function check_language_exist($action = "", $language)
    {

        $check_language = languageModel::where('language_status', 0)->where('language_name', $language)->get();
        if ($action = "update") { //When Updating
            if (count($check_language) > 1) {
                return true;
            } else {
                return false;
            }
        } else {
            if (count($check_language) > 0) {
                return true;
            } else {
                return false;
            }
        }

    }

    public function change_language_active_status(Request $request)
    {


        $id = $request->id;
        $current_status = $request->active_status;
        $updating_status = 0;
        if ($current_status == 1) {
            $updating_status = 0;
            $updated_cmnt = "Activated";
        } else {
            $updating_status = 1;
            $updated_cmnt = "Inactivated";
        }

        $data = ['language_active_status' => $updating_status];

        //Language Details

        $details = languageModel::where('language_id', $id)->first();

        $update = languageModel::where('language_id', $id)->update($data);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Language ' . $details->language_name . ' Has Been ' . $updated_cmnt . ' By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Status Changed Succesfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    function permalink_generator($string)
    {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }

}