<?php

namespace App\Http\Controllers;

use App\Models\branchModel;
use Illuminate\Http\Request;
use App\Models\inventoryModel;
use Illuminate\Support\Facades\Auth;
use Session;
use App\Traits\pointTrait;

class inventoryController extends Controller
{

    use pointTrait;

    public function index()
    {

        return view('admin.inventory.index');

    }

    public function invoice_print($id)
    {
        $data['inventory_data'] = inventoryModel::with('inventory_items', 'inventory_items.recipies', 'inventory_items.varient', 'promocode')->where('invoice_id', $id)->first();
        return view('admin.inventory.pos_print', compact('data'));
    }

    public function view_invoice(Request $request)
    {
        $id = $request->id;

        $data['inventory_data'] = inventoryModel::with('inventory_items', 'inventory_items.recipies', 'inventory_items.varient', 'promocode')->where('invoice_id', $id)->first();
        //   dd($data['inventory_data']->inventory_items);
        return view('admin.inventory.invoice_modal', compact('data'));


    }

    public function invoice_datattable(Request $request)
    {

        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_orders.order_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }

        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();
            $fetch_data = inventoryModel::where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->Where(function ($query) use ($search) {
                    $query->where('inventory_unique_id', 'like', $search . '%');
                    $query->orwhere('invoice_customer_name', 'like', $search . '%');
                    $query->orwhere('invoice_contact_number', 'like', $search . '%');
                });
        } else {
            $fetch_data = inventoryModel::
            Where(function ($query) use ($search) {
                $query->where('inventory_unique_id', 'like', $search . '%');
                $query->orwhere('invoice_customer_name', 'like', $search . '%');
                $query->orwhere('invoice_contact_number', 'like', $search . '%');
            });
        }
        if ($colName != '' && $sort != '') {
            $fetch_data->orderBy($colName, $sort);
        } else {
            $fetch_data->orderBy('invoice_id', 'DESC');
        }

        if (session('invoice_from_date_filter')) {

            if (session('invoice_to_date_filter')) {
                $fetch_data->where('invoice_date', '>=', session('invoice_from_date_filter'));
                $fetch_data->where('invoice_date', '<=', session('invoice_to_date_filter'));
            } else {
                $fetch_data->where('invoice_date', session('invoice_from_date_filter'));
            }

        }

        $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);


    }

    public function invoice_from_date_filter(Request $request)
    {

        $from_date = $request->from_date;
        $date = date_create_from_format('m/d/Y', $from_date);
        $from_date = date_format($date, 'Y-m-d');
        session()->put('invoice_from_date_filter', $from_date);
        return;

    }

    public function invoice_to_date_filter(Request $request)
    {
        $to_date = $request->to_date;
        $date = date_create_from_format('m/d/Y', $to_date);
        $to_date = date_format($date, 'Y-m-d');
        session()->put('invoice_to_date_filter', $to_date);
        return;
    }


}
