<?php

namespace App\Http\Controllers;
use App\Models\imageresolutionmodel;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\File;

use Dotenv\Dotenv;

class imageresolutionController extends Controller
{
  public function index(){
    $data['image_resolutions']=imageresolutionmodel::orderBy('showing_order','ASC')->get();
    return view('admin.image_resolution.index')->with('data',$data);
  }
  public function image_resolution_update(Request $request){
    $available_image_resolution=imageresolutionmodel::get();
    $validation_data=array();
    foreach($available_image_resolution as $image_resolution){
    $validation_data['image_width_'.$image_resolution['image_resolution_id']]= 'required|numeric';
    $validation_data['image_height_'.$image_resolution['image_resolution_id']]= 'required|numeric';
    $validation_data['image_file_size_'.$image_resolution['image_resolution_id']]= 'required|numeric';

    }

    $validator = Validator::make($request->all(), $validation_data);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        
 foreach($available_image_resolution as $image_resolution){
        $width=$request->{'image_width_'.$image_resolution['image_resolution_id']};
        $height=$request->{'image_height_'.$image_resolution['image_resolution_id']};
        $size=$request->{'image_file_size_'.$image_resolution['image_resolution_id']};

            $dimenssion=$width.'x'.$height;
            $updating_data=['image_resolution_dimenssion'=>$dimenssion,
                            'image_size'=>$size,
                            'updated_by'=>Auth::user()->id
                    ];

        $update=imageresolutionmodel::where('image_resolution_id',$image_resolution['image_resolution_id'])->update($updating_data);

          $this->replaceEnvVariable($image_resolution['env_para_name'],$dimenssion);    
          $this->replaceEnvVariable($image_resolution['env_file_para_name'],$size);  
                    
    }
          ;
        if ($update) {
                ###############User Activity log#########################
                $user_activity_log['activity_ip'] = $request->ip();
                $user_activity_log['activity_user_name'] = Auth::user()->name;
                $user_activity_log['activity_user_id'] = Auth::user()->id;
                $user_activity_log['activity_action'] = "Updated";
                $user_activity_log['activity_desc'] = ' Image Resolution Setting  Has Been Updated By ' . Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Image Resolution Updated successfully ']);
            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }


        
    
  }

  function replaceEnvVariable($key, $value)
{
    // Load the contents of the .env file
    $envFilePath = base_path('.env');
    $envContents = File::get($envFilePath);

    $pattern = "/\b{$key}=\S*/";
$replacement = "{$key}={$value}";
$newEnvContents = preg_replace($pattern, $replacement, $envContents);



    // Replace the variable value
    // $newEnvContents = preg_replace("/{$key}=.*/", "{$key}={$value}", $envContents);

    // Save the updated contents back to the .env file
    File::put($envFilePath, $newEnvContents);

    // Reload the environment variables
    $dotenv = Dotenv::createMutable(base_path());
    $dotenv->load();
}
}