<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\giftcardModel;
use Illuminate\Support\Facades\Validator;
use Auth;
class giftcardController extends Controller
{
    public function index(){
        $gift_cards=giftcardModel::where('giftcard_status',0)->get();
        return view('admin.giftcard.index')->with('data',$gift_cards);
    }
    public function add_giftcard(Request $request){
        $validator = Validator::make($request->all(), [
            'gift_card_name'=>'required|',
            'gift_card_amount'=>'required|numeric',
            'gift_card_validity'=>'required|numeric',
            'status'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        $gift_card=new giftcardModel();
        $gift_card->giftcard_name=$request->gift_card_name;
        $gift_card->giftcard_amount=$request->gift_card_amount;
        $gift_card->giftcard_validity=$request->gift_card_validity;
        $gift_card->giftcard_active_status=$request->status;
        $gift_card->created_by=Auth::user()->id;
        $gift_card->updated_by=Auth::user()->id;
        $gift_card->save();
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Giftcard '.$request->gift_card_name.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
        return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Giftcard Added Successfully']);
    }
    public function change_giftcard_status(Request $request){
        $giftcard_id=$request->gift_card_id;
        $status=$request->status;
        $data=['giftcard_active_status'=>$status];
        $details=giftcardModel::where('giftcard_id',$giftcard_id)->first();
        $update_status=giftcardModel::where('giftcard_id',$giftcard_id)->update($data);
        if($update_status==1){
             ############################User Activity log#########################
                $user_activity_log['activity_ip']=$request->ip(); 
                $user_activity_log['activity_user_name']=Auth::user()->name;
                $user_activity_log['activity_user_id']=Auth::user()->id; 
                $user_activity_log['activity_action']="Updated";
                $active_status="Activate";
                if($status==1){$active_status="Inactivate";}
                $user_activity_log['activity_desc']='Giftcard '.$details->giftcard_name.' Has Been '.$active_status.' By '.Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Status changed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }
    public function edit_giftcard(Request $request){
      $giftcard_id=$request->id;
      $giftcard_data=giftcardModel::select('*')->where('giftcard_id',$giftcard_id)->first();
      return response()->json(['status' => '0', 'msg' => 'succes','data'=>$giftcard_data]);
    }
    public function update_giftcard(Request $request){
        $validator = Validator::make($request->all(), [
            'giftcard_id'=>'required|numeric',
            'gift_card_name'=>'required|',
            'gift_card_amount'=>'required|numeric',
            'gift_card_validity'=>'required|numeric',
            'status'=>'required',
        ]);
        
        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
        }
        $data=[
            'giftcard_name'=>$request->gift_card_name,
            'giftcard_amount'=>$request->gift_card_amount,
            'giftcard_validity'=>$request->gift_card_validity,
            'giftcard_active_status'=>$request->status,
            'updated_by'=>Auth::user()->id
        ];
        $update_giftcard=giftcardModel::where('giftcard_id',$request->giftcard_id)->update($data); 
        if($update_giftcard==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Giftcard '.$request->giftcard_name.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Gifcard updated successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }
    public function delete_giftcard(Request $request){
        $id=$request->id;
        $details=giftcardModel::where('giftcard_id',$id)->first();
        $update_giftcard=giftcardModel::where('giftcard_id',$id)->update(['giftcard_status'=>1]);
        if($update_giftcard==1){
        ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Giftcard '.$details->giftcard_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Giftcard removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }
    public function giftcard_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_giftcards.giftcard_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }
        $datas = giftcardModel::where('giftcard_status',0)
        ->select('tbl_giftcards.*')
        ->leftjoin('users','tbl_giftcards.created_by','users.id')
        ->Where(function($query) use ($search) {
             $query->where('giftcard_name', 'like', $search . '%');
             $query->where('giftcard_amount', 'like', $search . '%');
        });
       if ($colName != '' && $sort != '') {
           $datas->orderBy($colName, $sort);
       }
       else{
         $datas->orderBy('giftcard_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $datas->count(), 'iTotalRecords' => $datas->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $datas->skip($offset)->take($limit)->get()->toArray();
       return response()->json($data);
    }
}