<?php

namespace App\Http\Controllers;

use App\Exports\customerExport;
use App\Exports\ExportCustomer;
use App\Models\ApiCartModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\customerModel;
use App\Models\tokenModel;

use Auth;
use Maatwebsite\Excel\Facades\Excel;

class customerController extends Controller
{
    public function index()
    {
        $data['users'] = customerModel::where('customer_status', 0)->orderBy('customer_id', 'DESC')->get();

        return view('admin.customers.index', $data);
    }

    public function add_customer(Request $request)
    {

        $mobile_number_length = session('layout_data')['mobile_max_length'];

        $validator = Validator::make($request->all(), [
            'customer_name' => 'required',
            'mobile_number' => 'required|numeric|digits:' . $mobile_number_length,
            'email' => 'required|email',
        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        $check_exist = customerModel::where('customer_status', 0)->where('customer_mob', $request->mobile_number)->first();
        if ($check_exist) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'The Mobile Number ' . $request->mobile_number . ' already Registered']);
        }
        $unique_id = $this->sku_generate();
        $customer = new customerModel();
        $customer->customer_ip = $request->ip();
        $customer->customer_status = 0;
        $customer->customer_unique_id = $unique_id;
        $customer->customer_name = $request->customer_name;
        $customer->customer_mob = $request->mobile_number;
        $customer->customer_mail_id = $request->email;
        $customer->customer_address = $request->address;
        $customer->created_by = Auth::user()->id;
        $customer->updated_by = Auth::user()->id;
        $customer->save();
        if ($customer) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Added";
            $user_activity_log['activity_desc'] = 'New Customer  ' . $request->customer_name . ' Has Been Added By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Customer added successfully ']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function customer_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_customers.customer_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }
        $role_data = $roles = customerModel::where('customer_status', 0)
            ->leftjoin('users', 'tbl_customers.created_by', 'users.id')
            ->select('tbl_customers.*', 'users.name')
            ->Where(function ($query) use ($search) {
                $query->where('customer_name', 'like', $search . '%');
                $query->orwhere('customer_mob', 'like', $search . '%');
                $query->orwhere('customer_mail_id', 'like', $search . '%');
                $query->orwhere('customer_q_id', 'like', $search . '%');
                $query->orwhere('customer_unique_id', 'like', $search . '%');
            });
        if ($colName != '' && $sort != '') {
            $role_data->orderBy($colName, $sort);
        } else {
            $role_data->orderBy('customer_id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $role_data->count(), 'iTotalRecords' => $role_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $role_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);

    }

    public function edit_customer(Request $request)
    {
        $id = $request->id;
        $customer = customerModel::where('customer_id', $id)->first();
        return $customer;
    }

    public function update_customer(Request $request)
    {
        $mobile_number_length = session('layout_data')['mobile_max_length'];


        $id = $request->customer_id;
        $validator = Validator::make($request->all(), [
            'customer_name' => 'required',
            'mobile_number' => 'required|numeric|digits:' . $mobile_number_length,
            'customer_id' => 'required',
            'email' => 'required|email',
        ]);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        $data = [
            'customer_ip' => $request->ip(),
            'customer_name' => $request->customer_name,
            'customer_mob' => $request->mobile_number,
            'customer_mail_id' => $request->email,
            'customer_address' => $request->address,
            'updated_by' => Auth::user()->id,
        ];
        $update = customerModel::where('customer_id', $id)->update($data);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Customer  ' . $request->customer_name . ' Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Customer updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function delete_customer(Request $request)
    {
        $id = $request->id;
        $details = customerModel::where('customer_id', $id)->first();
        $update = customerModel::where('customer_id', $id)->update(['customer_status' => 1]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Deleted";
            $user_activity_log['activity_desc'] = 'Customer ' . $details->customer_name . ' Has Been Deleted By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Customer removed successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function view_customer(Request $request)
    {
        $id = $request->id;
        $customer = customerModel::where('customer_id', $id)->first();
        return view('admin.customers.customer_modal')->with('data', $customer);
    }

    public function sku_generate()
    {
        $lastcustomer = customerModel::orderby('customer_id', 'DESC')->first();
        if ($lastcustomer) {
            $lastcustomer = $lastcustomer->customer_unique_id;
            $newdata = substr($lastcustomer, -4);
            $newUniq = env('CUSTOMERUNIQID') . sprintf('%04d', ($newdata + 1));
        } else {
            $newUniq = env('CUSTOMERUNIQID') . sprintf('%04d', 1);
        }
        return $newUniq;
    }

    public function customer_orders($id)
    {
        $data['user_id'] = $id;

        return view('admin.customers.order.index', $data);
    }

    public function cart_activities($id)
    {
        $data['user_id'] = $id;
        $data['cart_activities'] = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on', 'cart_recipe.recipe_add_on.add_on_item')
            ->where('customer_id', $id)->get();
//dd($data);
        return view('admin.customers.cart_activities', $data);
    }

    public function download_customer()
    {
        return Excel::download(new ExportCustomer(), 'customers.xlsx');
    }

    public function visitors()
    {
        $data['users'] = customerModel::where('customer_status', 0)->orderBy('customer_id', 'DESC')->get();

        return view('admin.customers.visitors', $data);
    }

    public function visitors_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_customers.customer_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }
        $role_data = $roles = customerModel::where('customer_status', 0)
            ->leftjoin('users', 'tbl_customers.created_by', 'users.id')
            ->leftJoin('tbl_orders', 'tbl_orders.order_customer_id', '=', 'tbl_customers.customer_id')
            ->select('tbl_customers.*', 'users.name')
            ->whereNull('tbl_orders.order_customer_id') // means no matching order
            ->Where(function ($query) use ($search) {
                $query->where('customer_name', 'like', $search . '%');
                $query->orwhere('customer_mob', 'like', $search . '%');
                $query->orwhere('customer_mail_id', 'like', $search . '%');
                $query->orwhere('customer_q_id', 'like', $search . '%');
                $query->orwhere('customer_unique_id', 'like', $search . '%');
            });
        if ($colName != '' && $sort != '') {
            $role_data->orderBy($colName, $sort);
        } else {
            $role_data->orderBy('customer_id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $role_data->count(), 'iTotalRecords' => $role_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $role_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);

    }

}
