<?php

namespace App\Http\Controllers;

use App\Models\PromotionalOffers;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use App\Models\categoryModel;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Auth;
use Image;

class categoryController extends Controller
{

    public function __construct()
    {
        ini_set('memory_limit', '44M');
    }

    public function index()
    {

        $data["category_data"] = categoryModel::where('category_status', 0)->orderBy('priority', 'ASC')->get();
        $data['available_languages'] = get_available_language();

        return view('admin.category.index')->with($data);
    }

    public function category_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_category.category_id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $category_data = $roles = categoryModel::where('category_status', 0)
            ->leftjoin('users', 'tbl_category.created_by', 'users.id')
            ->select('tbl_category.*', 'users.name')
            ->Where(function ($query) use ($search) {
                $query->where('category_name', 'like', $search . '%');

            });
        if ($colName != '' && $sort != '') {
            $category_data->orderBy($colName, $sort);
        } else {
            $category_data->orderBy('category_id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $category_data->count(), 'iTotalRecords' => $category_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $category_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }

    public function add_category(Request $request)
    {
        ##########################validation Section ###############################
        //$dynamic_input_required = ['category_name', 'category_banner_heading', 'category_banner_description'];
        $dynamic_input_required = ['category_name'];
        $dynamic_validation_array = validation_array('category', $dynamic_input_required);
        $validation_array = $dynamic_validation_array['validation_array'];
        $custom_validation_array = $dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['image'] = image_validation_rule('category', env('CATEGORYIMAGESIZE'), true, env('CATEGORYIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,max_file_size)
        //$validation_array['category_banner'] = image_validation_rule('category', env('CATEGORYBANNERIMAGESIZE'), true, env('CATEGORYBANNERIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,max_file_size)
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(), $validation_array, $custom_validation_array);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        ########################End Of Validation Section##########################


        $check_exist = categoryModel::where('category_status', 0)->where('category_name', $request->category_name)->first();
        if ($check_exist) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $request->category_name . ' already Exist']);
        }
        $category = new categoryModel();
        $category->category_icon = '';


        //Image Uploading Section
        if ($image = $request->file('image')) {
            $original_file_destination = 'uploads/category_org_images/';
            $desination_path = 'uploads/category_images/';
            $image_resolution = env('CATEGORYIMAGESIZE');
            $catogory_icon = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $category->category_icon = $catogory_icon;


//            $filePath = $image->getPathname();
//            $fileName = $image->getClientOriginalName();
//            $response = Http::withToken('EAASqMLefZAh0BOz1nDXcNxQHttyuJigDQQsZCpFmPZC0qtQ9kYawPnTWvL6PqJB7ZBO3al76kIVZCPIMwVNhLgtRGAIZBZAFZAjNMGUr6oJFiXNoZBD5v15DFspPcn37CVk43QZB4JC4mzcv2qRHy2irRajVetVaPMfI99HhnVgvNfgq6yfoEQV4ThzshygzakE0O8aEWEwRxkl8kP0kqzRiPxLTD2ZAWxeJkjqp2Tm1s6qVxZAhE5wpYZCBfmMZBnjLPv')
//                ->attach('file', fopen($filePath, 'r'), $fileName)  // Better: use fopen
//                ->post("https://graph.facebook.com/v19.0/{304589052739786}/media", [
//                    'messaging_product' => 'whatsapp',
//                ]);
//
//            if ($response->successful()) {
//                return response()->json([
//                    'success' => true,
//                    'media_id' => $response['id'],
//                ]);
//            } else {
//                return response()->json([
//                    'success' => false,
//                    'error' => $response->json(),
//                ], $response->status());
//            }
        }
        //End Of Image Uploading Section

        //Image Uploading Section
        if ($image = $request->file('category_banner')) {
            $original_file_destination = 'uploads/category_org_images/';
            $desination_path = 'uploads/category_images/';
            $image_resolution = env('CATEGORYBANNERIMAGESIZE');
            $image_name = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $category->category_banner = $image_name;
        }
        //End Of Image Uploading Section


        $category->category_ip = $request->ip();
        $category->category_name = $request->category_name_1;
        $category->category_name_ar = $request->category_name_ar;
//        $category->category_banner_heading = $request->category_banner_heading_1;
//        $category->category_banner_description = $request->category_banner_description_1;
        $category->category_permalink = permalink_generator($request->category_name_1);
        //Mutlilanguage Name  section
        $request_para = "category_name_";
        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
        $category->category_name_multi_language = $multi_language_names;
        //End Of Multilanguage name Section
        //Mutlilanguage Banner  Name  section
        $request_para = "category_banner_heading_";
//        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
//        $category->category_multi_banner_heading = $multi_language_names;
        //End Of Multilanguage Banner name Section
        //Mutlilanguage Banner  Description  section
        $request_para = "category_banner_description_";
//        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
//        $category->category_multi_banner_description = $multi_language_names;
        //End Of Multilanguage Banner Description Section

        $category->created_by = Auth::user()->id;
        $category->updated_by = Auth::user()->id;
        $category->save();
        if ($category) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Added";
            $user_activity_log['activity_desc'] = 'New Category ' . $request->category_name_1 . ' Has Been Added By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Category added successfully ']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function edit_category(Request $request)
    {
        $id = $request->id;
        $data = categoryModel::select('*')->where('category_id', $id)->first();
        return response()->json($data);
    }

    public function update_category(Request $request)
    {

        $id = $request->category_id;
        #########################validation Section ###############################
        //$dynamic_input_required = ['category_name', 'category_banner_heading', 'category_banner_description'];
        $dynamic_input_required = ['category_name'];
        $dynamic_validation_array = validation_array('category', $dynamic_input_required);
        $validation_array = $dynamic_validation_array['validation_array'];
        $custom_validation_array = $dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['image'] = image_validation_rule('category', env('CATEGORYIMAGESIZE'), false, env('CATEGORYIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,Ma_file_size)
        //$validation_array['category_banner'] = image_validation_rule('category', env('CATEGORYBANNERIMAGESIZE'), false, env('CATEGORYBANNERIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,Ma_file_size)
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(), $validation_array, $custom_validation_array);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }
        ########################End Of Validation Section##########################

        $check_exists = categoryModel::where('category_status', 0)->where('category_name', $request->category_name_1)->get();
        if (count($check_exists) > 1) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $request->category_name . ' Already Exist']);
        }

        $data = [
            'category_name' => $request->category_name_1,
            'category_name_ar' => $request->category_name_ar,
            'updated_by' => Auth::user()->id,
            'category_banner_heading' => $request->category_banner_heading_1,
            'category_banner_description' => $request->category_banner_description_1,
            'category_permalink' => permalink_generator($request->category_name_1),

        ];
        //Mutlilanguage section
        $request_para = "category_name_";
        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
        $data['category_name_multi_language'] = $multi_language_names;
        //End Of Multilanguage Section
        //Mutlilanguage category banner heading  section
        $request_para = "category_banner_heading_";
//        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
//        $data['category_multi_banner_heading'] = $multi_language_names;
        //End Of Multilanguage category banner heading Section
        //Mutlilanguage category description   section
        $request_para = "category_banner_description_";
//        $multi_language_names = get_mutli_language_json_input($request->all(), $request_para);
//        $data['category_multi_banner_description'] = $multi_language_names;
        //End Of Multilanguage category description  Section

        //Image Uploading Section
        if ($image = $request->file('category_banner')) {
            $original_file_destination = 'uploads/category_org_images/';
            $desination_path = 'uploads/category_images/';
            $image_resolution = env('CATEGORYBANNERIMAGESIZE');
            $image_name = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['category_banner'] = $image_name;
        }
        //End Of Image Uploading Section

        //Image Uploading Section
        if ($image = $request->file('image')) {
            $original_file_destination = 'uploads/category_org_images/';
            $desination_path = 'uploads/category_images/';
            $image_resolution = env('CATEGORYIMAGESIZE');
            $catogory_icon = image_upload($image, $original_file_destination, $desination_path, $image_resolution);
            $data['category_icon'] = $catogory_icon;
        }
        //End Of Image Uploading Section

        $update = categoryModel::where('category_id', $id)->update($data);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Category ' . $request->category_name_1 . ' Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Category updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function delete_category(Request $request)
    {
        $id = $request->id;
        $details = categoryModel::where('category_id', $id)->first();
        $update_category = categoryModel::where('category_id', $id)->update(['category_status' => 1]);
        if ($update_category == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Deleted";
            $user_activity_log['activity_desc'] = 'Category ' . $details->category_name . ' Has Been Deleted By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Category removed successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function change_order(Request $request)
    {
        $catids = $request->catarray;
        $i = 0;
        $catarr = explode(',', $catids);
        foreach ($catarr as $catyy) {
            $i++;

            $update = categoryModel::where('category_id', $catyy)->update(['priority' => $i]);
        }
        return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Category Order Updated ']);

    }

    public function category_view(Request $request)
    {
        $id = $request->id;
        $data['categories'] = categoryModel::where('category_id', $id)->first();
        $category_name_multi_language = json_decode($data['categories']->category_name_multi_language, true);
        $category_banner_name_multi_language = json_decode($data['categories']->category_multi_banner_heading, true);
        $category_banner_description_multi_language = json_decode($data['categories']->category_multi_banner_description, true);
        $available_languages = get_available_language();
        #######################Category Name Multilanguage Section  ############
        $multi_category_name_array = array();
        foreach ($category_name_multi_language as $key => $language_value) {
            foreach ($available_languages as $available_language) {
                // dd($key);
                // dd($available_language['language_id']);
                if ($available_language['language_id'] == $key) {

                    $languag_data = [
                        'language_value' => $language_value,
                        'language_label' => 'Category Name ' . $available_language['language_short_code'],
                        'language_id' => $available_language['language_id'],
                        'language_name' => $available_language['language_name'],
                        'language_short_code' => $available_language['language_short_code'],
                        'language_permalink' => $available_language['language_permalink'],

                    ];
                    array_push($multi_category_name_array, $languag_data);
                    $data['multi_category_name_array'] = $multi_category_name_array;
                }
            }

        }
        #######################End Of Category Name Multilanguage Section  ###########

        #######################Category banner Name Multilanguage Section  ############
        $multi_category_banner_name_array = array();
        foreach ($category_banner_name_multi_language as $key => $language_value) {
            foreach ($available_languages as $available_language) {
                // dd($key);
                // dd($available_language['language_id']);
                if ($available_language['language_id'] == $key) {

                    $languag_data = [
                        'language_value' => $language_value,
                        'language_label' => 'Category Banner  Name ' . $available_language['language_short_code'],
                        'language_id' => $available_language['language_id'],
                        'language_name' => $available_language['language_name'],
                        'language_short_code' => $available_language['language_short_code'],
                        'language_permalink' => $available_language['language_permalink'],

                    ];
                    array_push($multi_category_banner_name_array, $languag_data);
                    $data['multi_category_banner_name_array'] = $multi_category_banner_name_array;
                }
            }

        }
        #######################End Of Category Banner Name Multilanguage Section  ###########


        #######################Category banner Desctiption Multilanguage Section  ############
        $multi_category_banner_description_array = array();
        foreach ($category_banner_description_multi_language as $key => $language_value) {
            foreach ($available_languages as $available_language) {
                // dd($key);
                // dd($available_language['language_id']);
                if ($available_language['language_id'] == $key) {

                    $languag_data = [
                        'language_value' => $language_value,
                        'language_label' => 'Category Banner  Description ' . $available_language['language_short_code'],
                        'language_id' => $available_language['language_id'],
                        'language_name' => $available_language['language_name'],
                        'language_short_code' => $available_language['language_short_code'],
                        'language_permalink' => $available_language['language_permalink'],

                    ];
                    array_push($multi_category_banner_description_array, $languag_data);
                    $data['multi_category_banner_description_array'] = $multi_category_banner_description_array;
                }
            }

        }
        #######################End Of Category Banner Desctiption Multilanguage Section  ###########

        return view('admin.category.modal', compact('data'));

    }

    public function promotional_offers()
    {
        $data["category_data"] = PromotionalOffers::where('promotional_offer_status', 0)->orderBy('id', 'ASC')->get();
        $data['available_languages'] = get_available_language();

        return view('admin.recipe.promotional_offers.index')->with($data);
    }

    public function add_promotional_offers(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
        ]);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        $check_exist = PromotionalOffers::where('promotional_offer_status', 0)
            ->where('title', $request->title)->first();
        if ($check_exist) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $request->title . ' already Exist']);
        }
        $category = new PromotionalOffers();
        $category->title = $request->title;
        $category->description = $request->description;
        $category->from_date = $request->from_date;
        $category->to_date = $request->to_date;
        $category->save();
        if ($category) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Added";
            $user_activity_log['activity_desc'] = 'New Promotional Offers ' . $request->title . ' Has Been Added By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Promotional Offer added successfully ']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function promotional_offers_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_promotional_offers.id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $category_data = $roles = PromotionalOffers::where('promotional_offer_status', 0)
            ->Where(function ($query) use ($search) {
                $query->where('title', 'like', $search . '%');

            });
        if ($colName != '' && $sort != '') {
            $category_data->orderBy($colName, $sort);
        } else {
            $category_data->orderBy('id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $category_data->count(), 'iTotalRecords' => $category_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $category_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }

    public function promotional_offers_view(Request $request)
    {
        $id = $request->id;
        $data['offers'] = PromotionalOffers::find($id);

        return view('admin.recipe.promotional_offers.modal', compact('data'));
    }

    public function edit_promotional_offers(Request $request)
    {
        $id = $request->id;
        $data = PromotionalOffers::find($id);

        return response()->json($data);
    }

    public function update_promotional_offers(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'description' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
        ]);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        $update = PromotionalOffers::find($request->category_id)->update([
            'title' => $request->title,
            'description' => $request->description,
            'from_date' => $request->from_date,
            'to_date' => $request->to_date,
        ]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Promotional Offer ' . $request->title . ' Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Promotional Offer updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }


}
