<?php

namespace App\Http\Controllers;
use App\Models\bannerModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
class bannerController extends Controller
{
    public function index(Request $request){
    $data['available_languages']=get_available_language();
     $data['banners']=bannerModel::orderBy('priority','ASC')->get();
     return view('admin.banner.index')->with($data);
    }
    public function add_banner(Request $request){
          
        ##########################validation Section ###############################
        $dynamic_input_required=['banner_heading','banner_description'];
        $dynamic_validation_array=validation_array('banner',$dynamic_input_required);
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['banner']=image_validation_rule('banner',env('BANNERIMAGESIZE'),true,env('BANNERIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,max_file_size)
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################



        $banner=new bannerModel();
 
        
        //Image Uploading Section
       if ($image = $request->file('banner')) {  
            $original_file_destination='uploads/banner_org_images/';
            $desination_path='uploads/banner_images/';
            $image_resolution=env('BANNERIMAGESIZE');
            $image=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $banner->banner_image =$image;
        }
        //End Of Image Uploading Section


        $banner->banner_ip=$request->ip();
        $banner->banner_status=0;
        $banner->active_status=0;
        $banner->banner_name=$request->banner_heading_1;
        $banner->banner_description=$request->banner_description_1;
        //Mutlilanguage Name  section
           $request_para="banner_heading_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $banner->banner_name_multi=$multi_language_names;
        //End Of Multilanguage name Section

        //Mutlilanguage Banner  Description  section
           $request_para="banner_description_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
            $banner->banner_description_multi=$multi_language_names;
        //End Of Multilanguage Banner Description Section
        
        $banner->created_by=Auth::user()->id;
        $banner->updated_by=Auth::user()->id;
        $banner->save();
        if($banner){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Added";
       $user_activity_log['activity_desc']='New Bannee '.$request->banner_heading_1.' Has Been Added By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Banner added successfully ']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function banner_datatable(Request $request){
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_banner.banner_id';
        $sort = 'DESC';
       if (isset($order[0]['column']) && isset($order[0]['dir'])) {
           $colNo = $order[0]['column'];
           $sort = $order[0]['dir'];
           if (isset($columns[$colNo]['name'])) {
               $colName = $columns[$colNo]['name'];
           }
       }


        $fetch_data = bannerModel::
        leftjoin('users','tbl_banner.created_by','users.id')
        ->select('tbl_banner.*','users.name')
        ->Where(function($query) use ($search) {
            $query->where('banner_name', 'like', $search . '%');
            $query->where('banner_name_multi', 'like', $search . '%');

        });
       if ($colName != '' && $sort != '') {
           $fetch_data->orderBy($colName, $sort);
       }
       else{
         $fetch_data->orderBy('banner_id', 'DESC');
       }
       $data = ['iTotalDisplayRecords' => $fetch_data->count(), 'iTotalRecords' => $fetch_data->count(), 'TotalDisplayRecords' => $limit];
       $data['data'] = $fetch_data->skip($offset)->take($limit)->get()->toArray();
       return response()->json($data);
    }

    public function view_banner(Request $request){
       $id=$request->id;
       $data['banner']=bannerModel::where('banner_id',$id)->first();
       $banner_names=json_decode($data['banner']->banner_name_multi,true);
       $banner_description=json_decode($data['banner']->banner_description_multi,true);
       $available_languages=get_available_language();
    ####################### Name Multilanguage Section  ############
       $multi_banner_name_array=array();
       foreach($banner_names as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
               
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => 'Banner Name '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_banner_name_array,$languag_data);
                $data['multi_banner_name_array']=$multi_banner_name_array;
            }
            }

       }
    #######################End Of  Name Multilanguage Section  ###########



    
    ####################### banner Desctiption Multilanguage Section  ############
       $multi_banner_description_array=array();
       foreach($banner_description as $key=>$language_value){
            foreach($available_languages as $available_language){
                // dd($key);
                // dd($available_language['language_id']);
            if($available_language['language_id']==$key){      
               
                $languag_data=[
                    'language_value' => $language_value,
                    'language_label' => ' Banner  Description '.$available_language['language_short_code'],
                    'language_id' => $available_language['language_id'],
                    'language_name' =>$available_language['language_name'],
                    'language_short_code' =>$available_language['language_short_code'],
                    'language_permalink' => $available_language['language_permalink'],
            
            ];
               array_push($multi_banner_description_array,$languag_data);
                $data['multi_banner_description_array']=$multi_banner_description_array;
            }
            }

       }
    #######################End Of  Banner Desctiption Multilanguage Section  ###########

        return view('admin.banner.modal',compact('data'));
    }
       public function edit_banner(Request $request){    
      $id=$request->id;
      $data=bannerModel::select('*')->where('banner_id',$id)->first();
      return response()->json($data);
    }
    public function update_banner(Request $request){
        $id=$request->banner_id;
        ##########################validation Section ###############################
        $dynamic_input_required=['banner_heading','banner_description'];
        $dynamic_validation_array=validation_array('banner',$dynamic_input_required);
        $validation_array=$dynamic_validation_array['validation_array'];
        $custom_validation_array=$dynamic_validation_array['custom_validation_array'];
        //Add Non Langauge In Put Vldatioon
        $validation_array['banner']=image_validation_rule('banner',env('BANNERIMAGESIZE'),false,env('BANNERIMAGEFILESIZE')); //image Validation (page,imagesize,requiredstatus,max_file_size)
        //End of  No Langauage Vdation push  To  Array
        $validator = Validator::make($request->all(),  $validation_array,$custom_validation_array);

        if ($validator->fails()) { 
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg).'<br>';
            }
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => $error]);
                        } 
        ########################End Of Validation Section##########################
        $data=['banner_name'=>$request->banner_heading_1,
                'banner_description'=>$request->banner_description_1,
                'updated_by'=>Auth::user()->id
                 ];

        //Mutlilanguage Name  section
           $request_para="banner_heading_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
           $data['banner_name_multi']=$multi_language_names;
        //End Of Multilanguage name Section

        //Mutlilanguage Banner  Description  section
           $request_para="banner_description_";
           $multi_language_names=get_mutli_language_json_input($request->all(),$request_para);
            $data['banner_description_multi']=$multi_language_names;
        //End Of Multilanguage Banner Description Section
                //Image Uploading Section
       if ($image = $request->file('banner')) {  
            $original_file_destination='uploads/banner_org_images/';
            $desination_path='uploads/banner_images/';
            $image_resolution=env('BANNERIMAGESIZE');
            $image=image_upload($image,$original_file_destination,$desination_path,$image_resolution);
            $data['banner_image'] =$image;
        }
        //End Of Image Uploading Section

        $update=bannerModel::where('banner_id',$id)->update($data); 
     if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Banner '.$request->banner_heading_1.' Has Been Updated By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Banner updated successfully']);
     }
     else{
         return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
     }
                           
    }
    public function delete_banner(Request $request){
        $id=$request->id;
        $details=bannerModel::where('banner_id',$id)->first();
        $update=bannerModel::where('banner_id',$id)->update(['banner_status'=>1]);
        if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Deleted";
       $user_activity_log['activity_desc']='Banner '.$details->banner_name.' Has Been Deleted By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Banner removed successfully']);
        }
        else{
            return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
        }

    }

    public function change_banner_status(Request $request){
    $id=$request->banner_id;
    $status=$request->status;
    $details=bannerModel::where('banner_id',$id)->first();
    $update=bannerModel::where('banner_id',$id)->update(['active_status'=>$status]);
    $activated_status="Activated";
    if($status==0){ $activated_status="Inactivated";  }
    if($update==1){
       ############################User Activity log#########################
       $user_activity_log['activity_ip']=$request->ip(); 
       $user_activity_log['activity_user_name']=Auth::user()->name;
       $user_activity_log['activity_user_id']=Auth::user()->id; 
       $user_activity_log['activity_action']="Updated";
       $user_activity_log['activity_desc']='Banner '.$details->banner_name.' Has Been '.$activated_status.' By '.Auth::user()->name;
       user_activity_log($user_activity_log);
       ###########################End Of USer Activity Log###################
         return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Banner '.$activated_status.' successfully']);
    }
    else{
          return response()->json(['status' => 1,'heading'=>'Error', 'msg' => 'Something Went Wrong']);
    }
    }

    public function banner_change_order(Request $request){
        $ids = $request->array;
        $i=0;
        $arr = explode(',',$ids);
       
        foreach($arr as $value){
            $i++;
            $update=bannerModel::where('banner_id',$value)->update(['priority' => $i]);
        }
        return response()->json(['status' => 0,'heading'=>'Success', 'msg' => 'Banner Order Updated ']);
        
    }
}