<?php

namespace App\Http\Controllers;

use App\Models\branchModel;
use Illuminate\Http\Request;
use Hash;
use Session;
use App\Models\customerModel;
use App\Models\User;
use App\Models\orderModel;
use App\Models\tableModel;
use Illuminate\Support\Facades\Auth;
use DB;
use Cookie;
use App\Models\recipeModel;
use App\Models\inventoryModel;
use Carbon\Carbon;
use Illuminate\Support\Collection;


use Spatie\Permission\Models\Role;

class authController extends Controller
{
    public function index()
    {
        layout_session(); //Set Layout Themes In Session
        return view('admin.login');
    }

    public function customLogin(Request $request)
    {

        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        $data = [
            'login_attempt_status' => 0,
            'login_attempt_ip' => $request->ip(),
            'login_attempt_email' => $request->email,
            'login_attempt_password' => $request->password,
            'login_attempt_date' => date('Y-m-d'),
            'login_attempt_time' => date('H:i:s'),
            'login_attempt_header_details' => json_encode($request->Header()),

        ];


        $check_user = User::where('u_status', 0)->where('email', $request->email)->first();
        if ($check_user) {
            $recent_attempt = $check_user->user_attempt;
            if ($recent_attempt >= 5) {
                $data['login_attempt_result'] = "Failed";
                DB::table('tbl_login_attempt_log')->insert($data);
                return redirect(env('ADMIN_PANEL_ROUTE'))->witherror('You are Blocked');
            }
        }


        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            if ($request->has('rememberme')) {
                Cookie::queue('adminuser', $request->email, 1440);
                Cookie::queue('adminpwd', $request->password, 1440);
            } else {
                Cookie::queue(Cookie::forget('adminuser'));
                Cookie::queue(Cookie::forget('adminpwd'));


            }

            $update = User::where('id', Auth::user()->id)->update(['user_attempt' => 0]);
            $data['login_attempt_result'] = "Success";
            DB::table('tbl_login_attempt_log')->insert($data);
            return redirect()->intended('admin/dashboard')
                ->withSuccess('Signed in');
        }
        //Check Email Exist

        if ($check_user) {
            $user_id = $check_user->id;
            $recent_attempt = $check_user->user_attempt;
            $attempt = 1;

            if ($recent_attempt > 5) {
                $data['login_attempt_result'] = "Failed";
                DB::table('tbl_login_attempt_log')->insert($data);
                return redirect(env('ADMIN_PANEL_ROUTE'))->witherror('You are Blocked');
            }

            $update_attempt = $recent_attempt + $attempt;
            $update = User::where('id', $user_id)->update(['user_attempt' => $update_attempt]);

        }
        $data['login_attempt_result'] = "Failed";
        DB::table('tbl_login_attempt_log')->insert($data);
        return redirect(env('ADMIN_PANEL_ROUTE'))->witherror('Login details are not valid');
    }

    public function registration()
    {
        return view('auth.registration');
    }

    public function customRegistration(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:6',
        ]);

        $data = $request->all();
        $check = $this->create($data);

        return redirect("admin/dashboard")->withSuccess('You have signed-in');
    }

    public function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password'])
        ]);
    }

    public function dashboard()
    {
        if(Auth::user()->branch_id != 0) {
            $branch_id = branchModel::where('branch_id', Auth::user()->id)->first();

            $data['total_recipe'] = recipeModel::count();  //Total Recipe Count
            $data['total_orders'] = orderModel::where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)->where('order_date', date('Y-m-d'))->count(); //Total revenue
            $data['total_revenue'] = orderModel::where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)->where('order_date', date('Y-m-d'))->sum('order_grand_total'); //Total revenue
            $data['total_customers'] = customerModel::count(); //Total revenue

            $start = Carbon::now()->subDays(7)->startOfDay();
            $end = Carbon::now()->endOfDay();

            $data['graph_data'] = orderModel::selectRaw('DATE(order_date) as date, SUM(order_grand_total) as total')
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->whereBetween('order_date', [$start, $end])
                ->groupBy('date')
                ->get();

            $data['latest_orders'] = orderModel::with('table:table_id,table_name')
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->limit(8)
                ->orderBy('order_id', 'DESC')
                ->get()
                ->toArray();


            $data['trending_recipies'] = recipeModel::select('recipe_name', 'recipe_image', 'recipe_price', 'recipe_offer_price', 'recipe_permalink')->withCount('orderItems')->orderBy('order_items_count', 'desc')->limit(10)->get();

            $data['top_offer_recipies'] = recipeModel::orderByRaw('(recipe_price - recipe_offer_price) DESC')->where('recipe_offer_price', '!=', 0)->limit(10)->get();

            $data['table_live_status'] = tableModel::where('table_status', 0)->where('table_active_status', 0)->get()->toArray();

            $data['topCustomers'] = customerModel::select('customer_name', 'customer_mob', DB::raw('SUM(tbl_inventory.invoice_grand_total) as total_amount'))
                ->join('tbl_inventory', 'tbl_customers.customer_id', '=', 'tbl_inventory.invoice_customer_id')
                ->where('invoice_status', 0)
                ->groupBy('tbl_customers.customer_id')
                ->orderBy('total_amount', 'desc')
                ->take(10)
                ->get();
            $data['today_s_order'] = orderModel::with('table:table_id,table_name',)
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->where('order_date', date('Y-m-d'))->get()->toArray();


            $users = User::role('Super Admin')->where('id', Auth::user()->id)->get();

            //check subscription days
            $data['subscripe_days_left'] = subscription_days_left();
            //Graph Data Starting
            $TD = date('Y-m-d');
            $yestarday = date('Y-m-d', strtotime("-1 days"));
            $scnd_day = date('Y-m-d', strtotime("-2 days"));
            $third_day = date('Y-m-d', strtotime("-3 days"));
            $frth_day = date('Y-m-d', strtotime("-4 days"));
            $fifth_day = date('Y-m-d', strtotime("-5 days"));
            $six_day = date('Y-m-d', strtotime("-6 days"));

            #############sales Graph Data  #####################
            $data['last_six_month_names'] = $this->get_last_six_month_names();
            //Last MonthOrder Amount
            $last_month_order_amount = orderModel::select(DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year'))
                // ->whereYear('order_date', date('Y'))
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->limit(6)
                ->groupBy('month_name', 'year')->get()->toArray();


            $last_month_order_amount = new Collection($last_month_order_amount);
            //Last Month Invoice AMount

            $last_month_invoice_amount = inventoryModel::select(DB::raw('sum(invoice_grand_total) as grand_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year'))
                // ->whereYear('invoice_date', date('Y'))
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->limit(6)
                ->groupBy('month_name', 'year')->get()->toArray();

            $last_month_invoice_amount = new Collection($last_month_invoice_amount);

            $order_amount_array = [];
            $invoice_amount_array = [];
            foreach ($data['last_six_month_names'] as $last_month) {
                $month_name_full = $last_month['fullname'];

                // Find the Order  with the specified Month
                $order_data = $last_month_order_amount->first(function ($order_data) use ($month_name_full) {
                    return $order_data['month_name'] === $month_name_full;
                });

                $order_amount = 0;

                if ($order_data) {
                    if ($order_data['grand_total'] != "" && $order_data['grand_total'] > 0) {
                        $order_amount = $order_data['grand_total'];

                    } else {
                        $order_amount = 0;

                    }

                } else {
                    $order_amount = 0;

                }
                array_push($order_amount_array, $order_amount);

                //Find The Invoice With Specific Month

                $invoice_data = $last_month_invoice_amount->first(function ($invoice_data) use ($month_name_full) {
                    return $invoice_data['month_name'] === $month_name_full;
                });

                $invoice_amount = 0;

                if ($invoice_data) {
                    if ($invoice_data['grand_total'] != "" && $invoice_data['grand_total'] > 0) {
                        $invoice_amount = $invoice_data['grand_total'];

                    } else {
                        $invoice_amount = 0;

                    }

                } else {
                    $invoice_amount = 0;

                }
                array_push($invoice_amount_array, $invoice_amount);

            }
            $data['order_amount_array'] = $order_amount_array;
            $data['invoice_amount_array'] = $invoice_amount_array;
            #############End Of sales Graph Data  #####################

            #########################Todays sale Report  #############
            $data['todays_invoice_payment_type'] = inventoryModel::select(DB::raw('sum(invoice_grand_total) as grand_total'),
                DB::raw('sum(case when invoice_payment_type="Cash"  then invoice_grand_total  end ) as cash_grand_total'),
                DB::raw('sum(case when invoice_payment_type="Card"  then invoice_grand_total  end ) as card_grand_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total  end ) as cash_and_card_grand_total')
            )
                ->where('delivery_type', 1)
                ->where('branch_id', $branch_id->id)
                ->where('invoice_date', date('Y-m-d'))
                ->first();

            ############################End Of Today's Sale Report######
        } else {
            $data['total_recipe'] = recipeModel::count();  //Total Recipe Count
            $data['total_orders'] = orderModel::where('order_date', date('Y-m-d'))->count(); //Total revenue
            $data['total_revenue'] = orderModel::where('order_date', date('Y-m-d'))->sum('order_grand_total'); //Total revenue
            $data['total_customers'] = customerModel::count(); //Total revenue

            $start = Carbon::now()->subDays(7)->startOfDay();
            $end = Carbon::now()->endOfDay();

            $data['graph_data'] = orderModel::selectRaw('DATE(order_date) as date, SUM(order_grand_total) as total')
                ->whereBetween('order_date', [$start, $end])
                ->groupBy('date')
                ->get();

            $data['latest_orders'] = orderModel::with('table:table_id,table_name')
                ->limit(8)
                ->orderBy('order_id', 'DESC')
                ->get()
                ->toArray();


            $data['trending_recipies'] = recipeModel::select('recipe_name', 'recipe_image', 'recipe_price', 'recipe_offer_price', 'recipe_permalink')->withCount('orderItems')->orderBy('order_items_count', 'desc')->limit(10)->get();

            $data['top_offer_recipies'] = recipeModel::orderByRaw('(recipe_price - recipe_offer_price) DESC')->where('recipe_offer_price', '!=', 0)->limit(10)->get();

            $data['table_live_status'] = tableModel::where('table_status', 0)->where('table_active_status', 0)->get()->toArray();

            $data['topCustomers'] = customerModel::select('customer_name', 'customer_mob', DB::raw('SUM(tbl_inventory.invoice_grand_total) as total_amount'))
                ->join('tbl_inventory', 'tbl_customers.customer_id', '=', 'tbl_inventory.invoice_customer_id')
                ->where('invoice_status', 0)
                ->groupBy('tbl_customers.customer_id')
                ->orderBy('total_amount', 'desc')
                ->take(10)
                ->get();
            $data['today_s_order'] = orderModel::with('table:table_id,table_name',)->where('order_date', date('Y-m-d'))->get()->toArray();


            $users = User::role('Super Admin')->where('id', Auth::user()->id)->get();

            //check subscription days
            $data['subscripe_days_left'] = subscription_days_left();
            //Graph Data Starting
            $TD = date('Y-m-d');
            $yestarday = date('Y-m-d', strtotime("-1 days"));
            $scnd_day = date('Y-m-d', strtotime("-2 days"));
            $third_day = date('Y-m-d', strtotime("-3 days"));
            $frth_day = date('Y-m-d', strtotime("-4 days"));
            $fifth_day = date('Y-m-d', strtotime("-5 days"));
            $six_day = date('Y-m-d', strtotime("-6 days"));

            #############sales Graph Data  #####################
            $data['last_six_month_names'] = $this->get_last_six_month_names();
            //Last MonthOrder Amount
            $last_month_order_amount = orderModel::select(DB::raw('sum(case when order_tracking_status="Approved" or  order_tracking_status="Cancelled" or order_tracking_status="Invoiced" then order_grand_total  end ) as grand_total'),
                DB::raw("MONTHNAME(order_date) as month_name"),
                DB::raw('YEAR(order_date) year'))
                // ->whereYear('order_date', date('Y'))
                ->limit(6)
                ->groupBy('month_name', 'year')->get()->toArray();


            $last_month_order_amount = new Collection($last_month_order_amount);
            //Last Month Invoice AMount

            $last_month_invoice_amount = inventoryModel::select(DB::raw('sum(invoice_grand_total) as grand_total'),
                DB::raw("MONTHNAME(invoice_date) as month_name"),
                DB::raw('YEAR(invoice_date) year'))
                // ->whereYear('invoice_date', date('Y'))
                ->limit(6)
                ->groupBy('month_name', 'year')->get()->toArray();

            $last_month_invoice_amount = new Collection($last_month_invoice_amount);

            $order_amount_array = [];
            $invoice_amount_array = [];
            foreach ($data['last_six_month_names'] as $last_month) {
                $month_name_full = $last_month['fullname'];

                // Find the Order  with the specified Month
                $order_data = $last_month_order_amount->first(function ($order_data) use ($month_name_full) {
                    return $order_data['month_name'] === $month_name_full;
                });

                $order_amount = 0;

                if ($order_data) {
                    if ($order_data['grand_total'] != "" && $order_data['grand_total'] > 0) {
                        $order_amount = $order_data['grand_total'];

                    } else {
                        $order_amount = 0;

                    }

                } else {
                    $order_amount = 0;

                }
                array_push($order_amount_array, $order_amount);

                //Find The Invoice With Specific Month

                $invoice_data = $last_month_invoice_amount->first(function ($invoice_data) use ($month_name_full) {
                    return $invoice_data['month_name'] === $month_name_full;
                });

                $invoice_amount = 0;

                if ($invoice_data) {
                    if ($invoice_data['grand_total'] != "" && $invoice_data['grand_total'] > 0) {
                        $invoice_amount = $invoice_data['grand_total'];

                    } else {
                        $invoice_amount = 0;

                    }

                } else {
                    $invoice_amount = 0;

                }
                array_push($invoice_amount_array, $invoice_amount);

            }
            $data['order_amount_array'] = $order_amount_array;
            $data['invoice_amount_array'] = $invoice_amount_array;
            #############End Of sales Graph Data  #####################

            #########################Todays sale Report  #############
            $data['todays_invoice_payment_type'] = inventoryModel::select(DB::raw('sum(invoice_grand_total) as grand_total'),
                DB::raw('sum(case when invoice_payment_type="Cash"  then invoice_grand_total  end ) as cash_grand_total'),
                DB::raw('sum(case when invoice_payment_type="Card"  then invoice_grand_total  end ) as card_grand_total'),
                DB::raw('sum(case when invoice_payment_type="cash&card"  then invoice_grand_total  end ) as cash_and_card_grand_total')
            )
                ->where('invoice_date', date('Y-m-d'))
                ->first();

            ############################End Of Today's Sale Report######
        }

        return view('admin.index', compact('data')); //Admin Dashboard
    }

    public function signOut()
    {
        Session::flush();
        Auth::logout();
        return Redirect('/admin');
    }

    public function get_last_six_month_names()
    {
        $currentDate = Carbon::now();

// Initialize an empty array to store the short month names
        $monthNames = [];

// Loop through the last 6 months
        for ($i = 0; $i < 6; $i++) {
            $shortMonthName = $currentDate->format('M');
            $fullMonthName = $currentDate->format('F');
            $monthNames[$i]['fullname'] = $fullMonthName;
            $monthNames[$i]['shortname'] = $shortMonthName;
            $currentDate->subMonth();
        }
        $monthNames = array_reverse($monthNames);
        return $monthNames;
    }
}
