<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\layoutModel;
use Illuminate\Support\Facades\Validator;
use Auth;

class apiController extends Controller
{
    public function index()
    {
        $data['layout_data'] = layoutModel::first();
        return view('admin.api.index')->with('data', $data);
    }

    public function update_api_integration(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'mail_mailer' => 'required',
            'mail_host' => 'required',
            'mail_port' => 'required',
            'mail_username' => 'required',
            'mail_password' => 'required',
            'mail_encription' => 'required',
            'sms_username' => 'required',
            'sms_password' => 'required',
            'sms_SID' => 'required',
            'sms_m_type' => 'required',

        ]);
        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        try {

            $data = [
                'mail_mailer' => $request->mail_mailer,
                'mail_host' => $request->mail_host,
                'mail_port' => $request->mail_port,
                'mail_username' => $request->mail_username,
                'mail_password' => $request->mail_password,
                'mail_encription' => $request->mail_encription,
                'sms_username' => $request->sms_username,
                'sms_password' => $request->sms_password,
                'sms_sid' => $request->sms_SID,
                'sms_m_type' => $request->sms_m_type,
            ];

            $update = layoutModel::where('layout_status', 0)->update($data);
            if ($update) {

                ###############User Activity log#########################
                $user_activity_log['activity_ip'] = $request->ip();
                $user_activity_log['activity_user_name'] = Auth::user()->name;
                $user_activity_log['activity_user_id'] = Auth::user()->id;
                $user_activity_log['activity_action'] = "Updated";
                $user_activity_log['activity_desc'] = 'API Details  Has Been Updated By ' . Auth::user()->name;
                user_activity_log($user_activity_log);
                ###########################End Of USer Activity Log###################
                return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Automation Updated successfully ']);
            } else {
                return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
            }

        } catch (\Exception $e) {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $e->getMessage()]);

        }


    }
}