<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Imports\RecipeImport;
use App\imports\RecipeImportexcel;
use Maatwebsite\Excel\Facades\Excel;

class RecipeImportController extends Controller
{
    public function showImportForm()
    {
        $data['available_languages']=get_available_language();
        return view('admin.website.import',compact('data'));
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls',
        ]);

        Excel::import(new RecipeImportexcel, $request->file('file'));

        return redirect()->back()->with('success', 'Recipes imported successfully!');
    }
}